/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: klabelaction.cpp,v 1.1 2001/07/23 08:16:59 mkretz Exp $ */

#include "klabelaction.h"

#include <qwhatsthis.h>
#include <qlabel.h>

#include <ktoolbar.h>

KLabelAction::KLabelAction( const QString& text, QObject* parent, const char* name )
	: KAction( text, 0, parent, name )
{
}

KLabelAction::~KLabelAction()
{
}

int KLabelAction::plug( QWidget *w, int index )
{
	if( !w->inherits( "KToolBar" ) )
		return -1;

	KToolBar *toolBar = (KToolBar *)w;
	
	int id = KAction::getToolButtonID();

	QLabel *label = new QLabel( text(), toolBar, "ToolBar Label" );
	toolBar->insertWidget( id, 70, label, index );

	addContainer( toolBar, id );

	connect( toolBar, SIGNAL( destroyed() ), this, SLOT( slotDestroyed() ) );

	toolBar->setItemAutoSized( id, true );

	m_label = label;

	emit plugged();

	QWhatsThis::add( label, whatsThis() );

	return containerCount() - 1;
}

void KLabelAction::unplug( QWidget *w )
{
	if ( !w->inherits( "KToolBar" ) )
		return;

	KToolBar *toolBar = (KToolBar *)w;

	int idx = findContainer( w );

	toolBar->removeItem( menuId( idx ) );

	removeContainer( idx );
	m_label = 0L;
}

#include "klabelaction.moc"

// vim:tw=4:sw=4
