#ifndef _KDEPIANOCONTENT_CPP_
#define _KDEPIANOCONTENT_CPP_

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include <qpixmap.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <klocale.h>

#include "kdePianoContent.h"
#include "kdePianoRollEditor.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeCursor.h"
#include "kdeMainEditor.h"
#include "positionCursor.h"

#include "song.h"
#include "part.h"
#include "note.h"
#include "addElement.h"
#include "removeElement.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "newSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "table.h"
#include "reference.h"
#include "scoreTrack.h"
#include "player.h"
#include "iterator.h"

#define ME ((KdeMainEditor*)mainEditor)

extern Song * sonG;
extern PrMainEditor * mainEditor;
extern Table * selectioN;

int invPcPitch[] = {
  144,143,142,141,140, 138,137,136,135,134,133,132,
  130,129,128,127,126, 124,123,122,121,120,119,118,
  116,115,114,113,112, 110,109,108,107,106,105,104,
  102,101,100,99,98, 96,95,94,93,92,91,90,
  88,87,86,85,84, 82,81,80,79,78,77,76,
  74,73,72,71,70, 68,67,66,65,64,63,62,
  60,59,58,57,56, 54,53,52,51,50,49,48,
  46,45,44,43,42, 40,39,38,37,36,35,34,
  32,31,30,29,28, 26,25,24,23,22,21,20,
  18,17,16,15,14, 12,11,10,9,8,7,6,
  4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


int pcPitch[] = {
  124,123,122,121,120, 120 ,119,118,117,116,115,114,113, 113,
  112,111,110,109,108, 108, 107,106,105,104,103,102,101, 101,
  100,99,98,97,96, 96 ,95,94,93,92,91,90,89, 89,
  88,87,86,85,84, 84, 83,82,81,80,79,78,77, 77,
  76,75,74,73,72, 72, 71,70,69,68,67,66,65, 65,
  64,63,62,61,60, 60, 59,58,57,56,55,54,53, 53,
  52,51,50,49,48, 48, 47,46,45,44,43,42,41, 41,
  40,39,38,37,36, 36, 35,34,33,32,31,30,29, 29,
  28,27,26,25,24, 24, 23,22,21,20,19,18,17, 17,
  16,15,14,13,12, 12, 11,10,9,8,7,6,5, 0,
  4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };

int pNoteTab[] = {
  'h', 'a', 'a', 'g', 'g', 'f', 'f', 'e', 'd', 'd', 'c', 'c'
};

static unsigned char cpr[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};


KdePianoContent::KdePianoContent(QFrame * parent, KdePianoRollEditor * ed , KdeEditorToolBar * tb, KdeEditorNoteBar * nb, KdeEditorButtonBar * bb)
  : QFrame(parent,"content",QFrame::Sunken), _editor(ed), _toolbar(tb), _notebar(nb), _buttonbar(bb), _yscale(4), _yoffset(20),
    _mousey(0), _xoffset(80), _grab(0), _edit(0), _grabX(-1), shftFlag(false), ctrlFlag(false), suprFlag(false)
{
  assert( _editor && _editor->part() ); // we really can't do much without a part

  _ybottom = _yoffset + _yscale*14*8;

  QBitmap cb( 15, 21, cpr, TRUE );
  QBitmap cm( 15, 21, cpr, TRUE );

  prcursor = new QCursor( cb, cm, 0, 19);
  moveWidget = new QFrame(this,"move");
  ((QFrame*)moveWidget)->setFrameStyle( QFrame::Panel | QFrame::Raised );
  moveWidget->setBackgroundMode(QWidget::PaletteBackground);
  moveWidget->hide();

  _position_cursor = new PositionCursor(this,_xoffset);

  rbmenu = new QPopupMenu();
  /* rbmenu->connectItem( rbmenu->insertItem(i18n("flip stem")), this, SLOT(flipStem()) );
     rbmenu->connectItem( rbmenu->insertItem(i18n("flip bow")), this, SLOT(flipBow()) );
     rbmenu->insertSeparator();*/
  rbmenu->connectItem( rbmenu->insertItem(i18n("glue to next note")), this, SLOT(glueNote()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("split note")), this, SLOT(splitNote()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("delete note")), this, SLOT(deleteNote()) );
}

void KdePianoContent::glueNote() {
  if (_edit!=0) {
    sonG->doo(new GlueNote(_edit, _editor->part()));
    _edit = 0;
    repaint(FALSE);
  }
}

void KdePianoContent::splitNote() {
  if (_edit!=0) {
    sonG->doo(new SplitNote(_edit, _editor->part(), _editor->grid()));
    _edit = 0;
    repaint(FALSE);
  }
}

void KdePianoContent::deleteNote() {
  if (_edit!=0) {
    sonG->doo(new RemoveElement(_edit, _editor->part()));
    _edit = 0;
    repaint(FALSE);
  }
}


int KdePianoContent::Pitch(int y) {
  int yy = int((y-_yoffset-2.0)/_yscale);
  // cout << y << " -> " << yy << " -> " << pcPitch[yy] << endl;
  if ((yy>=0)&&(yy<154)) return pcPitch[yy];
  else return 0;
}



int KdePianoContent::mouseY(int p) {
  if (p == -1) return _yoffset + _yscale*invPcPitch[Pitch(_mousey)] + 2;
  else         return _yoffset + _yscale*invPcPitch[Pitch(p)] + 2;
}

int KdePianoContent::mouseKeyShape() {
  switch (Pitch(_mousey)%12) {
  case 0: return 1; break;
  case 1: return 0; break;
  case 2: return 2; break;
  case 3: return 0; break;
  case 4: return 3; break;
  case 5: return 1; break;
  case 6: return 0; break;
  case 7: return 2; break;
  case 8: return 0; break;
  case 9: return 2; break;
  case 10: return 0; break;
  case 11: return 3; break;
  default: return -1; break;
  }
}




// ***************************************************
//
// PAINT EVENT
// ***********
//
//
// paintEvent is called from mouseMoveEvent with pe=0, to speed up the keyboard drawing.
// In this case, only the keyboard is to be drawn!
//

void KdePianoContent::paintEvent(QPaintEvent * pe) {

  setMouseTracking(TRUE);

  int wid = 80;
  if (pe!=0) { QFrame::paintEvent(pe); wid = width(); }

  QPixmap pix( wid, height() );
  pix.fill( this, 10,10 );
  QPainter painter;
  painter.begin( &pix );

  Part * master = sonG->master();
  int met0 = sonG->meter0();
  int met1 = sonG->meter1();
  Position _leftPos = _editor->left();
  Position _rightPos = _editor->right();
  Part * _part = _editor->part();
  const char * name = _editor->PrPartEditor::name();
  ((KdePianoRollEditor*) _editor)->setCaption(name);

  int xxx = width()-20;

  //
  // KeyBoard
  //

  int yl = 0;
  int s;

  // painter.fillRect(24,_yoffset,42,_ybottom-_yoffset,Qt::white);
  painter.drawRect(24,_yoffset,42,_ybottom-_yoffset);
  for (int i=1;i<=int((_ybottom-_yoffset)*0.5/_yscale);i++) {
    yl = _yoffset+i*2*_yscale;
    painter.setPen(SolidLine);
    painter.drawLine(24,yl,24+41,yl);
    s = i % 7;
    if ((s==1)||(s==2)||(s==4)||(s==5)||(s==6)) {
      painter.fillRect(24,yl-2,22,5,black);
      painter.fillRect(34,yl-1,9,1,white);
      painter.fillRect(42,yl,1,1,white);
    } else {
      if (s==3) painter.setPen(SolidLine); else painter.setPen(DashDotLine);
    }
  }

  painter.setPen(SolidLine);

  // mouse-cursor

  int keyY = mouseY();
  int keyshape = mouseKeyShape(); // 0 = black key, 1 = c-shaped, 2 = d-shaped, 3 = e-shaped
  if ((keyY > _yoffset) && (keyY < _ybottom-_yoffset)) {
    switch (keyshape) {
    case 0:  // black
      painter.fillRect(25,keyY,21,5,Qt::red);
      break;
    case 1: // c-shaped
      painter.fillRect(25,keyY+1,21,5,Qt::red);
      painter.fillRect(46,keyY-1,19,7,Qt::red);
      break;
    case 2: // d-shaped
      painter.fillRect(25,keyY+1,21,3,Qt::red);
      painter.fillRect(46,keyY-1,19,7,Qt::red);
      break;
    case 3: // e-shaped
      painter.fillRect(25,keyY-1,21,5,Qt::red);
      painter.fillRect(46,keyY-1,19,7,Qt::red);
      break;
    }
  }


  char help[20];
  int ytxt;
  for (int i=1;i<8;i++) {
    sprintf(help,"c%d",i);
    // c3: yoffset+78*_yscale-7
    ytxt = _yoffset+(8-i)*14*_yscale+27;
    if (ytxt<_ybottom) painter.drawText(8,ytxt,help);
  }

  if (pe!=0) {
    //
    // Right hand side
    //

    // _xoffset = 80;
    long diff = (_rightPos.ticks() - _leftPos.ticks()); // might be 0!
    double pixPerTick = 0.0;
    if (diff != 0)
        pixPerTick = (xxx-_xoffset-4.0) / diff;

    //
    // vertical lines
    //
    long xx;
    int xLeft = -1;
    int xRight = -1;
    int beat;
    int bar;
    int tick;
    Position pos = 0;
    Position add = Position(1,2,0); // one beat!
    char * txt = new char[12];
    bool draw = (pixPerTick > 0);
    bool showNum;


    while (draw) {
      xx = pos.ticks();
      xx = int( ((double)xx * pixPerTick) + _xoffset);
      if (xLeft==-1) xLeft = xx;
      pos.gBBT(bar,beat,tick,master,met0,met1);

      if (beat==1) {
	sprintf(txt,"%d",bar+_leftPos.bar()-1);
	showNum = false;
	if (pixPerTick>0.015625) showNum = true;
	else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
	else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
	else if ((bar&127)==1) showNum = true;
	if (showNum)
            painter.drawText(xx+1,_yoffset-2,txt);
	if ((bar&7)==1) {
            painter.setPen(SolidLine);
            painter.drawLine(xx,_yoffset,xx,_ybottom);
        }
	else if (pixPerTick>0.0008) {
            painter.setPen(DashDotLine);
            painter.drawLine(xx,_yoffset,xx,_ybottom);
        }
      } else {
        if (pixPerTick>0.015625) {
            painter.setPen(DotLine);
            painter.drawLine(xx,_yoffset,xx,_ybottom);
        }
      }


      pos = pos + add;
      if (xx>xxx) draw=false;
      else xRight = xx;
    }
    painter.setPen(SolidLine);
    painter.drawLine(_xoffset,_yoffset,xRight,_yoffset); // draw horizontal borders
    painter.drawLine(_xoffset,_ybottom,xRight,_ybottom);
    //
    // horizontal lines
    //
    yl = 0;
    // painter.drawRect(24,yoffset,52,ybottom-yoffset);
    for (int i=1;i<=int((_ybottom-_yoffset)*0.5/_yscale);i++) {
      yl = _yoffset+i*2*_yscale;
      if (i%7==3)
	painter.setPen(SolidLine);
      else
	painter.setPen(DotLine);
      if (i%7 != 0) painter.drawLine(xLeft,yl,xRight,yl);
    }
    painter.setPen(SolidLine);




    //
    // contents
    //
    int yy = 0;
    int xxLen = 0;
    int len = 0;
    int pi = 10;
    int chan = 0;
    Note * note = 0;
    QColor stdNoteColor = QColor(120,120,120);
    QColor noteColor = stdNoteColor;

    /* JAN _editor->rewind(); // sets left and right position.
    _editor->part()->wind(0);  // only sets left position !
    bool ok = true;
    while (ok) {
      if (_part->currentEndsBehind(_leftPos.ticks())) ok = false;
      else ok = _editor->currentInc();
    }

    ok = true;
    while (ok) {
      Event * event = _part->current();
      if (event!=0) {
	pos = _part->currentPos();
	len = event->length();
	if (event->isA()==NOTE) {
	  note = (Note*) event;
	  pi = note->pitch();
	  chan = note->chan();
	  if ((chan>-1) && (_editor->color())) noteColor = QColor((chan*33)%360,120,240,QColor::Hsv);
	  else noteColor = stdNoteColor;
	}
	
	xx = long((pos-_leftPos)*pixPerTick + _xoffset);
	xxLen = long((pos-_leftPos+len)*pixPerTick + _xoffset)-xx;
	
	if (xx<_xoffset) { xxLen -= _xoffset-xx; xx = _xoffset-1; }
	
	yy = _yoffset + _yscale*invPcPitch[pi] + 1;
	
	
	if (yy+9<_ybottom) {
	  if (selectioN->hasEntry(note)) painter.fillRect(xx+1,yy+1,xxLen-2,_yscale*2-3,Qt::red);
	  else { painter.fillRect(xx+1,yy+1,xxLen-2,_yscale*2-3,noteColor); }
	
	  QColor light(190,190,190);
	  QColor dark(40,40,40);
	  int yyLen = _yscale*2-1;
	  painter.setPen(light);
	  painter.drawLine(xx,yy,xxLen+xx-1,yy);
	  painter.drawLine(xx,yy,xx,yyLen+yy-1);
	  painter.setPen(dark);
	  painter.drawLine(xxLen+xx-1,yy,xxLen+xx-1,yyLen+yy-1);
	  painter.drawLine(xx,yyLen+yy-1,xxLen+xx-1,yyLen+yy-1);
	  painter.setPen(black);
	}
	
      }
      ok = _editor->currentInc();
    }


    _editor->wind(_leftPos); // set back
    */

    for (Iterator i = Iterator(_editor); !i.done(); i++) {
      Event *event = (Event*) *i;
      Part *ptchn = i.change();
      _part = ptchn==0?_part:ptchn;
      if (event!=0) {
	pos = _part->start(event);
	len = event->duration();
	if (event->isA()==NOTE) {
	  note = (Note*) event;
	  pi = note->pitch();
	  chan = note->chan();
	  if ((chan>-1) && (_editor->color())) noteColor = QColor((chan*33)%360,120,240,QColor::Hsv);
	  else noteColor = stdNoteColor;
	}
	
	xx = long((pos-_leftPos)*pixPerTick + _xoffset);
	xxLen = long((pos-_leftPos+len)*pixPerTick + _xoffset)-xx;
	
	if (xx<_xoffset) { xxLen -= _xoffset-xx; xx = _xoffset-1; }
	
	yy = _yoffset + _yscale*invPcPitch[pi] + 1;
	
	if (yy+9<_ybottom) {
	  if (selectioN->hasEntry(note)) painter.fillRect(xx+1,yy+1,xxLen-2,_yscale*2-3,Qt::red);
	  else { painter.fillRect(xx+1,yy+1,xxLen-2,_yscale*2-3,noteColor); }
	
	  QColor light(190,190,190);
	  QColor dark(40,40,40);
	  int yyLen = _yscale*2-1;
	  painter.setPen(light);
	  painter.drawLine(xx,yy,xxLen+xx-1,yy);
	  painter.drawLine(xx,yy,xx,yyLen+yy-1);
	  painter.setPen(dark);
	  painter.drawLine(xxLen+xx-1,yy,xxLen+xx-1,yyLen+yy-1);
	  painter.drawLine(xx,yyLen+yy-1,xxLen+xx-1,yyLen+yy-1);
	  painter.setPen(black);
	}

      }
    }

  }

  // cout << "sel: \n" << *selectioN << endl;

  //
  // selection frame
  //
  if (_grabX > -1) {
    painter.setPen(Qt::DashLine);
    if (_grab==0)
      painter.drawRect(_pressX,_pressY,_moveX-_pressX,_moveY-_pressY);
    painter.setPen(Qt::SolidLine);
  }

  painter.end();
  bitBlt( this, 0, 0, &pix );
  _notebar->update();

}



// ***************************************************
//
// MOUSE EVENT
// ***********
//
//

void KdePianoContent::mousePressEvent( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_pressX-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_pressY);
  if (me->button()==RightButton) {
    //
    // right button: context menu
    //
    _edit = _editor->getGrabNote(pos,pitch,_edit_length);
    if (_edit) rbmenu->popup( mapToGlobal(me->pos()), 0 );
  } else {
    //
    // left button
    //
    _grab = _editor->getGrabNote(pos,pitch,_edit_length);
    _grabY = mouseY();
    _grabX = int((_pressX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
    if (_grabX < 0) _grabX = 0;
    if (_grab!=0) {
      setCursor(ctrlFlag ? KdeCursor(KdeCursor::handCopy)
		: KdeCursor(KdeCursor::hand));
      _grabW = int(_grab->duration()*pixPerTick);
    moveWidget->setGeometry(_pressX-2, _grabY-2, _grabW, _yscale+4);
    }
  }
}


void KdePianoContent::mouseMoveEvent( QMouseEvent * me ) {
  setFocus();
  _moveX = me->x();
  _moveY = me->y();
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  long mpos = long((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_moveY);
  bool el = false;
  Note * over = _editor->getGrabNote(mpos,pitch,el);

  if (_moveY!=_mousey) {
    _mousey = _moveY;
    paintEvent(0);
  }
  if (_grab!=0) { // NOTE GRABBED
    int y = mouseY()-2;
    if (shftFlag) y = _grabY-2;
    moveWidget->move(_moveX-2, y);
    if ((!moveWidget->isVisible()) && (!_edit_length)) moveWidget->show();
  } else {        // FREE
    _edit_length = el;
    if (_moveX > _xoffset) {
      if (_grabX > -1) {
	setCursor(QCursor(2));                          // CURSOR crosshair
	repaint(FALSE);
      } else {
	if (over) {
	  if (_edit_length) setCursor(QCursor(6));      // CURSOR horizontal resize
	  else              setCursor(QCursor(13));     // CURSOR pointing hand
	}
	else setCursor(*prcursor);                      // CURSOR pen
      }
    } else setCursor(QCursor(1));                       // CURSOR arrow up
  }
  if (_moveX > _xoffset-20 && _moveX < _xoffset) _moveX = _xoffset;
  if (_moveX > _xoffset) {
    int bar=0; int beat=0; int tick=0;
    sonG->bbt(bar,beat,tick,Position(pos));
    _buttonbar->setPos(bar,beat,tick);
  }
  _buttonbar->setPitch(pitch,false,false); // the 2.nd and 3.rd arguments are for score editing!
}


void KdePianoContent::mouseReleaseEvent( QMouseEvent * me ) {
  setCursor(QCursor(*prcursor));                        // CURSOR pen
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((me->x()-_xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(me->y());
  int _grabY2 = mouseY();
  long _grabX2 = long((_moveX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
  Part * pt = _editor->part();
  ScoreTrack * tr = (ScoreTrack*) pt->track();

  if (_grab!=0) { // GRABBED NOTE
    if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // select
      if (shftFlag) {
	if (selectioN->hasEntry(_grab)) sonG->doo(new RemoveFromSelection(new Reference(_grab)));
	else                            sonG->doo(new AddToSelection(new Reference(_grab)));
      } else                            sonG->doo(new NewSelection(new Reference(_grab)));
    } else { // edit event
      if (_edit_length) { // edit length
	int len = pos - _editor->part()->start(_grab).ticks();
	// cout << len << endl;
	sonG->doo(new ChangeNote(_grab,_editor->part(),_grab->pitch(),len));
      } else {
	if (ctrlFlag) { // copy event
	  if (shftFlag) sonG->doo(new CopyEvent(Position(pos), _grab, _editor->part()));
	  else          sonG->doo(new CopyEvent(Position(pos), _grab, _editor->part(), pitch));
	} else {        // move event
	  if (shftFlag) sonG->doo(new MoveEvent(Position(pos), _grab, _editor->part()));
	  else          sonG->doo(new MoveEvent(Position(pos), _grab, _editor->part(), pitch));
	}
      }
    }
    moveWidget->hide();
  } else {      // FREE SPACE
    if (me->x() < _xoffset) {
      if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
    } else if (abs(_grabY-_grabY2)<4) { // new Note
      if (pitch>0) {
	long myLen = _editor->snap(_grabX2-_grabX);
	if (myLen<_editor->grid()*0.5) myLen = _editor->totalLength();
	if (sonG->editorAppearance()==ADJUSTPARAMETERS) { _editor->setLength(myLen); _buttonbar->setLength(_editor->lengthOrd(),_editor->dot(),_editor->tuplet()!=0); }
	if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
	sonG->doo(new AddElement(new Note(pitch,_editor->velocity(),myLen,_editor->snap(_grabX)-_editor->part()->start(),_editor->enharmonicShift()),_editor->part()));
      }
    } else { // selection
      if (shftFlag) sonG->doo(new AddToSelection(_editor->part()->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
      else          sonG->doo(new NewSelection(_editor->part()->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
    }
    _grab = 0;
    _grabX = -1;
    _editor->repaint(FALSE);
  }
  _grab = 0;
  _grabX = -1;
  // _editor->repaint(FALSE);
}





// ***************************************************
//
// KEY EVENT
// *********
//
//


void KdePianoContent::keyPressEvent ( QKeyEvent * key ) {

  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();

  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
      long pos = _editor->snap((_moveX-_xoffset)/pixPerTick) + _editor->left().ticks();
      _toolbar->setInsertPoint(pos);
    }
    break;
  case Key_Super_L:
    suprFlag = TRUE;
    break;
  case Key_Shift:
    shftFlag = TRUE;
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    if (_grab!=0) setCursor(KdeCursor( KdeCursor::handCopy ));
    break;
  case Key_Left:
    _editor->moveselleft();
    break;
  case Key_Right:
    _editor->moveselright();
  break;

  case Key_PageUp:
    _editor->moveUp();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_PageDown:
    _editor->moveDown();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_Up:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() + 1));
    }
    break;
  case Key_Down:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() - 1));
    }
    break;
  case Key_Enter:
    if (_editor->part()!=0) {
      // sonG->play(0,_editor->part(),_editor->left().ticks(),_editor->right().ticks());
      sonG->play(0,_editor->part(),_editor->left().ticks(),sonG->right().ticks());
    }
    break;
  case Key_Insert:
  case Key_0:
    ME->slotStop();
    break;
  default:
    key->ignore();
  }
  // repaint( FALSE );
}


void KdePianoContent::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Escape:
    // this is here, because keyPressEvent is not thrown for esc without shift, alt or meta...
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    repaint(FALSE);
    break;
  case Key_Space:
    if (key->state()==AltButton) {
    }
    break;
  case Key_Shift:
    shftFlag = FALSE;
    break;
  case Key_Control:
    ctrlFlag = FALSE;
    if (_grab!=0) setCursor(KdeCursor( KdeCursor::hand ));
    break;
  case Key_Super_L:
    suprFlag = FALSE;
    break;
  default:
    key->ignore();
  }
}

void KdePianoContent::moveCursor(int ticks) {
  double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = long((ticks-_editor->left().ticks())*pixPerTick);
  if (pos>width()-24) {
    _editor->moveleft(_editor->numberOfBars());
  }
  _position_cursor->move(pos-3);

}

// vim:ts=8:sts=2:et:sw=2

#endif
#include "kdePianoContent.moc"
