#ifndef _SPLITPART_CPP_
#define _SPLITPART_CPP_

#include <iostream.h>

#include "splitPart.h"
#include "element.h"
#include "compound.h"

#include "event.h"
#include "part.h"
#include "track.h"
#include "song.h"

extern Song * sonG;

SplitPart::SplitPart(Position p, Part * pt) : _part(pt), _newpart(0), _relpos(p-pt->start()) {
  _type = SPLITPART;
  _description = "split part";
  _to_be_undone = true;

  Event * newstart = _part->partSplit(_relpos);
  if (newstart!=0) {
    _newpart = new Part(_part->track());
    Position offset = _part->start(newstart);
    _newpart->setStart(offset);
    for (Event * ev = newstart; ev != 0; ev = (Event*) _newpart->next(ev))
      ev->setInternalStart(ev->internalStart() - offset);
    _newpart->setContent(newstart);
    _part->track()->add(_newpart);
  }
}

SplitPart::SplitPart(const SplitPart& el) : Operation(el) {
  _type = SPLITPART;
  _part = el._part;
  _relpos = el._relpos;
}

SplitPart::~SplitPart() {
  delete _newpart;
}

void SplitPart::undo() {
  if (_part != 0) {
    _newpart = _part->partGlue();
    _newpart->hide();
  }
}

void SplitPart::redo() {
  Event * newstart = _part->partSplit(_relpos);
  if (newstart!=0) {
    // _newpart = new Part(_part->track());
    Position offset = _part->start(newstart);
    _newpart->setStart(offset);
    _newpart->show();
    for (Event * ev = newstart; ev != 0; ev = (Event*) _newpart->next(ev))
      ev->setInternalStart(ev->internalStart() - offset);
    _newpart->setContent(newstart);
    _part->track()->add(_newpart);
  }
  _newpart = 0;
}



// ---------------
// virtuals:
//

ostream & SplitPart::print(int dep, ostream & s) const {
  s << spc(dep) << "<SPLITPART part=\"" << _part << "\" pos=\"" << _relpos << "\" />" << endl;
  return s;
}

void SplitPart::flush(const char * c) const {
  cout << c << "SPLITPART" << endl;
}

Element * SplitPart::copy() const {
  return new SplitPart(*this);
}


#endif
