#ifndef _SPLITNOTE_CPP_
#define _SPLITNOTE_CPP_

#include <iostream.h>

#include "splitNote.h"
#include "element.h"
#include "compound.h"
#include "reference.h"

#include "event.h"
#include "part.h"
#include "track.h"
#include "song.h"
#include "note.h"

extern Song * sonG;
extern Table * selectioN;

SplitNote::SplitNote(Note * nt, Part * pt, int grid) : _note(nt), _part(pt), _delete(0), _grid(grid) {
  _type = SPLITNOTE;
  _description = "split note";
  _to_be_undone = true;
  int diff = _note->duration() - _grid;
  if (_note && diff>0) {
    _note->setDuration(_grid);
    _next = new Note(*_note);
    _next->setInternalStart(_note->internalStart() + _grid);
    _next->setDuration(diff);
    _part->insertAfter(_next, _note);
  }
}

SplitNote::SplitNote(const SplitNote& el) : Operation(el) {
  _type = SPLITNOTE;
  _note = el._note;
  _part = el._part;
  _next = el._next;
  _grid = el._grid;
  _delete = el._delete;
}

SplitNote::~SplitNote() {
  if (_delete!=0) {
    delete _delete;
  }
}

void SplitNote::undo() {
  if (_note) {
    _next = (Note*) _part->next(_note);
    _part->remove(_next);
    _note->setDuration(_note->duration() + _next->duration());
    _delete = _next;
  }
}

void SplitNote::redo() {
  if (_note) {
    _part->insertAfter(_next,_note);
    _note->setDuration(_note->duration() - _grid);
    _delete = 0;
  }
}



// ---------------
// virtuals:
//

ostream & SplitNote::print(int dep, ostream & s) const {
  s << spc(dep) << "<SPLITNOTE note=\"" << _note << "\" _part=\"" << _part << "\" />" << endl;
  return s;
}

void SplitNote::flush(const char * c) const {
  cout << c << "SPLITNOTE" << endl;
}

Element * SplitNote::copy() const {
  return new SplitNote(*this);
}




#endif
