#ifndef _SELECTLEFT_CPP_
#define _SELECTLEFT_CPP_

#include <iostream.h>

#include "selectLeft.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "part.h"
#include "event.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

SelectLeft::SelectLeft(Part * pt, Position right) : _part(pt) {
  _type = SELECTLEFT;
  _description = "select left";
  _to_be_undone = false;
  _oldTable = 0;
  _delete = 0;
  _size = selectioN->size();
  if (_size==0) {                                  // nothing selected -> select right most event or "right" if specified
    Event * ev = (Event*) _part->last();
    if (right!=0) for (;ev!=0 && _part->start(ev)>=right;ev = (Event*)Element::prev(ev)) {}
    if (!ev) ev = (Event*) _part->last();
    selectioN->add(new Reference(ev));
  } else if (_size==1) {                           // one event selected -> move left
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->prev(ev);
    if (ev==0) ev = _part->last();
    selectioN->add(new Reference(ev));
  } else {                                         // large selection -> select left event from selection
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = new Table();
    selectioN->add(new Reference(((Reference*)_oldTable->first())->getValue()));
  }

}


SelectLeft::SelectLeft(const SelectLeft& el) : Operation(el) {
  _type = SELECTLEFT;
  _part = el._part;
  _oldTable = el._oldTable;
  _delete = el._delete;
  _size = el._size;
}

SelectLeft::~SelectLeft() {
  if (_oldTable!=0) {
    ((Compound*)_oldTable)->scratch();
    delete _oldTable;
  }
}

void SelectLeft::undo() {
  if (_size==0) {
    Reference * r = (Reference*) selectioN->first();
    selectioN->remove(r);
    delete r;
  } else if (_size==1) {
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->next(ev);
    if (ev==0) ev = _part->first();
    selectioN->add(new Reference(ev));
  } else {
    Table * tmp = _oldTable;
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = tmp;
  }
}

void SelectLeft::redo() {
  if (_size==0) {
    selectioN->add(new Reference(_part->last()));
  } else if (_size==1) {
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->prev(ev);
    if (ev==0) ev = _part->last();
    selectioN->add(new Reference(ev));
  } else {
    Table * tmp = _oldTable;
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = tmp;
  }
}



// ---------------
// virtuals:
//

ostream & SelectLeft::print(int dep, ostream & s) const {
  s << spc(dep) << "<SELECTLEFT size=\"" << _size << "\" />" << endl;
  return s;
}

void SelectLeft::flush(const char * c) const {
  cout << c << "SELECTLEFT" << endl;
}

Element * SelectLeft::copy() const {
  return new SelectLeft(*this);
}




#endif
