#ifndef _PRMAINEDITOR_H_
#define _PRMAINEDITOR_H_

#define MAXACTIONS 80
#define MAXEDITORS 20

#include "element.h"

enum { NoBackground, PaperBackground, UserDefinedBackground };

class Addon;
class Track;
class Element;
class PrPartEditor;

typedef Addon * (*OpFunction)(Element*);
typedef char  * (*OpDescriptor)();
typedef char  * (*OpCategory)();
typedef int     (*OpContext)();
typedef Track * (*OpTrack)();

class PrMainEditor
{
 private:
  OpFunction *   _addons;
  char *         _action_list[MAXACTIONS];
  char *         _action_category[MAXACTIONS];
  int            _action_context[MAXACTIONS];
  OpTrack *      _action_track;
  PrPartEditor * _editor_list[MAXEDITORS];
  int            _undo_memory;
  bool           _print_in_partiture;
  bool           _print_in_piano_system;
  int            _grid;
  int            _addon_count;
  int            _editor_background;
  // protected:
  char *         _file_name;
  char *         _project_dir;

 public:
  PrMainEditor(int,char**);
  virtual ~PrMainEditor();
  bool insertAddon(char*);
  void removeAddon(int);
  char ** actionList();
  char * description(int);
  OpTrack actionTrack(int);
  char * actionCategory(int);
  int actionContext(int);
  void performAction(int,Element*);
  char ** categories();
  int * actionListByCategory(char*);

  Track * createAddonTrack(int);
  Track * createAddonTrack(const char *);

  void addEditor(PrPartEditor*);
  void removeEditor(PrPartEditor*);
  PrPartEditor* editor(int);
  void dumpEditors();
  void closeEditors();
  void ui(GuiEvents,bool); // updates buttons, etc
  void ui(); // updates content
  void loadSong(int,char**);
  const char * filename() const { return _file_name; }

  /** Sets the filename to fname after removing the path at the beginning!
   **/
  void setFilename(char * fname);
  int undoMemory();
  void setUndoMemory(int);
  int grid() const { return _grid; }
  void setGrid(int);
  int editorBackground() const { return _editor_background; }
  void setEditorBackground(int);

  virtual void run()=0;
  virtual void update()=0;
  virtual void gui(GuiEvents,bool)=0;
  virtual void startTimer()=0;

  /** fatal errors: these terminate the application */
  enum FatalError { errorArtsConnect, errorArtsMidi, errorArtsMidiRecord };
  virtual void fatalError(FatalError)=0;

  /* printing */

  /** Print-in-Partiture: returns true if this partiture printing is enabled */
  bool PP() const { return _print_in_partiture; }

  /** sets the Print-in-Partiture flag */
  void sPP(bool p);

  /** Print-in-Piano-System: returns true if piano system printing is enabled  */
  bool PPS()  const { return _print_in_piano_system; }

  /** sets the Print-in-Piano-System flag */
  void sPPS(bool p);

  /* Project Stuff */
  const char * projectDir() const { return _project_dir; }
  void setProjectDir(char*);
};

#endif
