#ifndef _ADDSYMBOL_H_
#define _ADDSYMBOL_H_

#include "operation.h"

class Symbol;
class Part;

/** This operation adds a symbol to a part. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class AddSymbol : public Operation
{
 private:
  Symbol * _symbol;
  Part * _part;
  Symbol * _delete;

 public:
  /** example:
   * new AddSymbol(new Expression(0), new Part());
   */
  AddSymbol(Symbol * o, Part * part);
  AddSymbol(const AddSymbol&);
  ~AddSymbol();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
