/***************************************************************************
                          bkutil.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The BkUtil class acts as a container of sorts for various functions   *
 *   operating on the browsers and the master bookmark tree.               *
 *                                                                         *
 ***************************************************************************/

#ifndef BKUTIL_H
#define BKUTIL_H

#include "bridgecfg.h"
#include "bkexcept.h"

class BkUtil
{
public:
	BkUtil(BridgeCfg & cfg);
	~BkUtil();

	void readBookmarksFromBrowsers(void) throw(BkException);
	void readBookmarkTree(void) throw(BkException)
			{ m_cfg.readBookmarksXbel(&m_root); }
	void saveBookmarksToBrowsers(void) const throw(BkException);

	BkFolder *root(void) { return m_root; }

	void setBrowserAsSource(BkFolder &folder, BRWSNUM browserOrd);

private:
	BridgeCfg & m_cfg;
public:
	BkFolder    *m_root;
};

#endif  // end of BKUTIL_H
