/* cmd-tree-version.c
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *               2004 Canonical Ltd
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "config-options.h"
#include "po/gettext.h"
#include "hackerlab/cmd/main.h"
#include "libarch/namespace.h"
#include "libarch/project-tree.h"
#include "commands/tree-version.h"
#include "commands/version.h"
#include "commands/cmdutils.h"



static t_uchar * usage = N_("[options] [NEW VERSION]");

#define OPTS(OP) \
  OP (opt_help_msg, "h", "help", 0, \
      N_("Display a help message and exit.")) \
  OP (opt_long_help, "H", 0, 0, \
      N_("Display a verbose help message and exit.")) \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string\n" \
      "and exit.") \
  OP (opt_dir, "d", "dir DIR", 1, \
      "cd to DIR first")

t_uchar arch_cmd_tree_version_help[] = N_("Print the default version for a project tree\n"
                                        "Print the default version of project tree DIR (or\n"
                                        "the current directory).\n"
                                        "\n"
                                        "(Advanced Usage) If [NEW VERSION] is given, then\n"
                                        "the version of the working tree is changed to the\n"
                                        "supplied one\n");

enum options
{
  OPTS (OPT_ENUM)
};

static struct opt_desc opts[] =
{
  OPTS (OPT_DESC)
    {-1, 0, 0, 0, 0}
};



/* static void */
/* parse_archive_name() */
/* { */
  
/* } */


static void
set_tree_version(t_uchar * program_name, t_uchar * dir, t_uchar * version)
{
  t_uchar * tree_root = arch_tree_root (0, dir, 0);
  t_uchar * fqversion = arch_version_spec_to_fq_version(version);
  arch_set_tree_version (tree_root, fqversion);
}

static void
get_tree_version(t_uchar * program_name, t_uchar * dir)
{
  t_uchar * tree_root;
  t_uchar * answer;
  tree_root = arch_tree_root (0, dir, 0);

  answer = arch_tree_version (tree_root);

  if (!answer)
    {
      safe_printfmt (2, "%s: no default version set\n  tree: %s\n",
                     program_name, tree_root);
      exit (1);
    }

  invariant (arch_valid_package_name (answer, arch_req_archive, arch_req_version, 0));

  safe_printfmt (1, "%s\n", answer);
}

int
arch_cmd_tree_version (t_uchar * program_name, int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;
  char * dir;
  t_uchar * tree_root;

  dir = ".";
  tree_root = 0;

  safe_buffer_fd (1, 0, O_WRONLY, 0);

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, libarch_version_string, arch_cmd_tree_version_help, opt_help_msg, opt_long_help, opt_version);
      if (o == opt_none)
        break;
      switch (o)
        {
        case opt_dir:
          {
            dir = str_save (0, option->arg_string);
            break;
          }

        default:
          safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
          panic ("internal error parsing arguments");

        usage_error:
          opt_usage (2, argv[0], program_name, usage, 1);
          exit (1);

          /* bogus_arg: */
          safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
          goto usage_error;
        }
    }

  if (argc > 2)
    goto usage_error;

  arch_assert_in_tree(program_name, dir);

  if (argc == 2)
    {
      t_uchar * version;
      version = arch_version_spec_to_fq_version(argv[1]);
      set_tree_version(program_name, dir, version);
    }
  else
    get_tree_version(program_name, dir);

  return 0;
}


/* tag: Tom Lord Mon May 12 18:48:04 2003 (tree-version.c)
 */
