/****************************************************************
**
** Attal : Lords of Doom
**
** lord.h
** 
**
** Version : $Id: lord.h,v 1.3 2004/08/08 12:09:27 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 25/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef LORD_H
#define LORD_H
 
 
// generic include files
// include files for QT
#include <qcanvas.h>
// application specific includes
#include "libCommon/genericLord.h"
#include "libCommon/genericCell.h"
#include "libClient/graphicalLord.h"
#include "libClient/graphicalPath.h"
#include "libClient/map.h"

class AttalSocket;

/*              ------------------------------
 *                         Lord
 *              ------------------------------ */

/** comment for the class */
class Lord : public GraphicalLord, public GenericLord
{
 
public:
	/** Constructor */
	Lord( Map * map );
	
	/** Destructor */
	~Lord( );
	
	/** Move the lord at the given cell */
	void moveTo( GenericCell * cell );

	/** Intializes the lord */
	void setPosition( GenericCell * cell );
	
	/** Tell to show (or clear) the path */
	void showPath( bool state = true );
	
	/** Set the destination of the lord */
	void setDestination( GenericCell * cell ) { _dest = cell; }
	
	/** Get the destination of the lord */
	GenericCell * getDestination() { return _dest; }
	
	/** Compute the path */
	void computePath( GenericCell * cell );

	void cleanPath();
	
	/** Follow the path computed */
	void followPath( AttalSocket * socket );

	/** Set the lord visible on the map (or not) */
	void setVisible( bool state );
	
	virtual void setOwner( GenericPlayer * player );
	
private:
	GenericMap * _map;
	GraphicalPath * _showPath;
	GenericCell * _dest;
};
 
#endif // LORD_H   
