/* $Id: Visual.h,v 1.5 2003/03/20 17:23:25 zongo Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARKRNDVISUAL_H
#define ARKRNDVISUAL_H

#include <Ark/ArkCache.h>

#include <Modules/Renderer/ArkRenderer.h>


namespace Ark
{

   /* ============================ GL-Specific functions for textures */
   class ARKRENDERER_DLL_API GLTexture : public Texture
   {
      protected:
	 friend class GLRenderer;

	 uint m_GLID, m_TexFormat;

      public:
	 GLTexture (const Ark::String &name) : Texture (name), m_GLID(0) {}
	 virtual ~GLTexture();

	 /**
	  * Misc load function, which overrides the Loaders one. Upload the
	  * texture to OpenGL.
	  */
	 virtual bool Load (Cache *cache, const String &filename);

	 /// Configures the texture (call SetImage)
	 virtual bool Configure ();
	 void Bind ();
	 uint GetID () {return m_GLID;}

      private:
	 /// Upload the texture to the renderer (call glTexImage2D)
	 bool SetImage(const ImagePtr& img);

   };

   typedef std::vector<GLRenderer*> GLRendererList;

   /// GL-Specific object cache
   class ARKRENDERER_DLL_API GLCache : public Cache
   {
	 friend class GLRenderer;

      private:
	 virtual Object *CreateObject (ObjectType t, const String &name);
	 GLRendererList m_Renderers;

      public:
	 /// Initializes the object cache. Remark : a cache is only valid
	 /// in one OpenGL context, because textures are stored in
	 /// context-memory.
	 /// It is possible to use it across several contexts if these one are
	 /// setup with list sharing (look at the GLX/WGL/AGL documentation for
	 /// more informations on list sharing)
	 GLCache ();
	 ~GLCache();

	 void AddRenderer(GLRenderer *renderer);
	 void RemoveRenderer(GLRenderer *rnd);

	 void ResetTexture (GLTexture *newt);
   };

} // namespace Ark

#endif // ARKRNDVISUAL_H
