/* $Id: HFRender.h,v 1.3 2002/10/12 00:58:46 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Copyright (C) 1999 Amit J. Patel
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef ENGINE_HEIGHTFIELD_RENDER_H
#define ENGINE_HEIGHTFIELD_RENDER_H

#include <Modules/HeightField/ArkHeightField.h>


namespace Ark
{
    // Forward declaration
    class HeightField;
    class Material;
    class Renderer;
    class Vector3;
    class Camera;

   /**
    * The Heighfield render abstract base class
    */
   class ARKHEIGHTFIELD_DLL_API HeightFieldRender
   {

      protected:
	  // Height Field
	  HeightField* m_Heightfield;

	  // Vertex buffer
	  VertexBuffer m_Vertices;
	  
	  /// Levels
	  ///   m_Depth = RoundToPreviousPowerOfTwo( min(HeightField::m_SizeX, HeightField::m_SizeY) );
	  size_t m_Depth;

	  /// The HF X and Z size
	  ///   m_Size = 2^m_Depth + 1;
	  size_t m_Size;

	  /// Number of points
	  ///   m_Points = m_Size^2;
	  size_t m_Points;

      public:
	 HeightFieldRender(HeightField* hf);
	 virtual ~HeightFieldRender() {}
	 
	 virtual void Render(Renderer &renderer, const Camera& camera) = 0;

      protected:
	 void SetVertex(int x, int z, Vector3& coord, Vector3& norm) const;
	 void InitializeVertexBuffer();
	 int GetExtendedHeight(int, int) const;
	 void GetExtendedVector(int, int, Vector3&) const;
	 Material* GetExtendedGround(int, int) const;
   };


} // namespace Ark


#endif // ENGINE_HEIGHTFIELD_RENDER_H
