#ifndef included_dap_ascii_h
#define included_dap_ascii_h

/*****************************************************************************/
/*                                                                           */
/* Copyright (c) 1989-2001 Morgan Stanley Dean Witter & Co. All rights reserved.*/
/* See .../src/LICENSE for terms of distribution.                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/


/* external macro declarations */
#define ASCII_NUL		0
#define ASCII_SOH		1
#define ASCII_STX		2
#define ASCII_ETX		3
#define ASCII_EOT		4
#define ASCII_ENQ		5
#define ASCII_ACK		6
#define ASCII_BEL		7
#define ASCII_BS		8
#define ASCII_HT		9
#define ASCII_NL		10
#define ASCII_VT		11
#define ASCII_NP		12
#define ASCII_CR		13
#define ASCII_SO		14
#define ASCII_SI		15
#define ASCII_DLE		16
#define ASCII_DC1		17
#define ASCII_DC2		18
#define ASCII_DC3		19
#define ASCII_DC4		20
#define ASCII_NAK		21
#define ASCII_SYN		22
#define ASCII_ETB		23
#define ASCII_CAN		24
#define ASCII_EM		25
#define ASCII_SUB		26
#define ASCII_ESC		27
#define ASCII_FS		28
#define ASCII_GS		29
#define ASCII_RS		30
#define ASCII_US		31
#define ASCII_SP		32
#define ASCII_DEL		127

#define ASCII_NUL_ODD	0 + 128
#define ASCII_SOH_ODD	1
#define ASCII_STX_ODD	2
#define ASCII_ETX_ODD	3 + 128
#define ASCII_EOT_ODD	4
#define ASCII_ENQ_ODD	5 + 128
#define ASCII_ACK_ODD	6 + 128
#define ASCII_BEL_ODD	7
#define ASCII_BS_ODD	8
#define ASCII_HT_ODD	9 + 128
#define ASCII_NL_ODD	10 + 128
#define ASCII_VT_ODD	11
#define ASCII_NP_ODD	12 + 128
#define ASCII_CR_ODD	13
#define ASCII_SO_ODD	14
#define ASCII_SI_ODD	15 + 128
#define ASCII_DLE_ODD	16
#define ASCII_DC1_ODD	17 + 128
#define ASCII_DC2_ODD	18 + 128
#define ASCII_DC3_ODD	19
#define ASCII_DC4_ODD	20 + 128
#define ASCII_NAK_ODD	21
#define ASCII_SYN_ODD	22
#define ASCII_ETB_ODD	23 + 128
#define ASCII_CAN_ODD	24 + 128
#define ASCII_EM_ODD	25
#define ASCII_SUB_ODD	26
#define ASCII_ESC_ODD	27 + 128
#define ASCII_FS_ODD	28
#define ASCII_GS_ODD	29 + 128
#define ASCII_RS_ODD	30 + 128
#define ASCII_US_ODD	31
#define ASCII_SP_ODD	32
#define ASCII_DEL_ODD	127

#define ASCII_NUL_EVEN	0
#define ASCII_SOH_EVEN	1 + 128
#define ASCII_STX_EVEN	2 + 128
#define ASCII_ETX_EVEN	3
#define ASCII_EOT_EVEN	4 + 128
#define ASCII_ENQ_EVEN	5
#define ASCII_ACK_EVEN	6
#define ASCII_BEL_EVEN	7 + 128
#define ASCII_BS_EVEN	8 + 128
#define ASCII_HT_EVEN	9
#define ASCII_NL_EVEN	10
#define ASCII_VT_EVEN	11 + 128
#define ASCII_NP_EVEN	12
#define ASCII_CR_EVEN	13 + 128
#define ASCII_SO_EVEN	14 + 128
#define ASCII_SI_EVEN	15
#define ASCII_DLE_EVEN	16 + 128
#define ASCII_DC1_EVEN	17
#define ASCII_DC2_EVEN	18
#define ASCII_DC3_EVEN	19 + 128
#define ASCII_DC4_EVEN	20
#define ASCII_NAK_EVEN	21 + 128
#define ASCII_SYN_EVEN	22 + 128
#define ASCII_ETB_EVEN	23
#define ASCII_CAN_EVEN	24
#define ASCII_EM_EVEN	25 + 128
#define ASCII_SUB_EVEN	26 + 128
#define ASCII_ESC_EVEN	27
#define ASCII_FS_EVEN	28 + 128
#define ASCII_GS_EVEN	29
#define ASCII_RS_EVEN	30
#define ASCII_US_EVEN	31 + 128
#define ASCII_SP_EVEN	32 + 128
#define ASCII_DEL_EVEN	127 + 128

#endif

