1'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_cache.n,v 1.4 2003/04/10 22:01:11 shmooved Exp $
'\"
'\" 
'\" transliterated from index.html by davis@xarg.net 2002-11-10 
'\" but without the useful diagrams from the html.
'\"
.so man.macros

.TH ns_cache n 4.0 AOLserver "AOLserver Built-In Commands"
.BS 
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_cache \- Cache arbitrary data
.SH SYNOPSIS
\fBns_cache create \fIcachename\fR ?\fB-size\fI maxsize\fR?\fR ?\fB-timeout\fI timeout\fR? ?\fB-thread\fI thread\fR?
.sp
\fBns_cache eval \fIcachename key script\fR
.sp
\fBns_cache flush \fIcachename key\fR
.sp
\fBns_cache get \fIcachename key \fR?\fIvarname\fR?
.sp
\fBns_cache names \fIcachename\fR
.sp
\fBns_cache set \fIcachename key value\fR
.BE

.SH DESCRIPTION
.PP
AOLserver implements a C API for caching arbitrary data. This module
provides a Tcl API on top of the C API. The module is only compatible
with nsd8x, not nsd76.
.PP
A cache, in this context, is simply a dictionary that maps keys to
values. Keys are always stored as NUL-terminated strings. How values
are stored depends on the type of cache.
.TP
\fBns_cache create \fIcachename\fR ?\fB-size\fI maxsize\fR?\fR ?\fB-timeout\fI timeout\fR? ?\fB-thread\fI thread\fR?
This command creates a new cache named \fIcachename\fR. If -thread is given
and is true, then it is a thread-private cache. Otherwise it is a
global cache. If \fImaxsize\fR is given, then it is a sized-based
cache. If \fItimeout\fR is given, then it is a timeout-based
cache. Otherwise, it is a timeout-based cache with an infinite timeout,
meaning it will never be flushed.

This command returns nothing if it is successful. 
.TP
\fBns_cache eval \fIcachename key script\fR
This command atomically sets and gets a cache value. First, it looks
up key in the cache named cachename. If it finds an entry, it returns
the value of that entry. Otherwise, it executes script, stores the
return value in the cache, and also returns that value.

Script may optionally use the return command to return its value. For example, this will store the value "2" in mycache, if mykey is not already present:

ns_cache eval mycache mykey { expr {1+1} }

This will also store the value "2" in mycache:

ns_cache eval mycache mykey { return [expr {1+1}] }

If \fIscript\fR raises an error, or exits with break or continue, then
ns_cache eval simply returns the same condition without modifying the
cache. 
.TP
\fBns_cache flush \fIcachename key\fR
This command removes the entry for \fIkey\fR from the cache named
\fIcachename\fR.  If the cache has no entry for \fIkey\fR, then
nothing happens.

For global caches, \fBns_cache flush\fR interacts with
\fBns_cache eval\fR. Suppose thread 1 has called get_thing A and is
executing the long operation to compute the value for A. Thread 2
calls \fBget_thing A\fR and starts waiting for thread 1 to
finish. Thread 3 calls \fBns_cache flush thing_cache
A\fR. Thread 1 will continue executing the long operation, but
thread 2 will also start the long operation. When thread 1 completes
the long operation, \fBns_cache eval\fR returns the (now stale)
value it computed, but it does \fInot\fR store the value in the
cache. When thread 2 completes the long operation, \fBns_cache
eval\fR stores the (fresh) value it computed in the cache and
returns the fresh value.

.TP
\fBns_cache get \fIcachename key \fR?\fIvarname\fR?
This command looks up \fIkey\fR in the specified cache.
It operates differently depending on whether \fIvarname\fR was
given.

If \fIvarname\fR absent and the key exists the value is returned and
if the key is missing an error is raised.  If \fIvarname\fR is
provided and the key exists the command sets \fIvarname\fR to the
value and returns 1, otherwise it returns 0.
.TP
\fBns_cache names \fIcachename\fR
This command returns a list of all keys currently in the specified cache.

If the cache is thread-private, then the list only includes keys that
are in the thread's private cache. 
.TP
\fBns_cache set \fIcachename key value\fR
This command stores value for key in the specified cache.
.SH CACHE TYPES
.PP
ns_cache supports three types of caches:

.B Global Size-Limited Cache

ns_cache create cachename -size maxsize
.PP 
Entries in a cache of this type are accessible to all threads. Each
cache has its own mutex that protects access to its entries.
.PP
Cache values are stored as counted strings, so arbitrary binary data
can be cached. A global cache stores strings instead of Tcl objects to
prevent race conditions that could lead to heap corruption.
.PP
The cache has a maximum size specified when the cache is created. The
size of the cache is the sum of the sizes of all the values in the
cache; keys do not count toward a cache's size. If inserting a value
into the cache makes the cache's size exceed its maximum, then cache
entries are evicted starting with the least-recently used entry until
the size is below the maximum size (or until only the new value
remains in the cache).

.B Global Time-Limited Cache

ns_cache create cachename -timeout timeout
.PP
Entries in a cache of this type are accessible to all threads. Each
cache has its own mutex that protects access to its entries.
.PP
Cache values are stored as counted strings, as in a global
size-limited cache.
.PP
The cache has a maximum entry lifetime, called its \fItimeout\fR, specified
(in seconds) when the cache is created. Every \fItimeout\fR seconds,
AOLserver flushes all cache entries that have not were not created or
accessed in the last \fItimeout\fR seconds.

.B Thread-Private Size-Limited Cache

ns_cache create cachename -size maxsize -thread 1
.PP
Each thread in AOLserver automatically gets its own private cache
named \fIcachename\fR. Since a thread-private cache is only accessed by one
thread, access to it does not require a mutex. Entries in one thread's
cache are not visible to any other thread.
.PP
Cache values are stored as Tcl objects. When a value is stored in the
cache, nscache computes its string form and uses the length of the
string as the size of the value.
.PP
The cache has a maximum size, like a global size-limited
cache. However, because of the way the cache value sizes are computed,
the actual memory usage of the cache values may be several times
larger than \fImaxsize\fR.
.PP
Thread-private caches may offer higher performance if the cached
values are complex objects such as lists or scripts, but require more
storage than global caches.

.SH "SEE ALSO"
Ns_Cache(3), nsv(n)


