/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**  Antenna Visualization Toolkit                                          **/
/**                                                                         **/
/**  Adrian Agogino  agogino@ece.utexas.edu                                 **/
/**  Ken Harker      kharker@cs.utexas.edu                                  **/
/**                                                                         **/
/**  May 1998                                                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#ifndef VIS_WIRES_H
#define VIS_WIRES_H

#include "MyTypes.h"
#include "ant.h"
#include <GL/gl.h>
#include <GL/glu.h>


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                             Definitions                                 **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


extern double  SCALE_FACTOR;      /**  Scale factor for antenna  **/
extern double  TUBE_WIDTH_SCALE;  /**  Tube width scale          **/


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                         Function Prototypes                             **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


void    ComputeColor(double, double, double, GLfloat *);
double  GetBoomLength(Tube *);
double  GetBoomHeight(Tube *);
double  GetBoomWidth(Tube *);
double  GetBoomShift(Tube *);
void    DrawTubeList(Tube *, Tube *, GLint, GLint);
void    DrawTube(Tube *, GLint, GLint);
void    DrawWireCurrentMagnitudeList(Tube *, 
                                     Tube *, 
                                     double, 
                                     double, 
                                     GLint, 
                                     GLint);
void    DrawWireCurrentMagnitude(Tube *, double, double, GLint, GLint);
void    DrawWireCurrentPhaseList(Tube *, Tube *, double, double, GLint, GLint);
void    DrawWireCurrentPhase(Tube *, double, double, GLint, GLint);


#endif


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                          End of VisWires.h                              **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/
