#ifndef _CONVFLAGS_H
#define _CONVFLAGS_H

#include <stdio.h>


#define DEFAULT_NUM_FLAGS  6


class Builder;

struct save_flags {
   long flag6;
   long flag5;
   long flag4;
   long flag3;
   long flag2;
   long flag1;
};

#ifdef CONVFLAGS_C

int null_frozen[] = { -1 };

#else

extern int null_frozen[];

#endif



struct flag_long_int {
   long          flags;
   flag_long_int *next_flag;
};



class Flags
{
public:

   ~Flags();
   Flags();
   Flags(int the_value);
   int copy_flags(Flags *old_flags);
   int operator = (Flags *old_flags);
   int operator = (flag_long_int *old_flags);
   int set_flag(int flag_num);
   int get_flag(int flag_num);
   int clr_flag(int flag_num);
   int write_flag(FILE *the_file);
   int read_flags(FILE *the_file);
   int get_by_name(char *the_name, char *flaglist[]);
   flag_long_int *get_flagstruct(void);
   int set_all(char *flagnames[]);
   int clr_all(char *flagnames[]);
   int set_by_table(int flag_table[]);
   int copy_from_save_struct(save_flags *the_flags);
   int copy_to_save_struct(save_flags *the_flags);

   void clr_frozen(int the_list[]);
   int  is_frozen(int the_list[], int the_flag);

private:

   int copy_flags(flag_long_int *old_flags);

   int           num_flags;
   flag_long_int *flag_list;

};


#endif






