#ifndef _VERBS_H
#define _VERBS_H

#include "verb_formats.h"
#include "comflags.h"
#include "verb.h"
#include "commands.h"
#include "bcommands.h"
#include "jcommands.h"

verb_data playerverb[] = {
  {"list",       VERB_FORMAT_SYS,    COMFLAG_GAMELIST,  listcom},
  {"incognito",  VERB_FORMAT_SYS,    COMFLAG_INCOGNITO, incognitocom},
  {"admininvis", VERB_FORMAT_SYS,    COMFLAG_ADMININVIS,admininviscom},
  {"visible",    VERB_FORMAT_SYS,    COMFLAG_VISIBLE,   visiblecom},
  {"take",       VERB_FORMAT_GET,    COMFLAG_GET,       getcom},
  {"t",          VERB_FORMAT_GET,    COMFLAG_GET,       getcom},
  {"north",      VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"south",      VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"east",       VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"west",       VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"up",         VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"down",       VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"northeast",  VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"northwest",  VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"southeast",  VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"southwest",  VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"ne",         VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"nw",         VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"se",         VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"sw",         VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"n",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"s",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"e",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"w",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"u",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"d",          VERB_FORMAT_LONE,   COMFLAG_GO,        gocom},
  {"go",         VERB_FORMAT_SYS,    COMFLAG_GO,        gocom},
  {"shout",      VERB_FORMAT_COMM,   COMFLAG_SHOUT,     shoutcom},
  {"quit",       VERB_FORMAT_LONE,   COMFLAG_QUIT,      quitcom},
  {"look",       VERB_FORMAT_PREP,   COMFLAG_LOOK,      lookcom},
  {"examine",    VERB_FORMAT_PREP,   COMFLAG_LOOK,      lookcom},
  {"exits",      VERB_FORMAT_LONE,   COMFLAG_EXITS,     exitscom},
  {"users",      VERB_FORMAT_SYS,    COMFLAG_USERS,     userscom},
  {"say",        VERB_FORMAT_COMM,   COMFLAG_SAY,       saycom},
  {"open",       VERB_FORMAT_SYS,    COMFLAG_OPEN,      opencom},
  {"close",      VERB_FORMAT_SYS,    COMFLAG_CLOSE,     closecom},
  {"get",        VERB_FORMAT_GET,    COMFLAG_GET,       getcom},
  {"shutdown",   VERB_FORMAT_SYS,    COMFLAG_SHUTDOWN,  shutdowncom},
  {"bhosts",     VERB_FORMAT_SET,    COMFLAG_BHOSTS,    bhostscom},
  {"banhosts",   VERB_FORMAT_SET,    COMFLAG_BANHOSTS,  banhostscom},
  {"inventory",  VERB_FORMAT_SYS,    COMFLAG_INVENTORY, inventorycom},
  {"drop",       VERB_FORMAT_GET,    COMFLAG_DROP,      dropcom},
  {"comflags",   VERB_FORMAT_FROMTO, COMFLAG_COMFLAGS,  flagscom},
  {"save",       VERB_FORMAT_SYS,    COMFLAG_SAVE,      savecom},
  {"reload",     VERB_FORMAT_FROMTO, COMFLAG_RELOAD,    reloadcom},
  {"lock",       VERB_FORMAT_GIVE,   COMFLAG_LOCK,      doorlockcom},
  {"unlock",     VERB_FORMAT_GIVE,   COMFLAG_UNLOCK,    doorunlockcom},
  {"info",       VERB_FORMAT_SYS,    COMFLAG_INFO,      infocom},
  {"read",       VERB_FORMAT_SYS,    COMFLAG_READ,      readcom},
  {"tell",       VERB_FORMAT_TELL,   COMFLAG_TELL,      tellcom},
  {"move",       VERB_FORMAT_SYS,    COMFLAG_MOVE,      movecom},
  {"push",       VERB_FORMAT_SYS,    COMFLAG_MOVE,      movecom},
  {"pull",       VERB_FORMAT_SYS,    COMFLAG_MOVE,      movecom},
  {"adminflags", VERB_FORMAT_FROMTO, COMFLAG_ADMINFLAG, flagscom},
  {"gameflags",  VERB_FORMAT_FROMTO, COMFLAG_GAMEFLAG,  flagscom},
  {"goto",       VERB_FORMAT_SYS,    COMFLAG_GOTO,      gotocom},
  {"give",       VERB_FORMAT_GET,    COMFLAG_GIVE,      givecom},
  {"autoexits",  VERB_FORMAT_LONE,   COMFLAG_AUTOEXITS, autoexitscom},
  {"color",      VERB_FORMAT_LONE,   COMFLAG_COLOR,     colorcom},
  {"disconnect", VERB_FORMAT_SYS,    COMFLAG_DISCON,    disconnectcom},
  {"wield",      VERB_FORMAT_GET,    COMFLAG_WIELD,     wieldcom},
  {"unwield",    VERB_FORMAT_GET,    COMFLAG_WIELD,     unwieldcom},
  {"put",        VERB_FORMAT_GET,    COMFLAG_PUT,       putcom},
  {"wear",       VERB_FORMAT_SYS,    COMFLAG_WEAR,      wearcom},
  {"remove",     VERB_FORMAT_GET,    COMFLAG_WEAR,      removecom},
  {"stats",      VERB_FORMAT_TELL,   COMFLAG_STATS,     statscom},
  {"eat",        VERB_FORMAT_GET,    COMFLAG_EAT,       eatcom},
  {"drink",      VERB_FORMAT_GET,    COMFLAG_EAT,       eatcom},
  {"light",      VERB_FORMAT_GET,    COMFLAG_LIGHT,     lightcom},
  {"extinguish", VERB_FORMAT_GET,    COMFLAG_LIGHT,     extinguishcom},
  {"kill",       VERB_FORMAT_GET,    COMFLAG_KILL,      killcom},
  {"summon",     VERB_FORMAT_GET,    COMFLAG_SUMMON,    summoncom},
  {"condition",  VERB_FORMAT_LONE,   COMFLAG_CONDITION, conditioncom},
  {"flee",       VERB_FORMAT_GET,    COMFLAG_FLEE,      gocom},
  {"l",          VERB_FORMAT_PREP,   COMFLAG_LOOK,      lookcom},
  {"'",          VERB_FORMAT_COMM,   COMFLAG_SAY,       saycom},
  {";",          VERB_FORMAT_TELL,   COMFLAG_TELL,      tellcom},
  {"help",       VERB_FORMAT_SYS,    COMFLAG_HELP,      helpcom},
  {"i",          VERB_FORMAT_LONE,   COMFLAG_INVENTORY, inventorycom},
  {"emote",      VERB_FORMAT_COMM,   COMFLAG_EMOTE,     emotecom},
  {",",          VERB_FORMAT_COMM,   COMFLAG_EMOTE,     emotecom},
  {"abilities",  VERB_FORMAT_LONE,   COMFLAG_ABILITIES, abilitiescom},
  {"cast",       VERB_FORMAT_GET,    COMFLAG_CAST,      castcom},
  {"perform",    VERB_FORMAT_GET,    COMFLAG_PERFORM,   performcom},
  {"set",        VERB_FORMAT_TELL,   COMFLAG_SET,       setcom},
  {"repeat",     VERB_FORMAT_LONE,   COMFLAG_REPEAT,    repeatcom},
  {"!",          VERB_FORMAT_LONE,   COMFLAG_REPEAT,    repeatcom},
  {"brief",      VERB_FORMAT_LONE,   COMFLAG_BRIEF,     briefcom},
  {"autopay",    VERB_FORMAT_LONE,   COMFLAG_AUTOPAY,   autopaycom},
  {"suggest",    VERB_FORMAT_COMM,   COMFLAG_SUGGEST,   suggestcom},
  {"bug",        VERB_FORMAT_COMM,   COMFLAG_BUG,       bugcom},
  {"typo",       VERB_FORMAT_COMM,   COMFLAG_TYPO,      typocom},
  {"time",       VERB_FORMAT_LONE,   COMFLAG_TIME,      timecom},
  {"who",        VERB_FORMAT_LONE,   COMFLAG_USERS,     userscom},
  {"score",      VERB_FORMAT_LONE,   COMFLAG_CONDITION, conditioncom},
  {"consider",   VERB_FORMAT_GET,    COMFLAG_CONSIDER,  considercom},
  {"diagnose",   VERB_FORMAT_GET,    COMFLAG_EXAMINE,   diagnosecom},
  {"sit",        VERB_FORMAT_SYS,    COMFLAG_SIT,       sitcom},
  {"stand",      VERB_FORMAT_LONE,   COMFLAG_STAND,     standcom},
  {"sleep",      VERB_FORMAT_LONE,   COMFLAG_SLEEP,     sleepcom},
  {"wake",       VERB_FORMAT_LONE,   COMFLAG_STAND,     standcom},
  {"tie",        VERB_FORMAT_GET,    COMFLAG_TIE,       tiecom},
  {"untie",      VERB_FORMAT_GET,    COMFLAG_UNTIE,     untiecom},
  {"syslog",     VERB_FORMAT_COMM,   COMFLAG_SYSLOG,    logcom},
  {"errlog",     VERB_FORMAT_COMM,   COMFLAG_ERRLOG,    logcom},
  {"buglog",     VERB_FORMAT_COMM,   COMFLAG_BUGLOG,    logcom},
  {"typolog",    VERB_FORMAT_COMM,   COMFLAG_TYPOLOG,   logcom},
  {"sugglog",    VERB_FORMAT_COMM,   COMFLAG_SUGGLOG,   logcom},
  {"play",       VERB_FORMAT_GET,    COMFLAG_PLAY,      playcom},
  {"ring",       VERB_FORMAT_GET,    COMFLAG_PLAY,      playcom},
  {"noslain",    VERB_FORMAT_LONE,   COMFLAG_NOSLAIN,   noslaincom},
  {"enter",      VERB_FORMAT_SYS,    COMFLAG_ENTER,     entercom},
  {"leave",      VERB_FORMAT_LONE,   COMFLAG_LEAVE,     leavecom},
  {"fulledit",   VERB_FORMAT_LONE,   COMFLAG_FULLEDIT,  fulleditcom},
  {"describe",   VERB_FORMAT_SET,    COMFLAG_DESCRIBE,  describecom},
  {"mailer",     VERB_FORMAT_COMM,   COMFLAG_MAIL,      mailcom},
  {"pronouns",   VERB_FORMAT_LONE,   COMFLAG_PRONOUNS,  pronounscom},
  {"pager",      VERB_FORMAT_SYS,    COMFLAG_PAGER,     pagercom},
  {"dig",        VERB_FORMAT_COMM,   COMFLAG_DIG,       digcom},
  {"smell",      VERB_FORMAT_SYS,    COMFLAG_SMELL,     smellcom},
  {"fullexits",  VERB_FORMAT_LONE,   COMFLAG_FULLEXITS, fullexitscom},
  {"attributes", VERB_FORMAT_LONE,   COMFLAG_ATTRIBUTES,attributescom},
  {"bulletins",  VERB_FORMAT_GET,    COMFLAG_BULLETIN,  bulletincom},
  {"qinfo",      VERB_FORMAT_GET,    COMFLAG_QINFO,     qinfocom},
  {"quests",     VERB_FORMAT_LONE,   COMFLAG_QUESTS,    questscom},
  {"sockets",    VERB_FORMAT_SYS,    COMFLAG_SOCKET,    socketcom},
  {"autodiagnose", VERB_FORMAT_LONE, COMFLAG_AUTODIAGNOSE, autodiagnosecom},
  {"mask",       VERB_FORMAT_TELL,   COMFLAG_MASK,      maskcom},
  {"slay",       VERB_FORMAT_GET,    COMFLAG_SLAY,      slaycom},
  {"suicide",    VERB_FORMAT_SYS,    COMFLAG_SUICIDE,   deleteuser},
  {"clone",      VERB_FORMAT_GET,    COMFLAG_CLONE,     clonecom},
  {"force",      VERB_FORMAT_TELL,   COMFLAG_FORCE,     forcecom},
  {"boot",       VERB_FORMAT_GET,    COMFLAG_BOOT,      bootcom},
  {"listen",     VERB_FORMAT_SYS,    COMFLAG_LISTEN,    listencom},
  {"weapons",    VERB_FORMAT_LONE,   COMFLAG_WEAPONS,   weaponscom},
  {"classify",   VERB_FORMAT_GET,    COMFLAG_CLASSIFY,  classifycom},
  {NULL, 0, 0, NULL}};


verb_data builderverb[] = {
  {"quit",          VERB_FORMAT_LONE,  COMFLAG_QUIT,        quitcom},
  {"users",         VERB_FORMAT_SYS,   COMFLAG_USERS,       userscom},
  {"load",          VERB_FORMAT_SYS,   COMFLAG_BLDRLOAD,    bldrloadcom},
  {"modify",        VERB_FORMAT_SYS,   COMFLAG_BLDRMODIFY,  bldrmodifycom},
  {"describe",      VERB_FORMAT_SET,   COMFLAG_DESCRIBE,    describecom},
  {"save",          VERB_FORMAT_LONE,  COMFLAG_BLDRSAVE,    bldrsavecom},
  {"set",           VERB_FORMAT_SET,   COMFLAG_BLDRSET,     bldrsetcom},
  {"list",          VERB_FORMAT_SYS,   COMFLAG_BLDRLIST,    bldrlistcom},
  {"commit",        VERB_FORMAT_LONE,  COMFLAG_COMMIT,      commitcom},
  {"new",           VERB_FORMAT_SET,   COMFLAG_BLDRNEW,     bldrnewcom},
  {"delete",        VERB_FORMAT_SET,   COMFLAG_BLDRDELETE,  bldrdeletecom},
  {"info",          VERB_FORMAT_SYS,   COMFLAG_INFO,        infocom},
  {"help",          VERB_FORMAT_SYS,   COMFLAG_HELP,        helpcom},
  {"unload",        VERB_FORMAT_LONE,  COMFLAG_BLDRLOAD,    bldrunloadcom},
  {"copy",          VERB_FORMAT_SYS,   COMFLAG_COPY,        bldrcopycom},
  {"rename",        VERB_FORMAT_SET,   COMFLAG_RENAME,      bldrrenamecom},
  {"autoassociate", VERB_FORMAT_LONE,  COMFLAG_AUTOASSOC,   autoassociate},
  {"sockets",       VERB_FORMAT_SYS,   COMFLAG_SOCKET,      bldrsocketcom},
  {"nospectate",    VERB_FORMAT_SYS,   COMFLAG_NOSPECTATE,  nospectatecom},
  {"spectate",      VERB_FORMAT_SYS,   COMFLAG_SPECTATE,    spectatecom},
  {"admininvis",    VERB_FORMAT_SYS,   COMFLAG_ADMININVIS,  admininviscom},



  {NULL, 0, 0, NULL}};


#endif

