#ifndef _MAILER_H
#define _MAILER_H

#include <stdio.h>
#include "strings.h"

class Inp_Handler;

enum letter_status { Composing, Delivering, Abandoned, NotRead, Read };

int mailer_command_handler(MudObject *the_obj, char *the_input);
int mailer_get_subject(MudObject *the_obj, char *the_input);
int mail_on_pop(Inp_Handler *the_handler, char *player_name, char *notused1, 
                                            char *notused2, Strings *notused3);
int reply_on_pop(Inp_Handler *the_handler, char *player_name, char *old_body, 
                                          char *notused2, Strings *notused3);


class Player;
class Letter;

class Mailer
{
 public:

   ~Mailer();
   Mailer(char *the_username, load_type the_mode);
   int load_mail(load_type the_mode);
   int write_mail(void);
   int delete_mail(void);
   void display_help(Player *the_player);
   Letter *get_current_ltr();
   int remove_current_ltr();
   void set_current_ltr(Letter *new_ltr);
   load_type get_load_mode();
   int add_mail(Letter *the_ltr);
   int delete_mail(int the_num);
   int list_mail(Player *the_player);
   int find_mail(int the_num);
   int has_newmail();
   void clr_newmail();
   void set_newmail();

 private:

   Strings   username;
   Strings   mailfilename;
   FILE      *the_mailfile;
   load_type load_mode;
   Letter    *current_ltr;

   Letter    *loaded_mail;

   int       newmail;
};


class Letter
{
 public:

   ~Letter();
   Letter();
   void set_to(char *the_str);
   void set_from(char *the_str);
   void set_subject(char *the_str);
   void set_body(char *the_str);
   char *get_date();
   char *get_to();
   char *get_from();
   char *get_subject();
   char *get_body();
   int  edit_body(Player *the_player, int is_reply);
   int  deliver_letter(Player *the_player);
   void copy_ltr(Letter *copy_from);
   letter_status get_status();
   void set_status(letter_status new_status);
   Letter *get_next_ltr();
   void set_next_ltr(Letter *new_ltr);
   int write_letter(FILE *the_file);
   int read_letter(FILE *the_file);
   void display_letter(Player *the_player);
   int start_single_reply(Player *the_player);
   int start_multiple_reply(Player *the_player);
   int start_forward(Player *the_player, char *to_who);


 private:

   Strings       date;
   Strings       to;
   Strings       from;
   Strings       subject;
   Strings       body;
   letter_status status;

   Letter    *next_letter;
};


#endif






