/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Olga Rodimina
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 * Russian Version
 */

package com.redhat.rhdb.vise.resources;

import java.util.ListResourceBundle;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

/**
 * ActionResources.java
 *
 *
 * Created: Mon Jul 13 16:43:38 2003
 *
 * @author <a href="mailto:rodimina@redhat.com">Olga Rodimina</a>
 * @version 0.0
 */

public class ActionResources_ru_RU extends ListResourceBundle {

	public Object[][] getContents()
	{
		return contents;
	}

	private static final Object[][] contents = {
		{ ActionResources.NEW_NAME,                "\u041D\u043E\u0432\u044B\u0439" },
		//{ ActionResources.NEW_COMMAND,             "new" },
		{ ActionResources.NEW_SHORTDESC,           "\u041D\u043E\u0432\u044B\u0439" },
		{ ActionResources.NEW_LONGDESC,            "\u041D\u043E\u0432\u044B\u0439" },
		//{ ActionResources.NEW_SMALLICON,           "new16.png" },
		//{ ActionResources.NEW_LARGEICON,           "new24.png" },
		{ ActionResources.NEW_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK) },
		{ ActionResources.NEW_MNEMONIC,            new Integer(KeyEvent.VK_N) },

		{ ActionResources.SAVE_NAME,               "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C" },
		//{ ActionResources.SAVE_COMMAND,            "save" },
		{ ActionResources.SAVE_SHORTDESC,          "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C" },
		{ ActionResources.SAVE_LONGDESC,           "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C" },
		//{ ActionResources.SAVE_SMALLICON,          "save16.png" },
		//{ ActionResources.SAVE_LARGEICON,          "save24.png" },
		{ ActionResources.SAVE_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK) },
		{ ActionResources.SAVE_MNEMONIC,           new Integer(KeyEvent.VK_S) },
		
		{ ActionResources.SAVEAS_NAME,             "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C \u041A\u0430\u043A..." },
		//{ ActionResources.SAVEAS_COMMAND,          "saveas" },
		{ ActionResources.SAVEAS_SHORTDESC,        "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C \u041A\u0430\u043A" },
		{ ActionResources.SAVEAS_LONGDESC,         "\u0421\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C \u041A\u0430\u043A" },
		//{ ActionResources.SAVEAS_SMALLICON,        "saveas16.png" },
		//{ ActionResources.SAVEAS_LARGEICON,        "saveas24.png" },
		{ ActionResources.SAVEAS_MNEMONIC,         new Integer(KeyEvent.VK_A) },
		{ ActionResources.SAVEAS_MNEMONIC_INDEX,   new Integer(5) },

		{ ActionResources.OPEN_NAME,               "\u041E\u0442\u043A\u0440\u044B\u0442\u044C..." },
		//{ ActionResources.OPEN_COMMAND,            "open" },
		{ ActionResources.OPEN_SHORTDESC,          "\u041E\u0442\u043A\u0440\u044B\u0442\u044C" },
		{ ActionResources.OPEN_LONGDESC,           "\u041E\u0442\u043A\u0440\u044B\u0442\u044C" },
		//{ ActionResources.OPEN_SMALLICON,          "open16.png" },
		//{ ActionResources.OPEN_LARGEICON,          "open24.png" },
		{ ActionResources.OPEN_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OPEN_MNEMONIC,           new Integer(KeyEvent.VK_O) },

		{ ActionResources.CUT_NAME,                "\u0412\u044B\u0440\u0435\u0437\u0430\u0442\u044C" },
		//{ ActionResources.CUT_COMMAND,             "cut" },
		{ ActionResources.CUT_SHORTDESC,           "\u0412\u044B\u0440\u0435\u0437\u0430\u0442\u044C" },
		{ ActionResources.CUT_LONGDESC,            "\u0412\u044B\u0440\u0435\u0437\u0430\u0442\u044C" },
		//{ ActionResources.CUT_SMALLICON,           "cut16.png" },
		//{ ActionResources.CUT_LARGEICON,           "cut24.png" },
		{ ActionResources.CUT_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK) },
		{ ActionResources.CUT_MNEMONIC,            new Integer(KeyEvent.VK_T) },

		{ ActionResources.COPY_NAME,               "\u041A\u043E\u043F\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		//{ ActionResources.COPY_COMMAND,            "copy" },
		{ ActionResources.COPY_SHORTDESC,          "\u041A\u043E\u043F\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		{ ActionResources.COPY_LONGDESC,           "\u041A\u043E\u043F\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		//{ ActionResources.COPY_SMALLICON,          "copy16.png" },
		//{ ActionResources.COPY_LARGEICON,          "copy24.png" },
		{ ActionResources.COPY_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.COPY_MNEMONIC,           new Integer(KeyEvent.VK_C) },

		{ ActionResources.PASTE_NAME,              "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044C" },
		//{ ActionResources.PASTE_COMMAND,           "paste" },
		{ ActionResources.PASTE_SHORTDESC,         "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044C" },
		{ ActionResources.PASTE_LONGDESC,          "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044C" },
		//{ ActionResources.PASTE_SMALLICON,         "paste16.png" },
		//{ ActionResources.PASTE_LARGEICON,         "paste24.png" },
		{ ActionResources.PASTE_ACCELERATOR,       KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK) },
		{ ActionResources.PASTE_MNEMONIC,          new Integer(KeyEvent.VK_P) },

		{ ActionResources.MANUAL_NAME,             "\u0421\u043F\u0440\u0430\u0432\u043E\u0447\u043D\u0438\u043A" },
		//{ ActionResources.MANUAL_COMMAND,          "manual" },
		{ ActionResources.MANUAL_SHORTDESC,        "\u0421\u043F\u0440\u0430\u0432\u043E\u0447\u043D\u0438\u043A" },
		{ ActionResources.MANUAL_LONGDESC,         "\u0421\u043F\u0440\u0430\u0432\u043E\u0447\u043D\u0438\u043A" },
		//{ ActionResources.MANUAL_SMALLICON,        "help16.png" },
		//{ ActionResources.MANUAL_LARGEICON,        "help24.png" },
		//{ ActionResources.MANUAL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0) },
		{ ActionResources.MANUAL_MNEMONIC,         new Integer(KeyEvent.VK_M) },

		{ ActionResources.ABOUT_NAME,              "\u041F\u0440\u043E..." },
		//{ ActionResources.ABOUT_COMMAND,           "about" },
		{ ActionResources.ABOUT_SHORTDESC,         "\u041F\u0440\u043E" },
		{ ActionResources.ABOUT_LONGDESC,          "\u041F\u0440\u043E" },
		//{ ActionResources.ABOUT_SMALLICON,         "about16.png" },
		//{ ActionResources.ABOUT_LARGEICON,         "about24.png" },
		{ ActionResources.ABOUT_MNEMONIC,          new Integer(KeyEvent.VK_A) },

		{ ActionResources.EXIT_NAME,               "\u0412\u044B\u0445\u043E\u0434" },
		//{ ActionResources.EXIT_COMMAND,            "exit" },
		{ ActionResources.EXIT_SHORTDESC,          "\u0412\u044B\u0445\u043E\u0434" },
		{ ActionResources.EXIT_LONGDESC,           "\u0412\u044B\u0445\u043E\u0434" },
		//{ ActionResources.EXIT_SMALLICON,          "exit16.png" },
		//{ ActionResources.EXIT_LARGEICON,          "exit24.png" },
		{ ActionResources.EXIT_MNEMONIC,           new Integer(KeyEvent.VK_X) },

		{ ActionResources.EXPLAIN_NAME,            "Explain" },
		//{ ActionResources.EXPLAIN_COMMAND,         "explain" },
		{ ActionResources.EXPLAIN_SHORTDESC,       "Explain" },
		{ ActionResources.EXPLAIN_LONGDESC,        "\u041E\u0431\u044A\u044F\u0441\u043D\u0438\u0442\u044C" },
		//{ ActionResources.EXPLAIN_SMALLICON,       "explain16.png" },
		//{ ActionResources.EXPLAIN_LARGEICON,       "explain24.png" },
		{ ActionResources.EXPLAIN_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EXPLAIN_MNEMONIC,        new Integer(KeyEvent.VK_E) },

		{ ActionResources.PREFERENCES_NAME,        "\u041F\u0440\u0435\u0434\u043F\u043E\u0447\u0442\u0435\u043D\u0438\u044F..." },
		//{ ActionResources.PREFERENCES_COMMAND,     "preferences" },
		{ ActionResources.PREFERENCES_SHORTDESC,   "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u041F\u0440\u0435\u0434\u043F\u043E\u0447\u0442\u0435\u043D\u0438\u044F" },
		{ ActionResources.PREFERENCES_LONGDESC,    "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u041F\u0440\u0435\u0434\u043F\u043E\u0447\u0442\u0435\u043D\u0438\u044F" },
		//{ ActionResources.PREFERENCES_SMALLICON,   "prefs16.png" },
		//{ ActionResources.PREFERENCES_LARGEICON,   "prefs24.png" },
		{ ActionResources.PREFERENCES_MNEMONIC,    new Integer(KeyEvent.VK_F) },

		{ ActionResources.DATABASES_NAME,          "\u0411\u0430\u0437\u0430 \u0414\u0430\u043D\u043D\u044B\u0445..." },
		//{ ActionResources.DATABASES_COMMAND,       "databases" },
		{ ActionResources.DATABASES_SHORTDESC,     "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u0431\u0430\u0437\u0443 \u0434\u0430\u043D\u043D\u044B\u0445" },
		{ ActionResources.DATABASES_LONGDESC,      "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u0431\u0430\u0437\u0443 \u0434\u0430\u043D\u043D\u044B\u0445" },
		{ ActionResources.DATABASES_MNEMONIC,      new Integer(KeyEvent.VK_D) },

		{ ActionResources.PLANNEROPTIONS_NAME,      "\u041E\u043F\u0446\u0438\u0438 \u041F\u043B\u0430\u043D\u0438\u0440\u043E\u0432\u0449\u0438\u043A\u0430..." },
		//{ ActionResources.PLANNEROPTIONS_COMMAND,   "planneroptions" },
		{ ActionResources.PLANNEROPTIONS_SHORTDESC, "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u041E\u043F\u0446\u0438\u0438 \u041F\u043B\u0430\u043D\u0438\u0440\u043E\u0432\u0449\u0438\u043A\u0430" },
		{ ActionResources.PLANNEROPTIONS_LONGDESC,  "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u041E\u043F\u0446\u0438\u0438 \u041F\u043B\u0430\u043D\u0438\u0440\u043E\u0432\u0449\u0438\u043A\u0430" },
		{ ActionResources.PLANNEROPTIONS_MNEMONIC,  new Integer(KeyEvent.VK_O) },

		{ ActionResources.ZOOMIN_NAME,             "\u0423\u0432\u0435\u043B\u0438\u0447\u0438\u0442\u044C" },
		//{ ActionResources.ZOOMIN_COMMAND,          "zoomin" },
		{ ActionResources.ZOOMIN_SHORTDESC,        "\u0423\u0432\u0435\u043B\u0438\u0447\u0438\u0442\u044C" },
		{ ActionResources.ZOOMIN_LONGDESC,         "\u0423\u0432\u0435\u043B\u0438\u0447\u0438\u0442\u044C" },
		//{ ActionResources.ZOOMIN_SMALLICON,        "zoomin16.png" },
		//{ ActionResources.ZOOMIN_LARGEICON,        "zoomin24.png" },
		{ ActionResources.ZOOMIN_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_EQUALS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMIN_MNEMONIC,         new Integer(KeyEvent.VK_I) },

		{ ActionResources.ZOOMOUT_NAME,            "\u0423\u043C\u0435\u043D\u044C\u0448\u0438\u0442\u044C" },
		//{ ActionResources.ZOOMOUT_COMMAND,         "zoomout" },
		{ ActionResources.ZOOMOUT_SHORTDESC,       "\u0423\u043C\u0435\u043D\u044C\u0448\u0438\u0442\u044C" },
		{ ActionResources.ZOOMOUT_LONGDESC,        "\u0423\u043C\u0435\u043D\u044C\u0448\u0438\u0442\u044C" },
		//{ ActionResources.ZOOMOUT_SMALLICON,       "zoomout16.png" },
		//{ ActionResources.ZOOMOUT_LARGEICON,       "zoomout24.png" },
		{ ActionResources.ZOOMOUT_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_MINUS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMOUT_MNEMONIC,        new Integer(KeyEvent.VK_O) },

		{ ActionResources.DELETE_NAME,             "\u0423\u0434\u0430\u043B\u0438\u0442\u044C" },
		//{ ActionResources.DELETE_COMMAND,          "delete" },
		{ ActionResources.DELETE_SHORTDESC,        "\u0423\u0434\u0430\u043B\u0438\u0442\u044C" },
		{ ActionResources.DELETE_LONGDESC,         "\u0423\u0434\u0430\u043B\u0438\u0442\u044C" },
		{ ActionResources.DELETE_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_D, Event.CTRL_MASK) },
		{ ActionResources.DELETE_MNEMONIC,         new Integer(KeyEvent.VK_D) },

		{ ActionResources.EDIT_NAME,               "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		//{ ActionResources.EDIT_COMMAND,            "edit" },
		{ ActionResources.EDIT_SHORTDESC,          "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		{ ActionResources.EDIT_LONGDESC,           "\u0420\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C" },
		{ ActionResources.EDIT_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EDIT_MNEMONIC,           new Integer(KeyEvent.VK_E) },

		{ ActionResources.OK_NAME,                 "OK" },
		//{ ActionResources.OK_COMMAND,              "ok" },
		{ ActionResources.OK_SHORTDESC,            "OK" },
		{ ActionResources.OK_LONGDESC,             "OK" },
		{ ActionResources.OK_ACCELERATOR,          KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OK_MNEMONIC,             new Integer(KeyEvent.VK_O) },

		{ ActionResources.CANCEL_NAME,             "\u041E\u0442\u043C\u0435\u043D\u0438\u0442\u044C" },
		//{ ActionResources.CANCEL_COMMAND,          "cancel" },
		{ ActionResources.CANCEL_SHORTDESC,        "\u041E\u0442\u043C\u0435\u043D\u0438\u0442\u044C" },
		{ ActionResources.CANCEL_LONGDESC,         "\u041E\u0442\u043C\u0435\u043D\u0438\u0442\u044C" },
		{ ActionResources.CANCEL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.CANCEL_MNEMONIC,         new Integer(KeyEvent.VK_C) },

		{ ActionResources.TEST_NAME,               "\u041F\u0440\u043E\u0432\u0435\u0440\u0438\u0442\u044C" },
		//{ ActionResources.TEST_COMMAND,            "test" },
		{ ActionResources.TEST_SHORTDESC,          "\u041F\u0440\u043E\u0432\u0435\u0440\u0438\u0442\u044C" },
		{ ActionResources.TEST_LONGDESC,           "\u041F\u0440\u043E\u0432\u0435\u0440\u0438\u0442\u044C" },
		{ ActionResources.TEST_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK) },
		{ ActionResources.TEST_MNEMONIC,           new Integer(KeyEvent.VK_T) },

		{ ActionResources.REFRESH_NAME,            "\u041E\u0431\u043D\u043E\u0432\u0438\u0442\u044C" },
		//{ ActionResources.REFRESH_COMMAND,         "refresh" },
		{ ActionResources.REFRESH_SHORTDESC,       "\u041E\u0431\u043D\u043E\u0432\u0438\u0442\u044C" },
		{ ActionResources.REFRESH_LONGDESC,        "\u041E\u0431\u043D\u043E\u0432\u0438\u0442\u044C" },
		//{ ActionResources.REFRESH_SMALLICON,	     "refresh16.png" },
		//{ ActionResources.REFRESH_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0) },
		{ ActionResources.REFRESH_MNEMONIC,        new Integer(KeyEvent.VK_R) },

		{ ActionResources.CONTINUE_NAME,           "\u041F\u0440\u043E\u0434\u043E\u043B\u0436\u0438\u0442\u044C" },
		//{ ActionResources.CONTINUE_COMMAND,        "continue" },
		{ ActionResources.CONTINUE_SHORTDESC,      "\u041F\u0440\u043E\u0434\u043E\u043B\u0436\u0438\u0442\u044C" },
		{ ActionResources.CONTINUE_LONGDESC,       "\u041F\u0440\u043E\u0434\u043E\u043B\u0436\u0438\u0442\u044C" },
		{ ActionResources.CONTINUE_ACCELERATOR,    KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.CONTINUE_MNEMONIC,       new Integer(KeyEvent.VK_O) },

		{ ActionResources.BACK_NAME,               "\u041D\u0430\u0437\u0430\u0434" },
		//{ ActionResources.BACK_COMMAND,            "back" },
		{ ActionResources.BACK_SHORTDESC,          "\u041D\u0430\u0437\u0430\u0434" },
		{ ActionResources.BACK_LONGDESC,           "\u041D\u0430\u0437\u0430\u0434" },
		//{ ActionResources.BACK_LARGEICON,          "back24.png" },
		{ ActionResources.BACK_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, Event.CTRL_MASK) },
		{ ActionResources.BACK_MNEMONIC,           new Integer(KeyEvent.VK_B) },

		{ ActionResources.FORWARD_NAME,            "\u0412\u043F\u0435\u0440\u0451\u0434" },
		//{ ActionResources.FORWARD_COMMAND,         "forward" },
		{ ActionResources.FORWARD_SHORTDESC,       "\u0412\u043F\u0435\u0440\u0451\u0434" },
		{ ActionResources.FORWARD_LONGDESC,        "\u0412\u043F\u0435\u0440\u0451\u0434" },
		//{ ActionResources.FORWARD_LARGEICON,       "forward24.png" },
		{ ActionResources.FORWARD_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, Event.CTRL_MASK) },
		{ ActionResources.FORWARD_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.HOME_NAME,               "\u0418\u0441\u0445\u043E\u0434\u043D\u0430\u044F \u043F\u043E\u0437\u0438\u0446\u0438\u044F" },
		//{ ActionResources.HOME_COMMAND,            "home" },
		{ ActionResources.HOME_SHORTDESC,          "\u0418\u0441\u0445\u043E\u0434\u043D\u0430\u044F \u043F\u043E\u0437\u0438\u0446\u0438\u044F" },
		{ ActionResources.HOME_LONGDESC,           "\u0418\u0441\u0445\u043E\u0434\u043D\u0430\u044F \u043F\u043E\u0437\u0438\u0446\u0438\u044F" },
		//{ ActionResources.HOME_LARGEICON,          "home24.png" },
		{ ActionResources.HOME_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_HOME, Event.CTRL_MASK) },
		{ ActionResources.HOME_MNEMONIC,           new Integer(KeyEvent.VK_H) },

		{ ActionResources.ANALYZE_NAME,            "Explain Analyze" },
		//{ ActionResources.ANALYZE_COMMAND,         "explain analyze" },
		{ ActionResources.ANALYZE_SHORTDESC,       "Explain Analyze" },
		{ ActionResources.ANALYZE_LONGDESC,        "Explain Analyze" },
		//{ ActionResources.ANALYZE_SMALLICON,       "explain16.png" },
		//{ ActionResources.ANALYZE_LARGEICON,       "explain24.png" },
		{ ActionResources.ANALYZE_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_L, Event.CTRL_MASK) },
		{ ActionResources.ANALYZE_MNEMONIC,        new Integer(KeyEvent.VK_L) },
		{ ActionResources.ANALYZE_MNEMONIC_INDEX,  new Integer(11) },

		{ ActionResources.STOP_NAME,               "\u041E\u0441\u0442\u0430\u043D\u043E\u0432\u0438\u0442\u044C" },
		//{ ActionResources.STOP_COMMAND,            "stop" },
		{ ActionResources.STOP_SHORTDESC,          "\u041E\u0441\u0442\u0430\u043D\u043E\u0432\u0438\u0442\u044C" },
		{ ActionResources.STOP_LONGDESC,           "\u041E\u0441\u0442\u0430\u043D\u043E\u0432\u0438\u0442\u044C" },
		//{ ActionResources.STOP_SMALLICON,          "stop16.png" },
		//{ ActionResources.STOP_LARGEICON,          "stop24.png" },
		{ ActionResources.STOP_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK) },
		{ ActionResources.STOP_MNEMONIC,           new Integer(KeyEvent.VK_Z) },

		//{ ActionResources.DEFAULT_NAME,            "Unknown Action" },

	};
}// Resources
