/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.explain.view;

import com.redhat.rhdb.explain.ExplainTreeNode;
import com.redhat.rhdb.treedisplay.DefaultTreeLayoutModel;
import com.redhat.rhdb.treedisplay.TreeLayoutNode;
import javax.swing.tree.TreeModel;

/**
 * Layout model specifically for ExplainTreeDisplay objects. Objects
 * of this class need to be associated with an instance of
 * ExplainTreeDisplay since ExplainTreeDisplay objects are where node
 * icons are obtained from.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */

public class ExplainTreeLayoutModel extends DefaultTreeLayoutModel {

	private ExplainTreeDisplay td;

	/**
	 * Create a new <code>DefaultTreeLayoutModel</code> instance
	 * that is to be associated with the given ExplainTreeDisplay
	 * object.
	 *
	 * @param td a <code>ExplainTreeDisplay</code> value
	 */
	public ExplainTreeLayoutModel(ExplainTreeDisplay td)
	{
		this.td = td;
		setTreeLayoutNodeClass(ExplainTreeLayoutNode.class);
	}

	/**
	 * Create a new <code>DefaultTreeLayoutModel</code> instance
	 * using the given TreeModel m as the model to lay out. It will be
	 * associated with the given ExplainTreeDisplay object.
	 *
	 * @param td a <code>ExplainTreeDisplay</code> value
	 * @param m a <code>TreeModel</code> value
	 */
	public ExplainTreeLayoutModel(ExplainTreeDisplay td, TreeModel m)
	{
		this(td);

		setModel(m);
	}

	/**
	 * Create a TreeLayoutNode. This method expects an ExplainTreeNode as
	 * the <i>o</i> parameter and returns an ExplainTreeLayoutNode. The
	 * icon property of the new layout node will be set given the type of
	 * the ExplainTreeNode.
	 *
	 * @param o an <code>Object</code> value
	 * @return a <code>TreeLayoutNode</code> value or null if o is not
	 * an ExplainTreeNode.
	 */
	public TreeLayoutNode createNode(Object o)
	{
		if (! (o instanceof ExplainTreeNode))
			return null;

		ExplainTreeNode etn = (ExplainTreeNode) o;
		ExplainTreeLayoutNode n = (ExplainTreeLayoutNode) super.createNode(o);

		n.setIcon(td.getIcon(etn.getType()));

		return n;
	}
}// ExplainTreeLayoutModel
