/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Java
extends Task {
    private CommandlineJava cmdl = new CommandlineJava();
    private Environment env = new Environment();
    private boolean fork = false;
    private boolean newEnvironment = false;
    private File dir = null;
    private File out;
    private PrintStream outStream = null;
    private boolean failOnError = false;
    private boolean append = false;
    private Long timeout = null;

    public void execute() throws BuildException {
        File savedDir = this.dir;
        int err = -1;
        try {
            err = this.executeJava();
            if (err != 0) {
                if (this.failOnError) {
                    throw new BuildException("Java returned: " + err, this.location);
                }
                this.log("Java Result: " + err, 0);
            }
            Object var4_3 = null;
            this.dir = savedDir;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dir = savedDir;
            throw throwable;
        }
    }

    public int executeJava() throws BuildException {
        String classname = this.cmdl.getClassname();
        if (classname == null && this.cmdl.getJar() == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (!this.fork && this.cmdl.getJar() != null) {
            throw new BuildException("Cannot execute a jar in non-forked mode. Please set fork='true'. ");
        }
        if (this.fork) {
            this.log(this.cmdl.describeCommand(), 3);
        } else {
            if (this.cmdl.getVmCommand().size() > 1) {
                this.log("JVM args ignored when same JVM is used.", 1);
            }
            if (this.dir != null) {
                this.log("Working directory ignored when same JVM is used.", 1);
            }
            if (this.newEnvironment || null != this.env.getVariables()) {
                this.log("Changes to environment variables are ignored when same JVM is used.", 1);
            }
            this.log("Running in same VM " + this.cmdl.describeJavaCommand(), 3);
        }
        try {
            if (this.fork) {
                return this.run(this.cmdl.getCommandline());
            }
            try {
                this.run(this.cmdl);
                return 0;
            }
            catch (ExitException ex) {
                return ex.getStatus();
            }
        }
        catch (BuildException e) {
            if (this.failOnError) {
                throw e;
            }
            this.log(e.getMessage(), 0);
            return 0;
        }
        catch (Throwable t) {
            if (this.failOnError) {
                throw new BuildException(t);
            }
            this.log(t.getMessage(), 0);
            return 0;
        }
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public Path createClasspath() {
        return this.cmdl.createClasspath(this.project).createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setJar(File jarfile) throws BuildException {
        if (this.cmdl.getClassname() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command.");
        }
        this.cmdl.setJar(jarfile.getAbsolutePath());
    }

    public void setClassname(String s) throws BuildException {
        if (this.cmdl.getJar() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command");
        }
        this.cmdl.setClassname(s);
    }

    public void setArgs(String s) {
        this.log("The args attribute is deprecated. Please use nested arg elements.", 1);
        this.cmdl.createArgument().setLine(s);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setFork(boolean s) {
        this.fork = s;
    }

    public void setJvmargs(String s) {
        this.log("The jvmargs attribute is deprecated. Please use nested jvmarg elements.", 1);
        this.cmdl.createVmArgument().setLine(s);
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setJvm(String s) {
        this.cmdl.setVm(s);
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.cmdl.addSysproperty(sysp);
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setOutput(File out) {
        this.out = out;
    }

    public void setMaxmemory(String max) {
        this.cmdl.setMaxmemory(max);
    }

    public void setJVMVersion(String value) {
        this.cmdl.setVmversion(value);
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    protected void handleOutput(String line) {
        if (this.outStream != null) {
            this.outStream.println(line);
        } else {
            super.handleOutput(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.outStream != null) {
            this.outStream.println(line);
        } else {
            super.handleErrorOutput(line);
        }
    }

    private void run(CommandlineJava command) throws BuildException {
        block7: {
            ExecuteJava exe = new ExecuteJava();
            exe.setJavaCommand(command.getJavaCommand());
            exe.setClasspath(command.getClasspath());
            exe.setSystemProperties(command.getSystemProperties());
            exe.setTimeout(this.timeout);
            if (this.out != null) {
                try {
                    try {
                        this.outStream = new PrintStream(new FileOutputStream(this.out.getAbsolutePath(), this.append));
                        exe.execute(this.project);
                    }
                    catch (IOException io) {
                        throw new BuildException(io, this.location);
                    }
                    Object var5_3 = null;
                    if (this.outStream != null) {
                        this.outStream.close();
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (this.outStream != null) {
                        this.outStream.close();
                    }
                    throw throwable;
                }
            }
            exe.execute(this.project);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run(String[] command) throws BuildException {
        FileOutputStream fos = null;
        try {
            try {
                Execute exe = null;
                if (this.out == null) {
                    exe = new Execute(new LogStreamHandler(this, 2, 1), this.createWatchdog());
                } else {
                    fos = new FileOutputStream(this.out.getAbsolutePath(), this.append);
                    exe = new Execute(new PumpStreamHandler(fos), this.createWatchdog());
                }
                exe.setAntRun(this.project);
                if (this.dir == null) {
                    this.dir = this.project.getBaseDir();
                } else {
                    if (!this.dir.exists()) throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.location);
                    if (!this.dir.isDirectory()) {
                        throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.location);
                    }
                }
                exe.setWorkingDirectory(this.dir);
                String[] environment = this.env.getVariables();
                if (environment != null) {
                    int i = 0;
                    while (i < environment.length) {
                        this.log("Setting environment variable: " + environment[i], 3);
                        ++i;
                    }
                }
                exe.setNewenvironment(this.newEnvironment);
                exe.setEnvironment(environment);
                exe.setCommandline(command);
                try {
                    int rc = exe.execute();
                    if (exe.killedProcess()) {
                        this.log("Timeout: killed the sub-process", 1);
                    }
                    int n = rc;
                    Object var8_9 = null;
                    if (fos == null) return n;
                    try {
                        fos.close();
                        return n;
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                    return n;
                }
                catch (IOException e) {
                    throw new BuildException(e, this.location);
                }
            }
            catch (IOException io) {
                throw new BuildException(io, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fos == null) throw throwable;
            try {}
            catch (IOException io) {
                throw throwable;
            }
            fos.close();
            throw throwable;
        }
    }

    protected void run(String classname, Vector args) throws BuildException {
        CommandlineJava cmdj = new CommandlineJava();
        cmdj.setClassname(classname);
        int i = 0;
        while (i < args.size()) {
            cmdj.createArgument().setValue((String)args.elementAt(i));
            ++i;
        }
        this.run(cmdj);
    }

    public void clearArgs() {
        this.cmdl.clearJavaArgs();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }
}

