# -*-encoding: iso8859-1 -*-
##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
from osv.osv import osv_pools
from report.interface import report_rml
from report.interface import toxml

#FIXME: we should use toxml

class report_custom(report_rml):
	def create_xml(self, uid, ids, datas, context={}):
		cr = sql_db.db.cursor()
		config = """
		<config>
			<date>09/09/2005</date>
			<PageSize>210.00mm,297.00mm</PageSize>
			<PageWidth>595.27</PageWidth>
			<PageHeight>841.88</PageHeight>
			<tableSize>60.00mm,60.00mm,60.00mm</tableSize>
			<report-header>Stock by location</report-header>
			<report-footer>Generated by Tiny ERP</report-footer>
		</config>
		"""
		header = """
		<header>
			<field>Location</field>
			<field>Product name</field>
			<field>Product quantity</field>
		</header>
		"""

		def process(location_id, level):
			xml = '<row>'
			location_name = osv_pools.get('stock.location').read(cr, uid, [location_id], ['name'])
			xml += "<col para='yes' tree='yes' space='" + str(3*level) + "mm'>"
			xml += location_name[0]['name'] + '</col>'

			prod_info = osv_pools.get('stock.location')._product_get(cr, uid, location_id)
			xml += "<col>"
			for prod_id in prod_info.keys():
				if prod_info[prod_id] != 0.0:
					prod_name = osv_pools.get('product.product').read(cr, uid, [prod_id], ['name'])
					xml +=  prod_name[0]['name'] + '\n'
			xml += '</col>'

			xml += "<col>"
			for prod_id in prod_info.keys():
				if prod_info[prod_id] != 0.0:
					xml +=  str(prod_info[prod_id]) + '\n'
			xml += '</col></row>'

			location_child = osv_pools.get('stock.location').read(cr, uid, [location_id], ['child_ids'])
			for child_id in location_child[0]['child_ids']:
				xml += process(child_id, level+1)
			return xml

		for location_id in ids:
			xml = '<lines>' + process(location_id, 0) + '</lines>'

		xml = '<?xml version="1.0" ?>' '<report>'+ config + header + xml + '</report>'

		cr.close()
		return self.post_process_xml_data(uid, xml, context)

report_custom('report.stock.lot.location', 'stock.location', '', 'addons/stock/report/stock_by_location.xsl')
