/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ParameterMetaDataSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.InvalidColumnException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StreamInfo;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CallableStatementSapDB
extends StatementSapDB
implements CallableStatement,
SQLParamController {
    private Vector inputOMSStreams;
    private Vector outputOMSStreams;
    private Vector inputProcedureLongs;
    static final int maxParseAgainCnt = 10;
    Parseinfo parseinfo;
    boolean lastWasNull;
    StructuredMem replyMem;
    protected Object[] inputArgs;
    Vector inputLongs;
    Vector batchRows;
    short[] outPutTypes;
    byte[] outPutScale;
    FetchInfo fetchInfo;
    AbstractMap columnMap;
    private final String initialParamValue = "initParam";
    private static final PutvalComparator putvalComparator = new PutvalComparator();

    CallableStatementSapDB(ConnectionSapDB connectionSapDB, String string) throws SQLException {
        super(connectionSapDB, connectionSapDB.isKernelFeaturesupported(5) ? 1003 : 1003, 1007, connectionSapDB.getHoldability());
        this.constructor(string);
    }

    CallableStatementSapDB(ConnectionSapDB connectionSapDB, String string, int n, int n2, int n3) throws SQLException {
        super(connectionSapDB, n, n2, n3);
        this.constructor(string);
    }

    public void addBatch() throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(this.inputArgs);
        Object[] objectArray = new Object[this.parseinfo.paramInfos.length];
        DBTechTranslator[] dBTechTranslatorArray = this.parseinfo.paramInfos;
        int n = dBTechTranslatorArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = dBTechTranslatorArray[i].cloneObjectForBatch(this.inputArgs[i]);
        }
        this.inputArgs = objectArray;
    }

    public void addBatch(String string) throws SQLException {
        throw new JDBCDriverException(MessageTranslator.translate("error.addbatch.preparedstatement"), this);
    }

    private int calculateInputRecord() {
        int n = 0;
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            DBTechTranslator dBTechTranslator = this.parseinfo.paramInfos[i];
            if (!dBTechTranslator.isInput()) continue;
            int n2 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
            n = Math.max(n, n2);
        }
        return n;
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.inputArgs.length; ++i) {
            this.inputArgs[i] = "initParam";
        }
    }

    private void constructor(String string) throws SQLException {
        this.parseinfo = this.doParse(string, false);
    }

    private Parseinfo doParse(String string, boolean bl) throws SQLException {
        if (string == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.null"), "42000");
        }
        Parseinfo parseinfo = null;
        ParseinfoCache parseinfoCache = this.connection.parseCache;
        String[] stringArray = null;
        if (string == null) {
            throw new SQLExceptionSapDB("SQL statement is null", "42000");
        }
        this.fetchInfo = null;
        if (bl) {
            parseinfo = this.parseinfo;
            parseinfo.setMassParseid(null);
        } else if (parseinfoCache != null) {
            parseinfo = parseinfoCache.findParseinfo(string);
        }
        if (parseinfo == null || bl) {
            ReplyPacket replyPacket;
            try {
                this.setWithInfo = true;
                replyPacket = this.sendSQL(string, this.resultSetType, this.resultSetConcurrency, bl);
            }
            catch (TimeoutException timeoutException) {
                replyPacket = this.sendSQL(string, this.resultSetType, this.resultSetConcurrency, bl);
            }
            if (!bl) {
                parseinfo = new Parseinfo(this.connection, string, replyPacket.functionCode());
            }
            PartEnumeration partEnumeration = replyPacket.partEnumeration();
            DBTechTranslator[] dBTechTranslatorArray = null;
            block10: while (partEnumeration.hasMoreElements()) {
                partEnumeration.nextElement();
                switch (partEnumeration.partKind()) {
                    case 10: {
                        int n = replyPacket.getPartDataPos();
                        parseinfo.setParseIdAndSession(replyPacket.getBytes(n, 12), replyPacket.getInt4(n));
                        continue block10;
                    }
                    case 14: {
                        dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, parseinfo.isDBProc, parseinfo.procParamInfos, false);
                        continue block10;
                    }
                    case 32: {
                        parseinfo.varDataInput = true;
                        dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, parseinfo.isDBProc, parseinfo.procParamInfos, true);
                        continue block10;
                    }
                    case 13: {
                        parseinfo.setSelect(true);
                        int n = replyPacket.partLength();
                        if (n <= 0) continue block10;
                        this.cursorName = replyPacket.getString(replyPacket.getPartDataPos(), n);
                        continue block10;
                    }
                    case 19: {
                        parseinfo.setUpdateTableName(replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength()));
                        continue block10;
                    }
                    case 2: {
                        stringArray = replyPacket.parseColumnNames();
                        continue block10;
                    }
                }
            }
            parseinfo.setShortInfosAndColumnNames(dBTechTranslatorArray, stringArray);
            if (parseinfoCache != null && !bl) {
                parseinfoCache.addParseinfo(parseinfo);
            }
        }
        this.inputArgs = new Object[parseinfo.paramInfos.length];
        this.clearParameters();
        return parseinfo;
    }

    public boolean execute() throws SQLException {
        this.assertOpen();
        return this.execute(10);
    }

    private void reparse() throws SQLException {
        Object[] objectArray = this.inputArgs;
        this.doParse(this.parseinfo.sqlCmd, true);
        this.inputArgs = objectArray;
    }

    protected String getUpdTablename(String string) {
        return this.parseinfo.updTableName;
    }

    public boolean execute(int n) throws SQLException {
        if (this.connection == null) {
            throw new InternalJDBCError(MessageTranslator.translate("error.internal.connectionnull"));
        }
        boolean bl = this.connection.isInTransaction();
        if (this.parseinfo.isAlreadyExecuted()) {
            this.replyMem = null;
            this.closeResultSet(true);
            if (this.connection == null) {
                throw new NullPointerException();
            }
            this.reparse();
            this.rowsAffected = 0;
            return false;
        }
        if (!this.parseinfo.isValid()) {
            this.reparse();
        }
        try {
            boolean bl2;
            ReplyPacket replyPacket;
            int n2;
            this.closeResultSet(true);
            if (!this.parseinfo.isValid()) {
                this.reparse();
            }
            this.replyMem = null;
            this.outputOMSStreams = null;
            RequestPacket requestPacket = this.connection.getRequestPacket();
            requestPacket.initExecute(this.parseinfo.getParseId(), this.connection.autocommit, this.resultSetType);
            if (this.parseinfo.isSelect) {
                requestPacket.addCursorPart(this.cursorName);
            }
            if (this.parseinfo.inputCount > 0 || this.parseinfo.hasStreams) {
                DataPart dataPart = requestPacket.newDataPart(this.parseinfo.varDataInput);
                if (this.parseinfo.inputCount > 0) {
                    dataPart.addRow(this.parseinfo.inputCount);
                    for (n2 = 0; n2 < this.parseinfo.paramInfos.length; ++n2) {
                        if (this.parseinfo.paramInfos[n2].isInput() && "initParam" == this.inputArgs[n2]) {
                            if (this.parseinfo.paramInfos[n2].isStreamKind() && this.outPutTypes != null && this.outPutTypes[n2 + 1] != 0) {
                                if (this.outputOMSStreams == null) {
                                    this.outputOMSStreams = new Vector();
                                }
                                ABAPStreamTranslator aBAPStreamTranslator = (ABAPStreamTranslator)this.parseinfo.paramInfos[n2];
                                AbstractABAPStreamGetval abstractABAPStreamGetval = aBAPStreamTranslator.createGetval();
                                this.outputOMSStreams.add(abstractABAPStreamGetval);
                                aBAPStreamTranslator.put(dataPart, abstractABAPStreamGetval);
                                continue;
                            }
                            throw new SQLException(MessageTranslator.translate("error.missinginout", Integer.toString(n2 + 1)), "02000");
                        }
                        this.parseinfo.paramInfos[n2].put(dataPart, this.inputArgs[n2]);
                    }
                    this.inputProcedureLongs = null;
                    if (this.parseinfo.hasLongs) {
                        if (this.parseinfo.isDBProc) {
                            this.handleProcedureStreamsForExecute(dataPart, this.inputArgs);
                        } else {
                            this.handleStreamsForExecute(dataPart, this.inputArgs);
                        }
                    }
                    if (this.parseinfo.hasStreams) {
                        this.handleOMSStreamsForExecute(dataPart);
                    }
                } else {
                    this.handleOMSStreamsForExecute(dataPart);
                }
                dataPart.close();
            }
            if (this.parseinfo.isSelect && this.parseinfo.columnInfos == null && this.parseinfo.functionCode != 248) {
                requestPacket.initDbsCommand("DESCRIBE ", false, false, 1003);
                requestPacket.addParseidPart(this.parseinfo.getParseId());
            }
            try {
                replyPacket = this.connection.execute(requestPacket, this, !this.parseinfo.hasStreams && this.inputProcedureLongs == null ? 1 : 3);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -8 && n > 0) {
                    this.resetPutvals(this.inputLongs);
                    this.reparse();
                    this.connection.freeRequestPacket(requestPacket);
                    return this.execute(--n);
                }
                throw sQLException;
            }
            if (this.parseinfo.isSelect) {
                bl2 = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames);
            } else {
                if (this.inputProcedureLongs != null) {
                    replyPacket = this.processProcedureStreams(replyPacket);
                } else if (this.parseinfo.hasStreams) {
                    replyPacket = this.processOMSStreams(replyPacket);
                }
                bl2 = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames);
                n2 = replyPacket.returnCode();
                if (replyPacket.existsPart(5)) {
                    this.replyMem = replyPacket.getPointer(replyPacket.getPartDataPos());
                }
                if (this.parseinfo.hasLongs && !this.parseinfo.isDBProc && n2 == 0) {
                    this.handleStreamsForPutval(replyPacket);
                }
            }
            return bl2;
        }
        catch (TimeoutException timeoutException) {
            if (this.connection.isInTransaction()) {
                throw timeoutException;
            }
            this.closeResultSet(true);
            this.resetPutvals(this.inputLongs);
            this.reparse();
            return this.execute(10);
        }
    }

    public boolean execute(String string) throws SQLException {
        return this.execute();
    }

    private void dumpInput(String string) {
        System.out.println(string);
        for (int i = 0; i < this.inputArgs.length; ++i) {
            System.out.println("inputArgs [" + i + "]: " + this.inputArgs[i]);
        }
    }

    public int[] executeBatch() throws SQLException {
        this.assertOpen();
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset"), new int[0]);
        }
        if (this.parseinfo != null && (this.parseinfo.functionCode == 34 || this.parseinfo.functionCode == 248)) {
            for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                if (!this.parseinfo.paramInfos[i].isOutput()) continue;
                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout"), new int[0]);
            }
        }
        if (this.batchItems == null) {
            return new int[0];
        }
        Vector vector = null;
        boolean bl = this.connection.isInTransaction();
        Vector vector2 = this.batchItems;
        this.batchItems = null;
        try {
            int n;
            int n2 = vector2.size();
            ReplyPacket replyPacket = null;
            int n3 = 0;
            boolean bl2 = false;
            boolean bl3 = true;
            int n4 = 0;
            int n5 = RequestPacket.resultCountPartSize();
            int n6 = -1;
            int[] nArray = new int[n2];
            this.rowsAffected = -1;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = -2;
            }
            if (this.parseinfo.getMassParseid() == null) {
                this.parseMassCmd(false);
            }
            if (this.parseinfo.paramInfos.length > 0) {
                n4 = this.calculateInputRecord();
            }
            while (n3 < n2 && bl3) {
                vector = null;
                n = n3;
                RequestPacket requestPacket = this.connection.getRequestPacket();
                requestPacket.initExecute(this.parseinfo.getMassParseid(), this.connection.autocommit, this.resultSetType);
                if (n6 == -1) {
                    requestPacket.addUndefResultCount();
                } else {
                    requestPacket.addResultCount(n6);
                }
                requestPacket.addCursorPart(this.cursorName);
                if (this.parseinfo.paramInfos.length > 0) {
                    DataPart dataPart = requestPacket.newDataPart(this.parseinfo.varDataInput);
                    if (n6 == -1) {
                        dataPart.setFirstPart();
                    }
                    do {
                        Object[] objectArray = (Object[])vector2.elementAt(n3);
                        dataPart.addRow(this.parseinfo.inputCount);
                        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                            if (this.parseinfo.paramInfos[i].isInput() && "initParam" == objectArray[i]) {
                                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", Integer.toString(n3 + 1), Integer.toString(i + 1)), "0200", this.makeBatchCountArray(nArray));
                            }
                            this.parseinfo.paramInfos[i].put(dataPart, objectArray[i]);
                        }
                        if (this.parseinfo.hasLongs) {
                            this.handleStreamsForExecute(dataPart, objectArray);
                            if (vector == null) {
                                vector = new Vector(this.inputLongs.size());
                            }
                            vector.addAll(this.inputLongs);
                        }
                        dataPart.moveRecordBase();
                    } while (++n3 < n2 && dataPart.hasRoomFor(n4, n5) && this.parseinfo.isMassCmd());
                    if (n3 == n2) {
                        dataPart.setLastPart();
                    }
                    dataPart.closeArrayPart(n3 - n);
                } else {
                    ++n3;
                }
                try {
                    replyPacket = this.connection.execute(requestPacket, this, 2);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -8) {
                        this.resetPutvals(vector);
                        this.parseMassCmd(true);
                        n3 = n;
                        continue;
                    }
                    SQLExceptionSapDB sQLExceptionSapDB = (SQLExceptionSapDB)sQLException;
                    if (!this.connection.getAutoCommit()) {
                        this.rowsAffected = this.rowsAffected > 0 ? (this.rowsAffected += sQLExceptionSapDB.getErrorPos() - 1) : sQLExceptionSapDB.getErrorPos() - 1;
                    }
                    throw new BatchUpdateExceptionSapDB(sQLException, new Integer(n3 + 1), this.makeBatchCountArray(nArray));
                }
                n6 = replyPacket.resultCount(false);
                if (this.parseinfo.hasLongs) {
                    this.handleStreamsForPutval(replyPacket);
                }
                if (!this.parseinfo.isMassCmd() && n6 != -1) {
                    nArray[n3 - 1] = n6;
                    if (this.rowsAffected > 0) {
                        this.rowsAffected += n6;
                        continue;
                    }
                    this.rowsAffected = n6;
                    continue;
                }
                this.rowsAffected = n6;
            }
            return nArray;
        }
        catch (TimeoutException timeoutException) {
            if (bl) {
                throw timeoutException;
            }
            this.batchItems = vector2;
            this.resetPutvals(vector);
            return this.executeBatch();
        }
    }

    private int[] makeBatchCountArray(int[] nArray) {
        int[] nArray2;
        if (this.rowsAffected > 0) {
            nArray2 = new int[this.rowsAffected];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        } else {
            nArray2 = new int[]{};
        }
        return nArray2;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.rowcount"));
        }
        this.execute();
        return this.currentResultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.executequery.preparedstatement"));
    }

    public ResultSetSapDB executeQuerySap() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.rowcount"));
        }
        return (ResultSetSapDB)this.currentResultSet;
    }

    public int executeUpdate() throws SQLException {
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.resultset"));
        }
        this.execute();
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    public int executeUpdate(String string) throws SQLException {
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.executeupdate.preparedstatement"));
    }

    private DBTechTranslator findColInfo(int n) throws SQLException {
        DBTechTranslator dBTechTranslator;
        try {
            dBTechTranslator = this.parseinfo.paramInfos[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JDBCDriverException(MessageTranslator.translate("error.colindex.notfound", Integer.toString(n)), this);
        }
        return dBTechTranslator;
    }

    private DBTechTranslator findParamInfo(String string) throws SQLException {
        DBTechTranslator dBTechTranslator;
        if (!this.parseinfo.isDBProc) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.noprocedure"));
        }
        if (this.columnMap == null) {
            this.columnMap = this.parseinfo.getColumnMap();
        }
        if ((dBTechTranslator = (DBTechTranslator)this.columnMap.get(string)) == null && (dBTechTranslator = (DBTechTranslator)this.columnMap.get(string.toUpperCase())) != null) {
            this.columnMap.put(string, dBTechTranslator);
        }
        if (dBTechTranslator == null) {
            throw new InvalidColumnException(string, (Object)this);
        }
        return dBTechTranslator;
    }

    public Array getArray(int n) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getBigDecimal(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getBigDecimal(n2, this, this.getReplyData());
    }

    public Blob getBlob(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public boolean getBoolean(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getBoolean(this, this.getReplyData());
    }

    public byte getByte(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getByte(this, this.getReplyData());
    }

    public byte[] getBytes(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getBytes(this, this.getReplyData());
    }

    public Clob getClob(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Date getDate(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getDate(this, this.getReplyData(), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getDate(this, this.getReplyData(), calendar);
    }

    public double getDouble(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getDouble(this, this.getReplyData());
    }

    public float getFloat(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getFloat(this, this.getReplyData());
    }

    Object getInputParameter(int n) {
        return this.inputArgs[n - 1];
    }

    public int getInt(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getInt(this, this.getReplyData());
    }

    public long getLong(int n) throws SQLException {
        this.assertOpen();
        return this.findColInfo(n).getLong(this, this.getReplyData());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.fetchInfo == null) {
            if (this.parseinfo == null) {
                return null;
            }
            if (!this.parseinfo.isSelect && this.parseinfo.functionCode != 4 && this.parseinfo.functionCode != 248) {
                return null;
            }
            DBTechTranslator[] dBTechTranslatorArray = this.parseinfo.getColumnInfos();
            if (dBTechTranslatorArray != null) {
                return new ResultSetMetaDataSapDB(dBTechTranslatorArray);
            }
            try {
                this.parseinfo.doDescribeParseId();
            }
            catch (Exception exception) {
                return null;
            }
            return new ResultSetMetaDataSapDB(this.getFetchInfo(this.cursorName, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames).getColInfo());
        }
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo());
    }

    public Object getObject(int n) throws SQLException {
        this.assertOpen();
        Object object = null;
        DBTechTranslator dBTechTranslator = this.findColInfo(n);
        StructuredMem structuredMem = this.getReplyData();
        int n2 = this.outPutTypes == null ? 0 : this.outPutTypes[n];
        switch (n2) {
            case -7: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Boolean(dBTechTranslator.getBoolean(this, structuredMem));
                break;
            }
            case -6: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Byte(dBTechTranslator.getByte(this, structuredMem));
                break;
            }
            case 5: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Short(dBTechTranslator.getShort(this, structuredMem));
                break;
            }
            case 4: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Integer(dBTechTranslator.getInt(this, structuredMem));
                break;
            }
            case -5: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Long(dBTechTranslator.getLong(this, structuredMem));
                break;
            }
            case 7: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Float(dBTechTranslator.getFloat(this, structuredMem));
                break;
            }
            case 6: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Float(dBTechTranslator.getFloat(this, structuredMem));
                break;
            }
            case 8: {
                if (dBTechTranslator.isNull(this, structuredMem)) break;
                object = new Double(dBTechTranslator.getDouble(this, structuredMem));
                break;
            }
            case 2: 
            case 3: {
                byte by = this.outPutScale[n];
                if (by == -1) {
                    object = dBTechTranslator.getBigDecimal(this, structuredMem);
                    break;
                }
                object = dBTechTranslator.getBigDecimal(by, this, structuredMem);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = dBTechTranslator.getString(this, structuredMem);
                break;
            }
            case 91: {
                object = dBTechTranslator.getDate(this, structuredMem, null);
                break;
            }
            case 92: {
                object = dBTechTranslator.getTime(this, structuredMem, null);
                break;
            }
            case 93: {
                object = dBTechTranslator.getTimestamp(this, structuredMem, null);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = dBTechTranslator.getBytes(this, structuredMem);
                break;
            }
            case 2004: {
                object = dBTechTranslator.getBlob(this, structuredMem, structuredMem);
                break;
            }
            case 2005: {
                object = dBTechTranslator.getClob(this, structuredMem, structuredMem);
                break;
            }
            default: {
                object = dBTechTranslator.getObject(this, structuredMem);
            }
        }
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplemented(MessageTranslator.translate("error.getobject.notimplemented"));
    }

    public Ref getRef(int n) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
        return null;
    }

    public StructuredMem getReplyData() throws SQLException {
        if (this.replyMem == null && (this.outputOMSStreams == null || this.outputOMSStreams != null && this.outputOMSStreams.size() == 0)) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.nooutparamdata"));
        }
        return this.replyMem;
    }

    public short getShort(int n) throws SQLException {
        return this.findColInfo(n).getShort(this, this.getReplyData());
    }

    public String getString(int n) throws SQLException {
        return this.findColInfo(n).getString(this, this.getReplyData());
    }

    public Time getTime(int n) throws SQLException {
        return this.findColInfo(n).getTime(this, this.getReplyData(), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.findColInfo(n).getTime(this, this.getReplyData(), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.findColInfo(n).getTimestamp(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.findColInfo(n).getTimestamp(this, this.getReplyData(), calendar);
    }

    private void handleStreamsForExecute(DataPart dataPart, Object[] objectArray) throws SQLException {
        Putval putval;
        int n;
        this.inputLongs = new Vector();
        for (n = 0; n < this.parseinfo.paramInfos.length; ++n) {
            Object object = objectArray[n];
            if (object == null) continue;
            try {
                putval = (Putval)object;
                this.inputLongs.addElement(putval);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.inputLongs.size() > 1) {
            Collections.sort(this.inputLongs, putvalComparator);
        }
        Enumeration enumeration = this.inputLongs.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            putval = (Putval)enumeration.nextElement();
            if (putval.atEnd()) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.isatend"));
            }
            putval.transferStream(dataPart, n);
            ++n;
        }
    }

    private void handleProcedureStreamsForExecute(DataPart dataPart, Object[] objectArray) {
        this.inputProcedureLongs = new Vector();
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object object = this.inputArgs[i];
            if (object == null) continue;
            try {
                AbstractProcedurePutval abstractProcedurePutval = (AbstractProcedurePutval)object;
                this.inputProcedureLongs.addElement(abstractProcedurePutval);
                abstractProcedurePutval.updateIndex(this.inputProcedureLongs.size() - 1);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void handleOMSStreamsForExecute(DataPart dataPart) {
        ABAPStreamDescriptor aBAPStreamDescriptor;
        int n;
        int n2;
        this.inputOMSStreams = new Vector();
        for (n2 = 0; n2 < this.parseinfo.paramInfos.length; ++n2) {
            Object object = this.inputArgs[n2];
            if (object == null) continue;
            try {
                this.inputOMSStreams.addElement((AbstractABAPStreamPutval)this.inputArgs[n2]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        n2 = this.inputOMSStreams.size();
        for (n = 0; n < n2; ++n) {
            aBAPStreamDescriptor = (ABAPStreamDescriptor)this.inputOMSStreams.elementAt(n);
            aBAPStreamDescriptor.updateIndex(n);
        }
        if (this.outputOMSStreams != null) {
            for (n = 0; n < this.outputOMSStreams.size(); ++n) {
                aBAPStreamDescriptor = (ABAPStreamDescriptor)this.outputOMSStreams.elementAt(n);
                aBAPStreamDescriptor.updateIndex(n);
            }
        }
    }

    private ReplyPacket processProcedureStreams(ReplyPacket replyPacket) throws SQLException {
        Object object;
        ReplyPacket replyPacket2 = null;
        try {
            while (replyPacket.existsPart(25)) {
                StreamInfo[] streamInfoArray = replyPacket.parseStreamInfos();
                object = streamInfoArray[0];
                int n = ((StreamInfo)object).getTabId();
                if (n < 0 || n > this.inputProcedureLongs.size()) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.unknown.procedurelong", Integer.toString(n)));
                }
                AbstractProcedurePutval abstractProcedurePutval = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(n);
                RequestPacket requestPacket = this.connection.getRequestPacket();
                DataPart dataPart = requestPacket.initStreamCommand(this.connection.autocommit);
                abstractProcedurePutval.transferStream(dataPart, ((StreamInfo)object).getRowCount());
                dataPart.close();
                replyPacket = this.connection.execute(requestPacket, this, 3);
            }
            replyPacket2 = replyPacket;
        }
        catch (SQLException sQLException) {
            object = this.connection.sendStreamErrorPacket(sQLException);
            if (object == null) {
                throw sQLException;
            }
            replyPacket2 = object;
        }
        for (int i = 0; i < this.inputProcedureLongs.size(); ++i) {
            object = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(i);
            ((AbstractProcedurePutval)object).closeStream();
        }
        return replyPacket2;
    }

    private ReplyPacket processOMSStreams(ReplyPacket replyPacket) throws SQLException {
        ABAPStreamDescriptor aBAPStreamDescriptor;
        int n;
        while (true) {
            MemIndirection memIndirection;
            if (replyPacket.existsPart(25)) {
                n = replyPacket.parseABAPTabIDForInput();
                aBAPStreamDescriptor = (AbstractABAPStreamPutval)this.inputOMSStreams.elementAt(n);
                if (((AbstractABAPStreamPutval)aBAPStreamDescriptor).atEnd()) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.eof", Integer.toString(n)));
                }
                RequestPacket requestPacket = this.connection.getRequestPacket();
                memIndirection = requestPacket.initStreamCommand(this.connection.autocommit);
                ((AbstractABAPStreamPutval)aBAPStreamDescriptor).transferStream((DataPart)memIndirection);
                ((DataPart)memIndirection).close();
                replyPacket = this.connection.execute(requestPacket, this, 3);
                continue;
            }
            if (!replyPacket.existsPart(26)) break;
            n = replyPacket.parseABAPTabIDForOutput();
            aBAPStreamDescriptor = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(n);
            boolean bl = ((AbstractABAPStreamGetval)aBAPStreamDescriptor).addReplyData(replyPacket);
            memIndirection = this.connection.getRequestPacket();
            DataPart dataPart = ((RequestPacket)memIndirection).initStreamCommand(this.connection.autocommit);
            if (bl) {
                dataPart.fillWithOMSReturnCode(100);
            } else {
                dataPart.fillWithOMSReturnCode(0);
            }
            dataPart.close();
            replyPacket = this.connection.execute((RequestPacket)memIndirection, this, 3);
        }
        if (this.outputOMSStreams != null) {
            for (n = 0; n < this.outputOMSStreams.size(); ++n) {
                aBAPStreamDescriptor = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(n);
                if (aBAPStreamDescriptor == null) continue;
                ((AbstractABAPStreamGetval)aBAPStreamDescriptor).coalesceReply();
            }
        }
        return replyPacket;
    }

    private void getChangedPutvalDescriptors(ReplyPacket replyPacket) {
        byte[][] byArray = replyPacket.parseLongDescriptors();
        if (!replyPacket.existsPart(18)) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = byArray[i];
            StructuredBytes structuredBytes = new StructuredBytes(byArray2);
            int n = structuredBytes.getInt2(28);
            Putval putval = (Putval)this.inputLongs.elementAt(n);
            putval.setDescriptor(byArray2);
        }
    }

    private void handleStreamsForPutval(ReplyPacket replyPacket) throws SQLException {
        if (this.inputLongs.size() == 0) {
            return;
        }
        Putval putval = (Putval)this.inputLongs.lastElement();
        int n = 0;
        int n2 = this.inputLongs.size();
        boolean bl = false;
        while (!putval.atEnd()) {
            this.getChangedPutvalDescriptors(replyPacket);
            RequestPacket requestPacket = this.connection.getRequestPacket();
            DataPart dataPart = requestPacket.initPutval(this.connection.autocommit);
            for (int i = n; i < n2 && dataPart.hasRoomFor(41); ++i) {
                Putval putval2 = (Putval)this.inputLongs.elementAt(i);
                if (putval2.atEnd()) {
                    ++n;
                    continue;
                }
                int n3 = dataPart.getExtent();
                putval2.putDescriptor(dataPart, n3);
                dataPart.addArg(n3, 41);
                putval2.transferStream(dataPart, i);
                if (!putval2.atEnd()) continue;
                ++n;
            }
            if (putval.atEnd()) {
                try {
                    putval.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                }
            }
            dataPart.close();
            replyPacket = this.connection.execute(requestPacket, this, 2);
            if (!bl) continue;
            requestPacket = this.connection.getRequestPacket();
            dataPart = requestPacket.initPutval(this.connection.autocommit);
            putval.markAsLast(dataPart);
            dataPart.close();
            this.connection.execute(requestPacket, this, 2);
        }
    }

    private void parseMassCmd(boolean bl) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket();
        requestPacket.initParseCommand(this.parseinfo.sqlCmd, true, bl);
        requestPacket.setMassCommand();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        if (replyPacket.existsPart(10)) {
            this.parseinfo.setMassParseid(replyPacket.getBytes(replyPacket.getPartDataPos(), 12));
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.outPutTypes == null) {
            this.outPutTypes = new short[this.parseinfo.paramInfos.length + 1];
            this.outPutScale = new byte[this.parseinfo.paramInfos.length + 1];
        }
        this.outPutTypes[n] = (short)n2;
        this.outPutScale[n] = (byte)n3;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String string, int n, boolean bl) throws SQLException {
        requestPacket.initParseCommand(string, true, bl);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        ReplyPacket replyPacket = this.connection.execute(requestPacket, false, true, this, n);
        return replyPacket;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transAsciiStreamForInput(inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBigDecimalForInput(bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBinaryStreamForInput(inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBlobForInput(blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBooleanForInput(bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transByteForInput(by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBytesForInput(byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transCharacterStreamForInput(reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transClobForInput(clob);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.inputArgs[n - 1] = object = this.findColInfo(n).transDateForInput(date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transDoubleForInput(d);
    }

    public void setFloat(int n, float f) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transFloatForInput(f);
    }

    public void setInt(int n, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transIntForInput(n2);
    }

    public void setLastWasNull(boolean bl) {
        this.lastWasNull = bl;
    }

    public void setLong(int n, long l) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transLongForInput(l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.inputArgs[n - 1] = null;
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        Object object2;
        this.inputArgs[n - 1] = object2 = this.findColInfo(n).transObjectForInput(object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case 4: {
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.setInt(n, number.intValue());
                    return;
                }
            }
            case -5: {
                if (!(object instanceof Number)) break;
                Number number = (Number)object;
                this.setLong(n, number.longValue());
                return;
            }
        }
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
    }

    public void setShort(int n, short s) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transShortForInput(s);
    }

    public void setString(int n, String string) throws SQLException {
        Object object;
        this.assertOpen();
        this.inputArgs[n - 1] = string != null && this.connection.isSQLModeOracle && string.equalsIgnoreCase("") ? null : (object = this.findColInfo(n).transStringForInput(string));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.inputArgs[n - 1] = object = this.findColInfo(n).transTimeForInput(time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.inputArgs[n - 1] = object = this.findColInfo(n).transTimestampForInput(timestamp, calendar);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transUnicodeStreamForInput(inputStream);
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    protected FetchInfo getFetchInfo(String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        if (this.fetchInfo == null) {
            this.fetchInfo = new FetchInfo(this.connection, string, dBTechTranslatorArray, stringArray);
        } else if (!this.fetchInfo.getCursorName().equals(string)) {
            this.fetchInfo = new FetchInfo(this.connection, string, dBTechTranslatorArray, stringArray);
        }
        return this.fetchInfo;
    }

    protected void updateFetchInfo(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.parseinfo.setMetaData(dBTechTranslatorArray, stringArray);
    }

    public void close() throws SQLException {
        this.replyMem = null;
        if (this.connection != null && !this.parseinfo.cached) {
            this.connection.dropParseid(this.parseinfo.getParseId());
            this.parseinfo.setParseIdAndSession(null, -1);
            this.connection.dropParseid(this.parseinfo.getMassParseid());
            this.parseinfo.setMassParseid(null);
        }
        super.close();
    }

    protected void resetPutvals(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Putval putval = (Putval)enumeration.nextElement();
                putval.reset();
            }
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParamInfo(string).getColIndex() + 1, n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    public URL getURL(int n) throws SQLException {
        this.throwNotSupported("Type URL");
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.throwNotSupported("Type URL");
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParamInfo(string).getColIndex() + 1, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParamInfo(string).getColIndex() + 1, bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParamInfo(string).getColIndex() + 1, by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParamInfo(string).getColIndex() + 1, s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParamInfo(string).getColIndex() + 1, n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParamInfo(string).getColIndex() + 1, l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParamInfo(string).getColIndex() + 1, f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParamInfo(string).getColIndex() + 1, d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParamInfo(string).getColIndex() + 1, bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParamInfo(string).getColIndex() + 1, string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParamInfo(string).getColIndex() + 1, byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParamInfo(string).getColIndex() + 1, date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParamInfo(string).getColIndex() + 1, time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParamInfo(string).getColIndex() + 1, timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParamInfo(string).getColIndex() + 1, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParamInfo(string).getColIndex() + 1, inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParamInfo(string).getColIndex() + 1, reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParamInfo(string).getColIndex() + 1, date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParamInfo(string).getColIndex() + 1, time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParamInfo(string).getColIndex() + 1, timestamp, calendar);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParamInfo(string).getColIndex() + 1, n, string2);
    }

    public String getString(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getString(this, this.getReplyData());
    }

    public boolean getBoolean(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getBoolean(this, this.getReplyData());
    }

    public byte getByte(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getByte(this, this.getReplyData());
    }

    public short getShort(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getShort(this, this.getReplyData());
    }

    public int getInt(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getInt(this, this.getReplyData());
    }

    public long getLong(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getLong(this, this.getReplyData());
    }

    public float getFloat(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getFloat(this, this.getReplyData());
    }

    public double getDouble(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getDouble(this, this.getReplyData());
    }

    public byte[] getBytes(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getBytes(this, this.getReplyData());
    }

    public Date getDate(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getDate(this, this.getReplyData(), null);
    }

    public Time getTime(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getTime(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getTimestamp(this, this.getReplyData(), null);
    }

    public Object getObject(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getObject(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getBigDecimal(this, this.getReplyData());
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public Clob getClob(String string) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Array getArray(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getDate(this, this.getReplyData(), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getTime(this, this.getReplyData(), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(string).getTimestamp(this, this.getReplyData(), calendar);
    }

    public URL getURL(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.url.unsupported"));
        return null;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.url.unsupported"));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ParameterMetaDataSapDB.createParameterMetaDataSapDB(this.parseinfo.getParamInfo());
    }

    public AbstractABAPStreamGetval getOMSGetval(int n) throws SQLException {
        if (this.outputOMSStreams == null) {
            return null;
        }
        for (int i = 0; i < this.outputOMSStreams.size(); ++i) {
            AbstractABAPStreamGetval abstractABAPStreamGetval = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(i);
            if (abstractABAPStreamGetval == null || n != abstractABAPStreamGetval.getColIndex()) continue;
            return abstractABAPStreamGetval;
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.colindex.notfound", Integer.toString(n)));
    }

    private static class PutvalComparator
    implements Comparator {
        private PutvalComparator() {
        }

        public int compare(Object object, Object object2) {
            Putval putval = (Putval)object;
            Putval putval2 = (Putval)object2;
            int n = putval.getBufpos();
            int n2 = putval2.getBufpos();
            return n - n2;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }
}

