//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
//

using Glade;
using Gtk;
using System;
using System.Runtime.InteropServices;

namespace Imendio.Blam {
    
    public class HigDialog : Gtk.Dialog {
	~HigDialog ()
	{
	    Dispose ();
	}
	
	[DllImport ("libblam.so")]
	    static extern IntPtr blam_hig_dialog_new (IntPtr parent_window, DialogFlags flags, MessageType type, ButtonsType bt, string header, string msg, params object [] args);
	
	public HigDialog (Gtk.Window parentWindow, DialogFlags flags, MessageType type, ButtonsType bt, string header, string msg)
	{
	    IntPtr p = (parentWindow != null) ? parentWindow.Handle : ((IntPtr) 0);
	    
	    Raw = blam_hig_dialog_new (p, flags, type, bt, header, msg, null);
	}
    }

    public class ConfirmationDialog {
	[Widget] Gtk.Dialog confirmationDialog = null;
	[Widget] Gtk.Label  primaryLabel       = null;
	[Widget] Gtk.Label  secondaryLabel     = null;
	[Widget] Gtk.Button okButton           = null;
    
	private ConfirmationDialog (Gtk.Window parentWindow, string okButtonText, string primaryText, string secondaryText)
	{
            Glade.XML gladeXML = Glade.XML.FromAssembly("blam.glade",
                                                        "confirmationDialog", null);
            gladeXML.Autoconnect(this);
	    
	    confirmationDialog.TransientFor = parentWindow;
	    okButton.Label = okButtonText;

	    primaryLabel.Markup = "<span weight=\"bold\" size=\"larger\">" + primaryText + "</span>";

	    secondaryLabel.Text = secondaryText;
	}
	    
	
	public static Gtk.Dialog Create (Gtk.Window parentWindow, string okButtonText, string primaryText, string secondaryText)
	{
	    ConfirmationDialog dialog = new ConfirmationDialog (parentWindow, okButtonText, primaryText, secondaryText);

	    return dialog.confirmationDialog;
	}
    }
}
