// download.h   -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  Code to actually orchestrate a download.

#ifndef DOWNLOAD_H
#define DOWNLOAD_H

#include "vscreen/vs_minibuf_win.h"

class OpProgress;

bool do_pkglist_update(OpProgress *load_progress,
		       bool text_download);
// Performs a package-list update.  load_progress is a progress object which
// should be used to display the progress when the package cache is reloaded.
//
// Returns true if everything completed successfully, false otherwise.

bool do_install_run(OpProgress *load_progress,
		    bool text_download, bool download_only);
// Installs packages.  load_progress is a progress object used to display the
// progress when the package cache is reloaded.
//
// Returns true if everything completed successfully, false otherwise.

#endif
