/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.animation;

import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.CursorMovements;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.RawWidget;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/ajalt/mordant/animation/Animation;", "T", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Lcom/github/ajalt/mordant/terminal/Terminal;)V", "firstDraw", "", "interceptor", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "needsClear", "size", "Lkotlin/Pair;", "", "text", "", "clear", "", "getClear", "renderData", "Lcom/github/ajalt/mordant/rendering/Widget;", "data", "(Ljava/lang/Object;)Lcom/github/ajalt/mordant/rendering/Widget;", "update", "(Ljava/lang/Object;)V", "mordant"})
public abstract class Animation<T> {
    @NotNull
    private final Terminal terminal;
    @Nullable
    private Pair<Integer, Integer> size;
    @Nullable
    private String text;
    private boolean needsClear;
    private boolean firstDraw;
    @NotNull
    private final TerminalInterceptor interceptor;

    public Animation(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        this.terminal = terminal;
        this.firstDraw = true;
        this.interceptor = arg_0 -> Animation.interceptor$lambda$3(this, arg_0);
        if (this.terminal.getInfo().getOutputInteractive()) {
            this.terminal.addInterceptor$mordant(this.interceptor);
        }
    }

    @NotNull
    protected abstract Widget renderData(T var1);

    public final void clear() {
        block0: {
            this.needsClear = true;
            String string = this.getClear();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.text = null;
            this.terminal.removeInterceptor$mordant(this.interceptor);
            this.terminal.print(new RawWidget(it));
        }
    }

    private final String getClear() {
        Pair<Integer, Integer> pair2 = this.size;
        if (pair2 == null) {
            return null;
        }
        int height = ((Number)pair2.component1()).intValue();
        return this.terminal.getCursor().getMoves((Function1<? super CursorMovements, Unit>)new Function1<CursorMovements, Unit>(height, this){
            final /* synthetic */ int $height;
            final /* synthetic */ Animation<T> this$0;
            {
                this.$height = $height;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CursorMovements $this$getMoves) {
                Intrinsics.checkNotNullParameter($this$getMoves, "$this$getMoves");
                $this$getMoves.startOfLine();
                $this$getMoves.up(this.$height);
                if (Animation.access$getNeedsClear$p(this.this$0)) {
                    $this$getMoves.clearScreenAfterCursor();
                }
            }
        });
    }

    public final void update(T data) {
        boolean bl;
        Lines rendered = Widget.DefaultImpls.render$default(this.renderData(data), this.terminal, 0, 2, null);
        int height = rendered.getHeight();
        int width = rendered.getWidth();
        Animation animation2 = this;
        Pair<Integer, Integer> pair2 = this.size;
        if (pair2 != null) {
            Pair<Integer, Integer> pair3 = pair2;
            Animation animation3 = animation2;
            boolean bl2 = false;
            int h = ((Number)pair3.component1()).intValue();
            int w = ((Number)pair3.component2()).intValue();
            boolean bl3 = height < h || width < w;
            animation2 = animation3;
            bl = bl3;
        } else {
            bl = false;
        }
        animation2.needsClear = bl;
        this.size = TuplesKt.to(height, width);
        this.text = Terminal.render$default(this.terminal, rendered, null, null, null, null, 30, null);
        this.terminal.print(EmptyWidget.INSTANCE);
    }

    private static final PrintRequest interceptor$lambda$3(Animation this$0, PrintRequest req) {
        PrintRequest printRequest;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(req, "req");
        String string = this$0.text;
        if (string != null) {
            StringBuilder stringBuilder;
            String t = string;
            boolean bl = false;
            StringBuilder $this$interceptor_u24lambda_u243_u24lambda_u242_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            if (((CharSequence)req.getText()).length() > 0) {
                this$0.needsClear = true;
            }
            if (!this$0.firstDraw) {
                String string2 = this$0.getClear();
                if (string2 != null) {
                    String it = string2;
                    boolean bl3 = false;
                    $this$interceptor_u24lambda_u243_u24lambda_u242_u24lambda_u241.append(it);
                }
            }
            this$0.firstDraw = false;
            if (((CharSequence)req.getText()).length() > 0) {
                StringBuilder stringBuilder2 = $this$interceptor_u24lambda_u243_u24lambda_u242_u24lambda_u241.append(req.getText());
                Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
            }
            $this$interceptor_u24lambda_u243_u24lambda_u242_u24lambda_u241.append(t);
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
            boolean bl4 = !this$0.terminal.getInfo().getCrClearsLine();
            String string4 = string3;
            printRequest = new PrintRequest(string4, bl4);
        } else {
            printRequest = req;
        }
        return printRequest;
    }

    public static final /* synthetic */ boolean access$getNeedsClear$p(Animation $this) {
        return $this.needsClear;
    }
}

