\name{STAPLEImageFilter}
\alias{STAPLEImageFilter}
\title{STAPLEImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
The STAPLE filter implements the Simultaneous Truth and Performance
Level Estimation algorithm for generating ground truth volumes from a
set of binary expert segmentations.
STAPLEImageFilter}
\details{
The STAPLE algorithm treats segmentation as a pixelwise
classification, which leads to an averaging scheme that accounts for
systematic biases in the behavior of experts in order to generate a
fuzzy ground truth volume and simultaneous accuracy assessment of each
expert. The ground truth volumes produced by this filter are floating
point volumes of values between zero and one that indicate probability
of each pixel being in the object targeted by the segmentation.
The STAPLE algorithm is described in
S. Warfield, K. Zou, W. Wells, "Validation of image segmentation and
expert quality with an expectation-maximization algorithm" in MICCAI
2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag,
Heidelberg, Germany, 2002, pp. 298-306
INPUTS
Input volumes to the STAPLE filter must be binary segmentations of an
image, that is, there must be a single foreground value that
represents positively classified pixels (pixels that are considered to
belong inside the segmentation). Any number of background pixel values
may be present in the input images. You can, for example, input
volumes with many different labels as long as the structure you are
interested in creating ground truth for is consistently labeled among
all input volumes. Pixel type of the input volumes does not matter.
Specify the label value for positively classified pixels using
SetForegroundValue. All other labels will be considered to be
negatively classified pixels (background).
 Input volumes must all contain the same size RequestedRegions.
OUTPUTS
The STAPLE filter produces a single output volume with a range of
floating point values from zero to one. IT IS VERY IMPORTANT TO
INSTANTIATE THIS FILTER WITH A FLOATING POINT OUTPUT TYPE (floats or
doubles). You may threshold the output above some probability
threshold if you wish to produce a binary ground truth.
PARAMETERS
The STAPLE algorithm requires a number of inputs. You may specify any
number of input volumes using the SetInput(i, p_i) method, where i
ranges from zero to N-1, N is the total number of input segmentations,
and p_i is the SmartPointer to the i-th segmentation.
 The SetConfidenceWeight parameter is a modifier for the prior
probability that any pixel would be classified as inside the target
object. This implementation of the STAPLE algorithm automatically
calculates prior positive classification probability as the average
fraction of the image volume filled by the target object in each input
segmentation. The ConfidenceWeight parameter allows for scaling the of
this default prior probability: if g_t is the prior probability that a
pixel would be classified inside the target object, then g_t is set to
g_t * ConfidenceWeight before iterating on the solution. In general
ConfidenceWeight should be left to the default of 1.0.
You must provide a foreground value using SetForegroundValue that the
STAPLE algorithm will use to identify positively classified pixels in
the the input images. All other values in the image will be treated as
background values. For example, if your input segmentations consist of
1's everywhere inside the segmented region, then use
SetForegroundValue(1).
The STAPLE algorithm is an iterative E-M algorithm and will converge
on a solution after some number of iterations that cannot be known a
priori. After updating the filter, the total elapsed iterations taken
to converge on the solution can be queried through GetElapsedIterations() . You may also specify a MaximumNumberOfIterations, after which the
algorithm will stop iterating regardless of whether or not it has
converged. This implementation of the STAPLE algorithm will find the
solution to within seven digits of precision unless it is stopped
early.
Once updated, the Sensitivity (true positive fraction, q) and
Specificity (true negative fraction, q) for each expert input volume
can be queried using GetSensitivity(i) and GetSpecificity(i), where i
is the i-th input volume.
REQUIRED PARAMETERS
The only required parameters for this filter are the ForegroundValue
and the input volumes. All other parameters may be safely left to
their default values. Please see the paper cited above for more
information on the STAPLE algorithm and its parameters. A proper
understanding of the algorithm is important for interpreting the
results that it produces.
EVENTS
This filter invokes IterationEvent() at each iteration of the E-M
algorithm. Setting the AbortGenerateData() flag will cause the
algorithm to halt after the current iteration and produce results just
as if it had converged. The algorithm makes no attempt to report its
progress since the number of iterations needed cannot be known in
advance.
See:
STAPLE for the procedural interface
STAPLEImageFilter}
%C++ includes: sitkSTAPLEImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{double GetConfidenceWeight() const:}{
Scales the estimated prior probability that a pixel will be inside the
targeted object of segmentation. The default prior probability g_t is
calculated automatically as the average fraction of positively
classified pixels to the total size of the volume (across all input
volumes). ConfidenceWeight will scale this default value as g_t = g_t
* ConfidenceWeight. In general, ConfidenceWeight should be left to the
default of 1.0.
}
\item{uint32_t GetElapsedIterations() const:}{
Get the number of elapsed iterations of the iterative E-M algorithm.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetForegroundValue() const:}{
Set get the binary ON value of the input image.
}
\item{unsigned int GetMaximumIterations() const:}{
Set/Get the maximum number of iterations after which the STAPLE
algorithm will be considered to have converged. In general this SHOULD
NOT be set and the algorithm should be allowed to converge on its own.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetSensitivity() const:}{
After the filter is updated, this method returns a std::vector<double>
of all Sensitivity (true positive fraction, p) values for the expert
input volumes.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::vector< double > GetSpecificity() const:}{
After the filter is updated, this method returns the Specificity (true
negative fraction, q) value for the i-th expert input volume.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self SetConfidenceWeight(double ConfidenceWeight):}{
Scales the estimated prior probability that a pixel will be inside the
targeted object of segmentation. The default prior probability g_t is
calculated automatically as the average fraction of positively
classified pixels to the total size of the volume (across all input
volumes). ConfidenceWeight will scale this default value as g_t = g_t
* ConfidenceWeight. In general, ConfidenceWeight should be left to the
default of 1.0.
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set get the binary ON value of the input image.
}
\item{Self SetMaximumIterations(unsigned int MaximumIterations):}{
Set/Get the maximum number of iterations after which the STAPLE
algorithm will be considered to have converged. In general this SHOULD
NOT be set and the algorithm should be allowed to converge on its own.
}
\item{ STAPLEImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~STAPLEImageFilter():}{
Destructor
}
}
}
