# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: BSD-2-Clause

# Automatically generated by Numbast Static Binding Generator
# Generator Information:
# Ast_canopy version: 0.5.1
# Numbast version: 0.5.1
# Generation command: /home/lakshayg/micromamba/envs/numbast/lib/python3.13/site-packages/numbast/__main__.py --cfg-path configs/cuda_fp16.yml --output-dir ./numba_cuda/numba/cuda/_internal/
# Static binding generator parameters: {'cfg_path': 'configs/cuda_fp16.yml', 'output_dir': './numba_cuda/numba/cuda/_internal/', 'run_ruff_format': True}
# Config file path (relative to the path of the generated binding): ../../../../../configs/cuda_fp16.yml
# Cudatoolkit version: (12, 9)
# Default CUDA_HOME path: /home/lakshayg/micromamba/envs/numbast


# Imports:
import io
import operator

import numba
from llvmlite import ir
from numba.cuda import types
from numba.cuda.cudadrv.driver import _have_nvjitlink
from numba.cuda.datamodel import PrimitiveModel, StructModel
from numba.cuda.core.errors import NumbaPerformanceWarning
from numba.cuda.extending import (
    lower_cast,
    make_attribute_wrapper,
    register_model,
)
from numba.cuda.core.imputils import Registry as TargetRegistry
from numba.cuda.core.imputils import lower_cast
from numba.cuda.typing import signature
from numba.cuda import CUSource, declare_device
from numba.cuda._internal.cuda_bf16 import _type___nv_bfloat16
from numba.cuda.typing.templates import (
    AbstractTemplate,
    AttributeTemplate,
    ConcreteTemplate,
)
from numba.cuda.typing.templates import Registry as TypingRegistry
from numba.cuda.vector_types import vector_types
from numba.cuda.extending import as_numba_type
from numba.cuda.types import (
    CPointer,
    Function,
    Number,
    Type,
    bool_,
    float32,
    float64,
    int8,
    int16,
    int32,
    int64,
    uint8,
    uint16,
    uint32,
    uint64,
    void,
)
from warnings import warn

float32x2 = vector_types["float32x2"]


typing_registry = TypingRegistry()
register = typing_registry.register
register_attr = typing_registry.register_attr
register_global = typing_registry.register_global
target_registry = TargetRegistry()
lower = target_registry.lower
lower_attr = target_registry.lower_getattr
lower_constant = target_registry.lower_constant

# Shim Stream:

lto_warning_raised = False


def lto_warning_callback(_):
    global lto_warning_raised
    if not _have_nvjitlink():
        if not lto_warning_raised:
            lto_warning_raised = True
            msg = "float16 relies on LTO for performance. LTO requires nvjitlink, which is not available or not sufficiently recent (>=12.3)"
            warn(NumbaPerformanceWarning(msg))


class _KeyedStringIO(io.StringIO):
    def __init__(self, *arg, **kwarg):
        super().__init__(*arg, *kwarg)
        self._keys = set()

    def write_with_key(self, key: str, value: str):
        if key in self._keys:
            return
        self._keys.add(key)
        self.write(value)

    def reset(self):
        self._keys.clear()
        self.seek(0)


shim_defines = ""
shim_include = "#include <" + "cuda_fp16.h" + ">"
shim_prefix = shim_defines + "\n" + shim_include
shim_stream = _KeyedStringIO()
shim_stream.write(shim_prefix)
shim_obj = CUSource(shim_stream, setup_callback=lto_warning_callback)


# Enums:


# Structs:


# Typing for unnamed1362071
class _type_class_unnamed1362071(Type):
    def __init__(self):
        super().__init__(name="unnamed1362071")
        self.alignof_ = 2
        self.bitwidth = 2 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_unnamed1362071 = _type_class_unnamed1362071()


# Make Python API for struct
unnamed1362071 = type("unnamed1362071", (), {"_nbtype": _type_unnamed1362071})

as_numba_type.register(unnamed1362071, _type_unnamed1362071)


@register_model(_type_class_unnamed1362071)
class _model_unnamed1362071(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("x", uint16)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_unnamed1362071(AttributeTemplate):
    key = globals()["unnamed1362071"]

    def resolve_x(self, obj):
        return uint16


make_attribute_wrapper(_type_class_unnamed1362071, "x", "x")


@register
class _ctor_template_unnamed1362071(ConcreteTemplate):
    key = globals()["unnamed1362071"]
    cases = []


register_global(unnamed1362071, Function(_ctor_template_unnamed1362071))


# Typing for unnamed1362180
class _type_class_unnamed1362180(Type):
    def __init__(self):
        super().__init__(name="unnamed1362180")
        self.alignof_ = 4
        self.bitwidth = 4 * 8

    def can_convert_from(self, typingctx, other):
        from numba.cuda.typeconv import Conversion

        if other in []:
            return Conversion.safe


_type_unnamed1362180 = _type_class_unnamed1362180()


# Make Python API for struct
unnamed1362180 = type("unnamed1362180", (), {"_nbtype": _type_unnamed1362180})

as_numba_type.register(unnamed1362180, _type_unnamed1362180)


@register_model(_type_class_unnamed1362180)
class _model_unnamed1362180(StructModel):
    def __init__(self, dmm, fe_type):
        members = [("x", uint16), ("y", uint16)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_unnamed1362180(AttributeTemplate):
    key = globals()["unnamed1362180"]

    def resolve_x(self, obj):
        return uint16

    def resolve_y(self, obj):
        return uint16


make_attribute_wrapper(_type_class_unnamed1362180, "x", "x")


make_attribute_wrapper(_type_class_unnamed1362180, "y", "y")


@register
class _ctor_template_unnamed1362180(ConcreteTemplate):
    key = globals()["unnamed1362180"]
    cases = []


register_global(unnamed1362180, Function(_ctor_template_unnamed1362180))

__half = _type___half = numba.cuda.types.float16
setattr(__half, "alignof_", 2)
setattr(__half, "align", 2)


def _lower__ZN6__halfC1Ev(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ev_nbst(int &ignore, __half *self ) {
        new (self) __half();
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ev_nbst",
        int32(
            CPointer(_type___half),
        ),
    )

    def __half_device_caller(arg_0):
        return _ctor_decl___half(arg_0)

    @lower(
        __half,
    )
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ev_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(
                int32,
                CPointer(_type___half),
            ),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ev(shim_stream, shim_obj)


def _lower__ZN6__halfC1ERK10__half_raw(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1ERK10__half_raw_nbst(int &ignore, __half *self , __half_raw* hr) {
        new (self) __half(*hr);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1ERK10__half_raw_nbst",
        int32(CPointer(_type___half), CPointer(_type_unnamed1362071)),
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, _type_unnamed1362071)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZN6__halfC1ERK10__half_raw_nbst", shim_raw_str
        )
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(
                int32, CPointer(_type___half), CPointer(_type_unnamed1362071)
            ),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1ERK10__half_raw(shim_stream, shim_obj)


def _lower__ZN6__halfC1E13__nv_bfloat16(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1E13__nv_bfloat16_nbst(int &ignore, __half *self , __nv_bfloat16* f) {
        new (self) __half(*f);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1E13__nv_bfloat16_nbst",
        int32(CPointer(_type___half), CPointer(_type___nv_bfloat16)),
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, _type___nv_bfloat16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZN6__halfC1E13__nv_bfloat16_nbst", shim_raw_str
        )
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(
                int32, CPointer(_type___half), CPointer(_type___nv_bfloat16)
            ),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1E13__nv_bfloat16(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ef(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ef_nbst(int &ignore, __half *self , float* f) {
        new (self) __half(*f);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ef_nbst", int32(CPointer(_type___half), CPointer(float32))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, float32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ef_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(float32)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ef(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ed(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ed_nbst(int &ignore, __half *self , double* f) {
        new (self) __half(*f);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ed_nbst", int32(CPointer(_type___half), CPointer(float64))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, float64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ed_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(float64)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ed(shim_stream, shim_obj)


def _lower__ZN6__halfC1Es(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Es_nbst(int &ignore, __half *self , short* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Es_nbst", int32(CPointer(_type___half), CPointer(int16))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, int16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Es_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(int16)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Es(shim_stream, shim_obj)


def _lower__ZN6__halfC1Et(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Et_nbst(int &ignore, __half *self , unsigned short* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Et_nbst", int32(CPointer(_type___half), CPointer(uint16))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, uint16)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Et_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(uint16)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Et(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ei(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ei_nbst(int &ignore, __half *self , int* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ei_nbst", int32(CPointer(_type___half), CPointer(int32))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, int32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ei_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(int32)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ei(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ej(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ej_nbst(int &ignore, __half *self , unsigned int* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ej_nbst", int32(CPointer(_type___half), CPointer(uint32))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, uint32)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ej_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(uint32)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ej(shim_stream, shim_obj)


def _lower__ZN6__halfC1El(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1El_nbst(int &ignore, __half *self , long* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1El_nbst", int32(CPointer(_type___half), CPointer(int64))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1El_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(int64)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1El(shim_stream, shim_obj)


def _lower__ZN6__halfC1Em(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Em_nbst(int &ignore, __half *self , unsigned long* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Em_nbst", int32(CPointer(_type___half), CPointer(uint64))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Em_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(uint64)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Em(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ex(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ex_nbst(int &ignore, __half *self , long long* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ex_nbst", int32(CPointer(_type___half), CPointer(int64))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, int64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ex_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(int64)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ex(shim_stream, shim_obj)


def _lower__ZN6__halfC1Ey(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZN6__halfC1Ey_nbst(int &ignore, __half *self , unsigned long long* val) {
        new (self) __half(*val);
        return 0;
    }
        """

    _ctor_decl___half = declare_device(
        "_ZN6__halfC1Ey_nbst", int32(CPointer(_type___half), CPointer(uint64))
    )

    def __half_device_caller(arg_0, arg_1):
        return _ctor_decl___half(arg_0, arg_1)

    @lower(__half, uint64)
    def ctor_impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZN6__halfC1Ey_nbst", shim_raw_str)
        selfptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        argptrs = [
            builder.alloca(context.get_value_type(arg)) for arg in sig.args
        ]
        for ptr, ty, arg in zip(argptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        context.compile_internal(
            builder,
            __half_device_caller,
            signature(int32, CPointer(_type___half), CPointer(uint64)),
            (selfptr, *argptrs),
        )
        return builder.load(
            selfptr, align=getattr(_type___half, "alignof_", None)
        )


_lower__ZN6__halfC1Ey(shim_stream, shim_obj)


@register
class _ctor_template___half(ConcreteTemplate):
    key = globals()["__half"]
    cases = [
        signature(
            _type___half,
        ),
        signature(_type___half, _type_unnamed1362071),
        signature(_type___half, _type___nv_bfloat16),
        signature(_type___half, float32),
        signature(_type___half, float64),
        signature(_type___half, int16),
        signature(_type___half, uint16),
        signature(_type___half, int32),
        signature(_type___half, uint32),
        signature(_type___half, int64),
        signature(_type___half, uint64),
        signature(_type___half, int64),
        signature(_type___half, uint64),
    ]


register_global(__half, Function(_ctor_template___half))


def _from___half_to__type_unnamed1362071_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    ____half__ZNK6__halfcv10__half_rawEv_1(__half_raw &retval, __half *self) {
        retval = self->operator __half_raw();
        return 0;
    }
        """

    _op_decl___half = declare_device(
        "____half__ZNK6__halfcv10__half_rawEv_1",
        _type_unnamed1362071(
            CPointer(_type___half),
        ),
    )

    def _conversion_op_caller___half(arg):
        return _op_decl___half(arg)

    @lower_cast(_type___half, _type_unnamed1362071)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "____half__ZNK6__halfcv10__half_rawEv_1", shim_raw_str
        )
        ptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        builder.store(value, ptr, align=getattr(_type___half, "align", None))

        return context.compile_internal(
            builder,
            _conversion_op_caller___half,
            signature(
                _type_unnamed1362071,
                CPointer(_type___half),
            ),
            (ptr,),
        )


_from___half_to__type_unnamed1362071_lower(shim_stream, shim_obj)


def _from___half_to__type_unnamed1362071_lower(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    ____half__ZNVK6__halfcv10__half_rawEv_1(__half_raw &retval, __half *self) {
        retval = self->operator __half_raw();
        return 0;
    }
        """

    _op_decl___half = declare_device(
        "____half__ZNVK6__halfcv10__half_rawEv_1",
        _type_unnamed1362071(
            CPointer(_type___half),
        ),
    )

    def _conversion_op_caller___half(arg):
        return _op_decl___half(arg)

    @lower_cast(_type___half, _type_unnamed1362071)
    def impl(context, builder, fromty, toty, value):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "____half__ZNVK6__halfcv10__half_rawEv_1", shim_raw_str
        )
        ptr = builder.alloca(
            context.get_value_type(_type___half), name="selfptr"
        )
        builder.store(value, ptr, align=getattr(_type___half, "align", None))

        return context.compile_internal(
            builder,
            _conversion_op_caller___half,
            signature(
                _type_unnamed1362071,
                CPointer(_type___half),
            ),
            (ptr,),
        )


_from___half_to__type_unnamed1362071_lower(shim_stream, shim_obj)


# Functions:


def __double2half():
    pass


def _lower__ZL13__double2halfd_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__double2halfd_nbst(__half &retval , double* a) {
        retval = __double2half(*a);
        return 0;
    }
        """

    _ZL13__double2halfd_nbst = declare_device(
        "_ZL13__double2halfd_nbst", _type___half(CPointer(float64))
    )

    def _ZL13__double2halfd_nbst_caller(arg_0):
        return _ZL13__double2halfd_nbst(arg_0)

    @lower(__double2half, float64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__double2halfd_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__double2halfd_nbst_caller,
            signature(_type___half, CPointer(float64)),
            ptrs,
        )


_lower__ZL13__double2halfd_nbst(shim_stream, shim_obj)


def __float2half():
    pass


def _lower__ZL12__float2halff_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__float2halff_nbst(__half &retval , float* a) {
        retval = __float2half(*a);
        return 0;
    }
        """

    _ZL12__float2halff_nbst = declare_device(
        "_ZL12__float2halff_nbst", _type___half(CPointer(float32))
    )

    def _ZL12__float2halff_nbst_caller(arg_0):
        return _ZL12__float2halff_nbst(arg_0)

    @lower(__float2half, float32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL12__float2halff_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__float2halff_nbst_caller,
            signature(_type___half, CPointer(float32)),
            ptrs,
        )


_lower__ZL12__float2halff_nbst(shim_stream, shim_obj)


def __float2half_rn():
    pass


def _lower__ZL15__float2half_rnf_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__float2half_rnf_nbst(__half &retval , float* a) {
        retval = __float2half_rn(*a);
        return 0;
    }
        """

    _ZL15__float2half_rnf_nbst = declare_device(
        "_ZL15__float2half_rnf_nbst", _type___half(CPointer(float32))
    )

    def _ZL15__float2half_rnf_nbst_caller(arg_0):
        return _ZL15__float2half_rnf_nbst(arg_0)

    @lower(__float2half_rn, float32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__float2half_rnf_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__float2half_rnf_nbst_caller,
            signature(_type___half, CPointer(float32)),
            ptrs,
        )


_lower__ZL15__float2half_rnf_nbst(shim_stream, shim_obj)


def __float2half_rz():
    pass


def _lower__ZL15__float2half_rzf_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__float2half_rzf_nbst(__half &retval , float* a) {
        retval = __float2half_rz(*a);
        return 0;
    }
        """

    _ZL15__float2half_rzf_nbst = declare_device(
        "_ZL15__float2half_rzf_nbst", _type___half(CPointer(float32))
    )

    def _ZL15__float2half_rzf_nbst_caller(arg_0):
        return _ZL15__float2half_rzf_nbst(arg_0)

    @lower(__float2half_rz, float32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__float2half_rzf_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__float2half_rzf_nbst_caller,
            signature(_type___half, CPointer(float32)),
            ptrs,
        )


_lower__ZL15__float2half_rzf_nbst(shim_stream, shim_obj)


def __float2half_rd():
    pass


def _lower__ZL15__float2half_rdf_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__float2half_rdf_nbst(__half &retval , float* a) {
        retval = __float2half_rd(*a);
        return 0;
    }
        """

    _ZL15__float2half_rdf_nbst = declare_device(
        "_ZL15__float2half_rdf_nbst", _type___half(CPointer(float32))
    )

    def _ZL15__float2half_rdf_nbst_caller(arg_0):
        return _ZL15__float2half_rdf_nbst(arg_0)

    @lower(__float2half_rd, float32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__float2half_rdf_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__float2half_rdf_nbst_caller,
            signature(_type___half, CPointer(float32)),
            ptrs,
        )


_lower__ZL15__float2half_rdf_nbst(shim_stream, shim_obj)


def __float2half_ru():
    pass


def _lower__ZL15__float2half_ruf_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__float2half_ruf_nbst(__half &retval , float* a) {
        retval = __float2half_ru(*a);
        return 0;
    }
        """

    _ZL15__float2half_ruf_nbst = declare_device(
        "_ZL15__float2half_ruf_nbst", _type___half(CPointer(float32))
    )

    def _ZL15__float2half_ruf_nbst_caller(arg_0):
        return _ZL15__float2half_ruf_nbst(arg_0)

    @lower(__float2half_ru, float32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__float2half_ruf_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__float2half_ruf_nbst_caller,
            signature(_type___half, CPointer(float32)),
            ptrs,
        )


_lower__ZL15__float2half_ruf_nbst(shim_stream, shim_obj)


def __half2float():
    pass


def _lower__ZL12__half2float6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__half2float6__half_nbst(float &retval , __half* a) {
        retval = __half2float(*a);
        return 0;
    }
        """

    _ZL12__half2float6__half_nbst = declare_device(
        "_ZL12__half2float6__half_nbst", float32(CPointer(_type___half))
    )

    def _ZL12__half2float6__half_nbst_caller(arg_0):
        return _ZL12__half2float6__half_nbst(arg_0)

    @lower(__half2float, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12__half2float6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__half2float6__half_nbst_caller,
            signature(float32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12__half2float6__half_nbst(shim_stream, shim_obj)


def __half2char_rz():
    pass


def _lower__ZL14__half2char_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__half2char_rz6__half_nbst(signed char &retval , __half* h) {
        retval = __half2char_rz(*h);
        return 0;
    }
        """

    _ZL14__half2char_rz6__half_nbst = declare_device(
        "_ZL14__half2char_rz6__half_nbst", int8(CPointer(_type___half))
    )

    def _ZL14__half2char_rz6__half_nbst_caller(arg_0):
        return _ZL14__half2char_rz6__half_nbst(arg_0)

    @lower(__half2char_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__half2char_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__half2char_rz6__half_nbst_caller,
            signature(int8, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL14__half2char_rz6__half_nbst(shim_stream, shim_obj)


def __half2uchar_rz():
    pass


def _lower__ZL15__half2uchar_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half2uchar_rz6__half_nbst(unsigned char &retval , __half* h) {
        retval = __half2uchar_rz(*h);
        return 0;
    }
        """

    _ZL15__half2uchar_rz6__half_nbst = declare_device(
        "_ZL15__half2uchar_rz6__half_nbst", uint8(CPointer(_type___half))
    )

    def _ZL15__half2uchar_rz6__half_nbst_caller(arg_0):
        return _ZL15__half2uchar_rz6__half_nbst(arg_0)

    @lower(__half2uchar_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half2uchar_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half2uchar_rz6__half_nbst_caller,
            signature(uint8, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half2uchar_rz6__half_nbst(shim_stream, shim_obj)


def __half2short_rz():
    pass


def _lower__ZL15__half2short_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half2short_rz6__half_nbst(short &retval , __half* h) {
        retval = __half2short_rz(*h);
        return 0;
    }
        """

    _ZL15__half2short_rz6__half_nbst = declare_device(
        "_ZL15__half2short_rz6__half_nbst", int16(CPointer(_type___half))
    )

    def _ZL15__half2short_rz6__half_nbst_caller(arg_0):
        return _ZL15__half2short_rz6__half_nbst(arg_0)

    @lower(__half2short_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half2short_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half2short_rz6__half_nbst_caller,
            signature(int16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half2short_rz6__half_nbst(shim_stream, shim_obj)


def __half2ushort_rz():
    pass


def _lower__ZL16__half2ushort_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__half2ushort_rz6__half_nbst(unsigned short &retval , __half* h) {
        retval = __half2ushort_rz(*h);
        return 0;
    }
        """

    _ZL16__half2ushort_rz6__half_nbst = declare_device(
        "_ZL16__half2ushort_rz6__half_nbst", uint16(CPointer(_type___half))
    )

    def _ZL16__half2ushort_rz6__half_nbst_caller(arg_0):
        return _ZL16__half2ushort_rz6__half_nbst(arg_0)

    @lower(__half2ushort_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__half2ushort_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__half2ushort_rz6__half_nbst_caller,
            signature(uint16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL16__half2ushort_rz6__half_nbst(shim_stream, shim_obj)


def __half2int_rz():
    pass


def _lower__ZL13__half2int_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2int_rz6__half_nbst(int &retval , __half* h) {
        retval = __half2int_rz(*h);
        return 0;
    }
        """

    _ZL13__half2int_rz6__half_nbst = declare_device(
        "_ZL13__half2int_rz6__half_nbst", int32(CPointer(_type___half))
    )

    def _ZL13__half2int_rz6__half_nbst_caller(arg_0):
        return _ZL13__half2int_rz6__half_nbst(arg_0)

    @lower(__half2int_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2int_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2int_rz6__half_nbst_caller,
            signature(int32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2int_rz6__half_nbst(shim_stream, shim_obj)


def __half2uint_rz():
    pass


def _lower__ZL14__half2uint_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__half2uint_rz6__half_nbst(unsigned int &retval , __half* h) {
        retval = __half2uint_rz(*h);
        return 0;
    }
        """

    _ZL14__half2uint_rz6__half_nbst = declare_device(
        "_ZL14__half2uint_rz6__half_nbst", uint32(CPointer(_type___half))
    )

    def _ZL14__half2uint_rz6__half_nbst_caller(arg_0):
        return _ZL14__half2uint_rz6__half_nbst(arg_0)

    @lower(__half2uint_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__half2uint_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__half2uint_rz6__half_nbst_caller,
            signature(uint32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL14__half2uint_rz6__half_nbst(shim_stream, shim_obj)


def __half2ll_rz():
    pass


def _lower__ZL12__half2ll_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__half2ll_rz6__half_nbst(long long &retval , __half* h) {
        retval = __half2ll_rz(*h);
        return 0;
    }
        """

    _ZL12__half2ll_rz6__half_nbst = declare_device(
        "_ZL12__half2ll_rz6__half_nbst", int64(CPointer(_type___half))
    )

    def _ZL12__half2ll_rz6__half_nbst_caller(arg_0):
        return _ZL12__half2ll_rz6__half_nbst(arg_0)

    @lower(__half2ll_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12__half2ll_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__half2ll_rz6__half_nbst_caller,
            signature(int64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12__half2ll_rz6__half_nbst(shim_stream, shim_obj)


def __half2ull_rz():
    pass


def _lower__ZL13__half2ull_rz6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2ull_rz6__half_nbst(unsigned long long &retval , __half* h) {
        retval = __half2ull_rz(*h);
        return 0;
    }
        """

    _ZL13__half2ull_rz6__half_nbst = declare_device(
        "_ZL13__half2ull_rz6__half_nbst", uint64(CPointer(_type___half))
    )

    def _ZL13__half2ull_rz6__half_nbst_caller(arg_0):
        return _ZL13__half2ull_rz6__half_nbst(arg_0)

    @lower(__half2ull_rz, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2ull_rz6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2ull_rz6__half_nbst_caller,
            signature(uint64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2ull_rz6__half_nbst(shim_stream, shim_obj)


def __half2int_rn():
    pass


def _lower__ZL13__half2int_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2int_rn6__half_nbst(int &retval , __half* h) {
        retval = __half2int_rn(*h);
        return 0;
    }
        """

    _ZL13__half2int_rn6__half_nbst = declare_device(
        "_ZL13__half2int_rn6__half_nbst", int32(CPointer(_type___half))
    )

    def _ZL13__half2int_rn6__half_nbst_caller(arg_0):
        return _ZL13__half2int_rn6__half_nbst(arg_0)

    @lower(__half2int_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2int_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2int_rn6__half_nbst_caller,
            signature(int32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2int_rn6__half_nbst(shim_stream, shim_obj)


def __half2int_rd():
    pass


def _lower__ZL13__half2int_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2int_rd6__half_nbst(int &retval , __half* h) {
        retval = __half2int_rd(*h);
        return 0;
    }
        """

    _ZL13__half2int_rd6__half_nbst = declare_device(
        "_ZL13__half2int_rd6__half_nbst", int32(CPointer(_type___half))
    )

    def _ZL13__half2int_rd6__half_nbst_caller(arg_0):
        return _ZL13__half2int_rd6__half_nbst(arg_0)

    @lower(__half2int_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2int_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2int_rd6__half_nbst_caller,
            signature(int32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2int_rd6__half_nbst(shim_stream, shim_obj)


def __half2int_ru():
    pass


def _lower__ZL13__half2int_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2int_ru6__half_nbst(int &retval , __half* h) {
        retval = __half2int_ru(*h);
        return 0;
    }
        """

    _ZL13__half2int_ru6__half_nbst = declare_device(
        "_ZL13__half2int_ru6__half_nbst", int32(CPointer(_type___half))
    )

    def _ZL13__half2int_ru6__half_nbst_caller(arg_0):
        return _ZL13__half2int_ru6__half_nbst(arg_0)

    @lower(__half2int_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2int_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2int_ru6__half_nbst_caller,
            signature(int32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2int_ru6__half_nbst(shim_stream, shim_obj)


def __int2half_rn():
    pass


def _lower__ZL13__int2half_rni_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__int2half_rni_nbst(__half &retval , int* i) {
        retval = __int2half_rn(*i);
        return 0;
    }
        """

    _ZL13__int2half_rni_nbst = declare_device(
        "_ZL13__int2half_rni_nbst", _type___half(CPointer(int32))
    )

    def _ZL13__int2half_rni_nbst_caller(arg_0):
        return _ZL13__int2half_rni_nbst(arg_0)

    @lower(__int2half_rn, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__int2half_rni_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__int2half_rni_nbst_caller,
            signature(_type___half, CPointer(int32)),
            ptrs,
        )


_lower__ZL13__int2half_rni_nbst(shim_stream, shim_obj)


def __int2half_rz():
    pass


def _lower__ZL13__int2half_rzi_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__int2half_rzi_nbst(__half &retval , int* i) {
        retval = __int2half_rz(*i);
        return 0;
    }
        """

    _ZL13__int2half_rzi_nbst = declare_device(
        "_ZL13__int2half_rzi_nbst", _type___half(CPointer(int32))
    )

    def _ZL13__int2half_rzi_nbst_caller(arg_0):
        return _ZL13__int2half_rzi_nbst(arg_0)

    @lower(__int2half_rz, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__int2half_rzi_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__int2half_rzi_nbst_caller,
            signature(_type___half, CPointer(int32)),
            ptrs,
        )


_lower__ZL13__int2half_rzi_nbst(shim_stream, shim_obj)


def __int2half_rd():
    pass


def _lower__ZL13__int2half_rdi_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__int2half_rdi_nbst(__half &retval , int* i) {
        retval = __int2half_rd(*i);
        return 0;
    }
        """

    _ZL13__int2half_rdi_nbst = declare_device(
        "_ZL13__int2half_rdi_nbst", _type___half(CPointer(int32))
    )

    def _ZL13__int2half_rdi_nbst_caller(arg_0):
        return _ZL13__int2half_rdi_nbst(arg_0)

    @lower(__int2half_rd, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__int2half_rdi_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__int2half_rdi_nbst_caller,
            signature(_type___half, CPointer(int32)),
            ptrs,
        )


_lower__ZL13__int2half_rdi_nbst(shim_stream, shim_obj)


def __int2half_ru():
    pass


def _lower__ZL13__int2half_rui_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__int2half_rui_nbst(__half &retval , int* i) {
        retval = __int2half_ru(*i);
        return 0;
    }
        """

    _ZL13__int2half_rui_nbst = declare_device(
        "_ZL13__int2half_rui_nbst", _type___half(CPointer(int32))
    )

    def _ZL13__int2half_rui_nbst_caller(arg_0):
        return _ZL13__int2half_rui_nbst(arg_0)

    @lower(__int2half_ru, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__int2half_rui_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__int2half_rui_nbst_caller,
            signature(_type___half, CPointer(int32)),
            ptrs,
        )


_lower__ZL13__int2half_rui_nbst(shim_stream, shim_obj)


def __half2short_rn():
    pass


def _lower__ZL15__half2short_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half2short_rn6__half_nbst(short &retval , __half* h) {
        retval = __half2short_rn(*h);
        return 0;
    }
        """

    _ZL15__half2short_rn6__half_nbst = declare_device(
        "_ZL15__half2short_rn6__half_nbst", int16(CPointer(_type___half))
    )

    def _ZL15__half2short_rn6__half_nbst_caller(arg_0):
        return _ZL15__half2short_rn6__half_nbst(arg_0)

    @lower(__half2short_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half2short_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half2short_rn6__half_nbst_caller,
            signature(int16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half2short_rn6__half_nbst(shim_stream, shim_obj)


def __half2short_rd():
    pass


def _lower__ZL15__half2short_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half2short_rd6__half_nbst(short &retval , __half* h) {
        retval = __half2short_rd(*h);
        return 0;
    }
        """

    _ZL15__half2short_rd6__half_nbst = declare_device(
        "_ZL15__half2short_rd6__half_nbst", int16(CPointer(_type___half))
    )

    def _ZL15__half2short_rd6__half_nbst_caller(arg_0):
        return _ZL15__half2short_rd6__half_nbst(arg_0)

    @lower(__half2short_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half2short_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half2short_rd6__half_nbst_caller,
            signature(int16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half2short_rd6__half_nbst(shim_stream, shim_obj)


def __half2short_ru():
    pass


def _lower__ZL15__half2short_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half2short_ru6__half_nbst(short &retval , __half* h) {
        retval = __half2short_ru(*h);
        return 0;
    }
        """

    _ZL15__half2short_ru6__half_nbst = declare_device(
        "_ZL15__half2short_ru6__half_nbst", int16(CPointer(_type___half))
    )

    def _ZL15__half2short_ru6__half_nbst_caller(arg_0):
        return _ZL15__half2short_ru6__half_nbst(arg_0)

    @lower(__half2short_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half2short_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half2short_ru6__half_nbst_caller,
            signature(int16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half2short_ru6__half_nbst(shim_stream, shim_obj)


def __short2half_rn():
    pass


def _lower__ZL15__short2half_rns_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__short2half_rns_nbst(__half &retval , short* i) {
        retval = __short2half_rn(*i);
        return 0;
    }
        """

    _ZL15__short2half_rns_nbst = declare_device(
        "_ZL15__short2half_rns_nbst", _type___half(CPointer(int16))
    )

    def _ZL15__short2half_rns_nbst_caller(arg_0):
        return _ZL15__short2half_rns_nbst(arg_0)

    @lower(__short2half_rn, int16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__short2half_rns_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__short2half_rns_nbst_caller,
            signature(_type___half, CPointer(int16)),
            ptrs,
        )


_lower__ZL15__short2half_rns_nbst(shim_stream, shim_obj)


def __short2half_rz():
    pass


def _lower__ZL15__short2half_rzs_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__short2half_rzs_nbst(__half &retval , short* i) {
        retval = __short2half_rz(*i);
        return 0;
    }
        """

    _ZL15__short2half_rzs_nbst = declare_device(
        "_ZL15__short2half_rzs_nbst", _type___half(CPointer(int16))
    )

    def _ZL15__short2half_rzs_nbst_caller(arg_0):
        return _ZL15__short2half_rzs_nbst(arg_0)

    @lower(__short2half_rz, int16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__short2half_rzs_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__short2half_rzs_nbst_caller,
            signature(_type___half, CPointer(int16)),
            ptrs,
        )


_lower__ZL15__short2half_rzs_nbst(shim_stream, shim_obj)


def __short2half_rd():
    pass


def _lower__ZL15__short2half_rds_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__short2half_rds_nbst(__half &retval , short* i) {
        retval = __short2half_rd(*i);
        return 0;
    }
        """

    _ZL15__short2half_rds_nbst = declare_device(
        "_ZL15__short2half_rds_nbst", _type___half(CPointer(int16))
    )

    def _ZL15__short2half_rds_nbst_caller(arg_0):
        return _ZL15__short2half_rds_nbst(arg_0)

    @lower(__short2half_rd, int16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__short2half_rds_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__short2half_rds_nbst_caller,
            signature(_type___half, CPointer(int16)),
            ptrs,
        )


_lower__ZL15__short2half_rds_nbst(shim_stream, shim_obj)


def __short2half_ru():
    pass


def _lower__ZL15__short2half_rus_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__short2half_rus_nbst(__half &retval , short* i) {
        retval = __short2half_ru(*i);
        return 0;
    }
        """

    _ZL15__short2half_rus_nbst = declare_device(
        "_ZL15__short2half_rus_nbst", _type___half(CPointer(int16))
    )

    def _ZL15__short2half_rus_nbst_caller(arg_0):
        return _ZL15__short2half_rus_nbst(arg_0)

    @lower(__short2half_ru, int16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__short2half_rus_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__short2half_rus_nbst_caller,
            signature(_type___half, CPointer(int16)),
            ptrs,
        )


_lower__ZL15__short2half_rus_nbst(shim_stream, shim_obj)


def __half2uint_rn():
    pass


def _lower__ZL14__half2uint_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__half2uint_rn6__half_nbst(unsigned int &retval , __half* h) {
        retval = __half2uint_rn(*h);
        return 0;
    }
        """

    _ZL14__half2uint_rn6__half_nbst = declare_device(
        "_ZL14__half2uint_rn6__half_nbst", uint32(CPointer(_type___half))
    )

    def _ZL14__half2uint_rn6__half_nbst_caller(arg_0):
        return _ZL14__half2uint_rn6__half_nbst(arg_0)

    @lower(__half2uint_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__half2uint_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__half2uint_rn6__half_nbst_caller,
            signature(uint32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL14__half2uint_rn6__half_nbst(shim_stream, shim_obj)


def __half2uint_rd():
    pass


def _lower__ZL14__half2uint_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__half2uint_rd6__half_nbst(unsigned int &retval , __half* h) {
        retval = __half2uint_rd(*h);
        return 0;
    }
        """

    _ZL14__half2uint_rd6__half_nbst = declare_device(
        "_ZL14__half2uint_rd6__half_nbst", uint32(CPointer(_type___half))
    )

    def _ZL14__half2uint_rd6__half_nbst_caller(arg_0):
        return _ZL14__half2uint_rd6__half_nbst(arg_0)

    @lower(__half2uint_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__half2uint_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__half2uint_rd6__half_nbst_caller,
            signature(uint32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL14__half2uint_rd6__half_nbst(shim_stream, shim_obj)


def __half2uint_ru():
    pass


def _lower__ZL14__half2uint_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__half2uint_ru6__half_nbst(unsigned int &retval , __half* h) {
        retval = __half2uint_ru(*h);
        return 0;
    }
        """

    _ZL14__half2uint_ru6__half_nbst = declare_device(
        "_ZL14__half2uint_ru6__half_nbst", uint32(CPointer(_type___half))
    )

    def _ZL14__half2uint_ru6__half_nbst_caller(arg_0):
        return _ZL14__half2uint_ru6__half_nbst(arg_0)

    @lower(__half2uint_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__half2uint_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__half2uint_ru6__half_nbst_caller,
            signature(uint32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL14__half2uint_ru6__half_nbst(shim_stream, shim_obj)


def __uint2half_rn():
    pass


def _lower__ZL14__uint2half_rnj_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__uint2half_rnj_nbst(__half &retval , unsigned int* i) {
        retval = __uint2half_rn(*i);
        return 0;
    }
        """

    _ZL14__uint2half_rnj_nbst = declare_device(
        "_ZL14__uint2half_rnj_nbst", _type___half(CPointer(uint32))
    )

    def _ZL14__uint2half_rnj_nbst_caller(arg_0):
        return _ZL14__uint2half_rnj_nbst(arg_0)

    @lower(__uint2half_rn, uint32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL14__uint2half_rnj_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__uint2half_rnj_nbst_caller,
            signature(_type___half, CPointer(uint32)),
            ptrs,
        )


_lower__ZL14__uint2half_rnj_nbst(shim_stream, shim_obj)


def __uint2half_rz():
    pass


def _lower__ZL14__uint2half_rzj_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__uint2half_rzj_nbst(__half &retval , unsigned int* i) {
        retval = __uint2half_rz(*i);
        return 0;
    }
        """

    _ZL14__uint2half_rzj_nbst = declare_device(
        "_ZL14__uint2half_rzj_nbst", _type___half(CPointer(uint32))
    )

    def _ZL14__uint2half_rzj_nbst_caller(arg_0):
        return _ZL14__uint2half_rzj_nbst(arg_0)

    @lower(__uint2half_rz, uint32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL14__uint2half_rzj_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__uint2half_rzj_nbst_caller,
            signature(_type___half, CPointer(uint32)),
            ptrs,
        )


_lower__ZL14__uint2half_rzj_nbst(shim_stream, shim_obj)


def __uint2half_rd():
    pass


def _lower__ZL14__uint2half_rdj_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__uint2half_rdj_nbst(__half &retval , unsigned int* i) {
        retval = __uint2half_rd(*i);
        return 0;
    }
        """

    _ZL14__uint2half_rdj_nbst = declare_device(
        "_ZL14__uint2half_rdj_nbst", _type___half(CPointer(uint32))
    )

    def _ZL14__uint2half_rdj_nbst_caller(arg_0):
        return _ZL14__uint2half_rdj_nbst(arg_0)

    @lower(__uint2half_rd, uint32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL14__uint2half_rdj_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__uint2half_rdj_nbst_caller,
            signature(_type___half, CPointer(uint32)),
            ptrs,
        )


_lower__ZL14__uint2half_rdj_nbst(shim_stream, shim_obj)


def __uint2half_ru():
    pass


def _lower__ZL14__uint2half_ruj_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__uint2half_ruj_nbst(__half &retval , unsigned int* i) {
        retval = __uint2half_ru(*i);
        return 0;
    }
        """

    _ZL14__uint2half_ruj_nbst = declare_device(
        "_ZL14__uint2half_ruj_nbst", _type___half(CPointer(uint32))
    )

    def _ZL14__uint2half_ruj_nbst_caller(arg_0):
        return _ZL14__uint2half_ruj_nbst(arg_0)

    @lower(__uint2half_ru, uint32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL14__uint2half_ruj_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__uint2half_ruj_nbst_caller,
            signature(_type___half, CPointer(uint32)),
            ptrs,
        )


_lower__ZL14__uint2half_ruj_nbst(shim_stream, shim_obj)


def __half2ushort_rn():
    pass


def _lower__ZL16__half2ushort_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__half2ushort_rn6__half_nbst(unsigned short &retval , __half* h) {
        retval = __half2ushort_rn(*h);
        return 0;
    }
        """

    _ZL16__half2ushort_rn6__half_nbst = declare_device(
        "_ZL16__half2ushort_rn6__half_nbst", uint16(CPointer(_type___half))
    )

    def _ZL16__half2ushort_rn6__half_nbst_caller(arg_0):
        return _ZL16__half2ushort_rn6__half_nbst(arg_0)

    @lower(__half2ushort_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__half2ushort_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__half2ushort_rn6__half_nbst_caller,
            signature(uint16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL16__half2ushort_rn6__half_nbst(shim_stream, shim_obj)


def __half2ushort_rd():
    pass


def _lower__ZL16__half2ushort_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__half2ushort_rd6__half_nbst(unsigned short &retval , __half* h) {
        retval = __half2ushort_rd(*h);
        return 0;
    }
        """

    _ZL16__half2ushort_rd6__half_nbst = declare_device(
        "_ZL16__half2ushort_rd6__half_nbst", uint16(CPointer(_type___half))
    )

    def _ZL16__half2ushort_rd6__half_nbst_caller(arg_0):
        return _ZL16__half2ushort_rd6__half_nbst(arg_0)

    @lower(__half2ushort_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__half2ushort_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__half2ushort_rd6__half_nbst_caller,
            signature(uint16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL16__half2ushort_rd6__half_nbst(shim_stream, shim_obj)


def __half2ushort_ru():
    pass


def _lower__ZL16__half2ushort_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__half2ushort_ru6__half_nbst(unsigned short &retval , __half* h) {
        retval = __half2ushort_ru(*h);
        return 0;
    }
        """

    _ZL16__half2ushort_ru6__half_nbst = declare_device(
        "_ZL16__half2ushort_ru6__half_nbst", uint16(CPointer(_type___half))
    )

    def _ZL16__half2ushort_ru6__half_nbst_caller(arg_0):
        return _ZL16__half2ushort_ru6__half_nbst(arg_0)

    @lower(__half2ushort_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__half2ushort_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__half2ushort_ru6__half_nbst_caller,
            signature(uint16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL16__half2ushort_ru6__half_nbst(shim_stream, shim_obj)


def __ushort2half_rn():
    pass


def _lower__ZL16__ushort2half_rnt_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__ushort2half_rnt_nbst(__half &retval , unsigned short* i) {
        retval = __ushort2half_rn(*i);
        return 0;
    }
        """

    _ZL16__ushort2half_rnt_nbst = declare_device(
        "_ZL16__ushort2half_rnt_nbst", _type___half(CPointer(uint16))
    )

    def _ZL16__ushort2half_rnt_nbst_caller(arg_0):
        return _ZL16__ushort2half_rnt_nbst(arg_0)

    @lower(__ushort2half_rn, uint16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL16__ushort2half_rnt_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__ushort2half_rnt_nbst_caller,
            signature(_type___half, CPointer(uint16)),
            ptrs,
        )


_lower__ZL16__ushort2half_rnt_nbst(shim_stream, shim_obj)


def __ushort2half_rz():
    pass


def _lower__ZL16__ushort2half_rzt_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__ushort2half_rzt_nbst(__half &retval , unsigned short* i) {
        retval = __ushort2half_rz(*i);
        return 0;
    }
        """

    _ZL16__ushort2half_rzt_nbst = declare_device(
        "_ZL16__ushort2half_rzt_nbst", _type___half(CPointer(uint16))
    )

    def _ZL16__ushort2half_rzt_nbst_caller(arg_0):
        return _ZL16__ushort2half_rzt_nbst(arg_0)

    @lower(__ushort2half_rz, uint16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL16__ushort2half_rzt_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__ushort2half_rzt_nbst_caller,
            signature(_type___half, CPointer(uint16)),
            ptrs,
        )


_lower__ZL16__ushort2half_rzt_nbst(shim_stream, shim_obj)


def __ushort2half_rd():
    pass


def _lower__ZL16__ushort2half_rdt_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__ushort2half_rdt_nbst(__half &retval , unsigned short* i) {
        retval = __ushort2half_rd(*i);
        return 0;
    }
        """

    _ZL16__ushort2half_rdt_nbst = declare_device(
        "_ZL16__ushort2half_rdt_nbst", _type___half(CPointer(uint16))
    )

    def _ZL16__ushort2half_rdt_nbst_caller(arg_0):
        return _ZL16__ushort2half_rdt_nbst(arg_0)

    @lower(__ushort2half_rd, uint16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL16__ushort2half_rdt_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__ushort2half_rdt_nbst_caller,
            signature(_type___half, CPointer(uint16)),
            ptrs,
        )


_lower__ZL16__ushort2half_rdt_nbst(shim_stream, shim_obj)


def __ushort2half_ru():
    pass


def _lower__ZL16__ushort2half_rut_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__ushort2half_rut_nbst(__half &retval , unsigned short* i) {
        retval = __ushort2half_ru(*i);
        return 0;
    }
        """

    _ZL16__ushort2half_rut_nbst = declare_device(
        "_ZL16__ushort2half_rut_nbst", _type___half(CPointer(uint16))
    )

    def _ZL16__ushort2half_rut_nbst_caller(arg_0):
        return _ZL16__ushort2half_rut_nbst(arg_0)

    @lower(__ushort2half_ru, uint16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL16__ushort2half_rut_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__ushort2half_rut_nbst_caller,
            signature(_type___half, CPointer(uint16)),
            ptrs,
        )


_lower__ZL16__ushort2half_rut_nbst(shim_stream, shim_obj)


def __half2ull_rn():
    pass


def _lower__ZL13__half2ull_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2ull_rn6__half_nbst(unsigned long long &retval , __half* h) {
        retval = __half2ull_rn(*h);
        return 0;
    }
        """

    _ZL13__half2ull_rn6__half_nbst = declare_device(
        "_ZL13__half2ull_rn6__half_nbst", uint64(CPointer(_type___half))
    )

    def _ZL13__half2ull_rn6__half_nbst_caller(arg_0):
        return _ZL13__half2ull_rn6__half_nbst(arg_0)

    @lower(__half2ull_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2ull_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2ull_rn6__half_nbst_caller,
            signature(uint64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2ull_rn6__half_nbst(shim_stream, shim_obj)


def __half2ull_rd():
    pass


def _lower__ZL13__half2ull_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2ull_rd6__half_nbst(unsigned long long &retval , __half* h) {
        retval = __half2ull_rd(*h);
        return 0;
    }
        """

    _ZL13__half2ull_rd6__half_nbst = declare_device(
        "_ZL13__half2ull_rd6__half_nbst", uint64(CPointer(_type___half))
    )

    def _ZL13__half2ull_rd6__half_nbst_caller(arg_0):
        return _ZL13__half2ull_rd6__half_nbst(arg_0)

    @lower(__half2ull_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2ull_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2ull_rd6__half_nbst_caller,
            signature(uint64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2ull_rd6__half_nbst(shim_stream, shim_obj)


def __half2ull_ru():
    pass


def _lower__ZL13__half2ull_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__half2ull_ru6__half_nbst(unsigned long long &retval , __half* h) {
        retval = __half2ull_ru(*h);
        return 0;
    }
        """

    _ZL13__half2ull_ru6__half_nbst = declare_device(
        "_ZL13__half2ull_ru6__half_nbst", uint64(CPointer(_type___half))
    )

    def _ZL13__half2ull_ru6__half_nbst_caller(arg_0):
        return _ZL13__half2ull_ru6__half_nbst(arg_0)

    @lower(__half2ull_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL13__half2ull_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__half2ull_ru6__half_nbst_caller,
            signature(uint64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL13__half2ull_ru6__half_nbst(shim_stream, shim_obj)


def __ull2half_rn():
    pass


def _lower__ZL13__ull2half_rny_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__ull2half_rny_nbst(__half &retval , unsigned long long* i) {
        retval = __ull2half_rn(*i);
        return 0;
    }
        """

    _ZL13__ull2half_rny_nbst = declare_device(
        "_ZL13__ull2half_rny_nbst", _type___half(CPointer(uint64))
    )

    def _ZL13__ull2half_rny_nbst_caller(arg_0):
        return _ZL13__ull2half_rny_nbst(arg_0)

    @lower(__ull2half_rn, uint64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__ull2half_rny_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__ull2half_rny_nbst_caller,
            signature(_type___half, CPointer(uint64)),
            ptrs,
        )


_lower__ZL13__ull2half_rny_nbst(shim_stream, shim_obj)


def __ull2half_rz():
    pass


def _lower__ZL13__ull2half_rzy_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__ull2half_rzy_nbst(__half &retval , unsigned long long* i) {
        retval = __ull2half_rz(*i);
        return 0;
    }
        """

    _ZL13__ull2half_rzy_nbst = declare_device(
        "_ZL13__ull2half_rzy_nbst", _type___half(CPointer(uint64))
    )

    def _ZL13__ull2half_rzy_nbst_caller(arg_0):
        return _ZL13__ull2half_rzy_nbst(arg_0)

    @lower(__ull2half_rz, uint64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__ull2half_rzy_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__ull2half_rzy_nbst_caller,
            signature(_type___half, CPointer(uint64)),
            ptrs,
        )


_lower__ZL13__ull2half_rzy_nbst(shim_stream, shim_obj)


def __ull2half_rd():
    pass


def _lower__ZL13__ull2half_rdy_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__ull2half_rdy_nbst(__half &retval , unsigned long long* i) {
        retval = __ull2half_rd(*i);
        return 0;
    }
        """

    _ZL13__ull2half_rdy_nbst = declare_device(
        "_ZL13__ull2half_rdy_nbst", _type___half(CPointer(uint64))
    )

    def _ZL13__ull2half_rdy_nbst_caller(arg_0):
        return _ZL13__ull2half_rdy_nbst(arg_0)

    @lower(__ull2half_rd, uint64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__ull2half_rdy_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__ull2half_rdy_nbst_caller,
            signature(_type___half, CPointer(uint64)),
            ptrs,
        )


_lower__ZL13__ull2half_rdy_nbst(shim_stream, shim_obj)


def __ull2half_ru():
    pass


def _lower__ZL13__ull2half_ruy_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL13__ull2half_ruy_nbst(__half &retval , unsigned long long* i) {
        retval = __ull2half_ru(*i);
        return 0;
    }
        """

    _ZL13__ull2half_ruy_nbst = declare_device(
        "_ZL13__ull2half_ruy_nbst", _type___half(CPointer(uint64))
    )

    def _ZL13__ull2half_ruy_nbst_caller(arg_0):
        return _ZL13__ull2half_ruy_nbst(arg_0)

    @lower(__ull2half_ru, uint64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL13__ull2half_ruy_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL13__ull2half_ruy_nbst_caller,
            signature(_type___half, CPointer(uint64)),
            ptrs,
        )


_lower__ZL13__ull2half_ruy_nbst(shim_stream, shim_obj)


def __half2ll_rn():
    pass


def _lower__ZL12__half2ll_rn6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__half2ll_rn6__half_nbst(long long &retval , __half* h) {
        retval = __half2ll_rn(*h);
        return 0;
    }
        """

    _ZL12__half2ll_rn6__half_nbst = declare_device(
        "_ZL12__half2ll_rn6__half_nbst", int64(CPointer(_type___half))
    )

    def _ZL12__half2ll_rn6__half_nbst_caller(arg_0):
        return _ZL12__half2ll_rn6__half_nbst(arg_0)

    @lower(__half2ll_rn, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12__half2ll_rn6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__half2ll_rn6__half_nbst_caller,
            signature(int64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12__half2ll_rn6__half_nbst(shim_stream, shim_obj)


def __half2ll_rd():
    pass


def _lower__ZL12__half2ll_rd6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__half2ll_rd6__half_nbst(long long &retval , __half* h) {
        retval = __half2ll_rd(*h);
        return 0;
    }
        """

    _ZL12__half2ll_rd6__half_nbst = declare_device(
        "_ZL12__half2ll_rd6__half_nbst", int64(CPointer(_type___half))
    )

    def _ZL12__half2ll_rd6__half_nbst_caller(arg_0):
        return _ZL12__half2ll_rd6__half_nbst(arg_0)

    @lower(__half2ll_rd, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12__half2ll_rd6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__half2ll_rd6__half_nbst_caller,
            signature(int64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12__half2ll_rd6__half_nbst(shim_stream, shim_obj)


def __half2ll_ru():
    pass


def _lower__ZL12__half2ll_ru6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__half2ll_ru6__half_nbst(long long &retval , __half* h) {
        retval = __half2ll_ru(*h);
        return 0;
    }
        """

    _ZL12__half2ll_ru6__half_nbst = declare_device(
        "_ZL12__half2ll_ru6__half_nbst", int64(CPointer(_type___half))
    )

    def _ZL12__half2ll_ru6__half_nbst_caller(arg_0):
        return _ZL12__half2ll_ru6__half_nbst(arg_0)

    @lower(__half2ll_ru, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12__half2ll_ru6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__half2ll_ru6__half_nbst_caller,
            signature(int64, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12__half2ll_ru6__half_nbst(shim_stream, shim_obj)


def __ll2half_rn():
    pass


def _lower__ZL12__ll2half_rnx_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__ll2half_rnx_nbst(__half &retval , long long* i) {
        retval = __ll2half_rn(*i);
        return 0;
    }
        """

    _ZL12__ll2half_rnx_nbst = declare_device(
        "_ZL12__ll2half_rnx_nbst", _type___half(CPointer(int64))
    )

    def _ZL12__ll2half_rnx_nbst_caller(arg_0):
        return _ZL12__ll2half_rnx_nbst(arg_0)

    @lower(__ll2half_rn, int64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL12__ll2half_rnx_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__ll2half_rnx_nbst_caller,
            signature(_type___half, CPointer(int64)),
            ptrs,
        )


_lower__ZL12__ll2half_rnx_nbst(shim_stream, shim_obj)


def __ll2half_rz():
    pass


def _lower__ZL12__ll2half_rzx_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__ll2half_rzx_nbst(__half &retval , long long* i) {
        retval = __ll2half_rz(*i);
        return 0;
    }
        """

    _ZL12__ll2half_rzx_nbst = declare_device(
        "_ZL12__ll2half_rzx_nbst", _type___half(CPointer(int64))
    )

    def _ZL12__ll2half_rzx_nbst_caller(arg_0):
        return _ZL12__ll2half_rzx_nbst(arg_0)

    @lower(__ll2half_rz, int64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL12__ll2half_rzx_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__ll2half_rzx_nbst_caller,
            signature(_type___half, CPointer(int64)),
            ptrs,
        )


_lower__ZL12__ll2half_rzx_nbst(shim_stream, shim_obj)


def __ll2half_rd():
    pass


def _lower__ZL12__ll2half_rdx_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__ll2half_rdx_nbst(__half &retval , long long* i) {
        retval = __ll2half_rd(*i);
        return 0;
    }
        """

    _ZL12__ll2half_rdx_nbst = declare_device(
        "_ZL12__ll2half_rdx_nbst", _type___half(CPointer(int64))
    )

    def _ZL12__ll2half_rdx_nbst_caller(arg_0):
        return _ZL12__ll2half_rdx_nbst(arg_0)

    @lower(__ll2half_rd, int64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL12__ll2half_rdx_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__ll2half_rdx_nbst_caller,
            signature(_type___half, CPointer(int64)),
            ptrs,
        )


_lower__ZL12__ll2half_rdx_nbst(shim_stream, shim_obj)


def __ll2half_ru():
    pass


def _lower__ZL12__ll2half_rux_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12__ll2half_rux_nbst(__half &retval , long long* i) {
        retval = __ll2half_ru(*i);
        return 0;
    }
        """

    _ZL12__ll2half_rux_nbst = declare_device(
        "_ZL12__ll2half_rux_nbst", _type___half(CPointer(int64))
    )

    def _ZL12__ll2half_rux_nbst_caller(arg_0):
        return _ZL12__ll2half_rux_nbst(arg_0)

    @lower(__ll2half_ru, int64)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL12__ll2half_rux_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12__ll2half_rux_nbst_caller,
            signature(_type___half, CPointer(int64)),
            ptrs,
        )


_lower__ZL12__ll2half_rux_nbst(shim_stream, shim_obj)


def htrunc():
    pass


def _lower__ZL6htrunc6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6htrunc6__half_nbst(__half &retval , __half* h) {
        retval = htrunc(*h);
        return 0;
    }
        """

    _ZL6htrunc6__half_nbst = declare_device(
        "_ZL6htrunc6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6htrunc6__half_nbst_caller(arg_0):
        return _ZL6htrunc6__half_nbst(arg_0)

    @lower(htrunc, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6htrunc6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6htrunc6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6htrunc6__half_nbst(shim_stream, shim_obj)


def hceil():
    pass


def _lower__ZL5hceil6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5hceil6__half_nbst(__half &retval , __half* h) {
        retval = hceil(*h);
        return 0;
    }
        """

    _ZL5hceil6__half_nbst = declare_device(
        "_ZL5hceil6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5hceil6__half_nbst_caller(arg_0):
        return _ZL5hceil6__half_nbst(arg_0)

    @lower(hceil, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5hceil6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5hceil6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5hceil6__half_nbst(shim_stream, shim_obj)


def hfloor():
    pass


def _lower__ZL6hfloor6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6hfloor6__half_nbst(__half &retval , __half* h) {
        retval = hfloor(*h);
        return 0;
    }
        """

    _ZL6hfloor6__half_nbst = declare_device(
        "_ZL6hfloor6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6hfloor6__half_nbst_caller(arg_0):
        return _ZL6hfloor6__half_nbst(arg_0)

    @lower(hfloor, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6hfloor6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6hfloor6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6hfloor6__half_nbst(shim_stream, shim_obj)


def hrint():
    pass


def _lower__ZL5hrint6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5hrint6__half_nbst(__half &retval , __half* h) {
        retval = hrint(*h);
        return 0;
    }
        """

    _ZL5hrint6__half_nbst = declare_device(
        "_ZL5hrint6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5hrint6__half_nbst_caller(arg_0):
        return _ZL5hrint6__half_nbst(arg_0)

    @lower(hrint, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5hrint6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5hrint6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5hrint6__half_nbst(shim_stream, shim_obj)


def __hisinf():
    pass


def _lower__ZL8__hisinf6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL8__hisinf6__half_nbst(int &retval , __half* a) {
        retval = __hisinf(*a);
        return 0;
    }
        """

    _ZL8__hisinf6__half_nbst = declare_device(
        "_ZL8__hisinf6__half_nbst", int32(CPointer(_type___half))
    )

    def _ZL8__hisinf6__half_nbst_caller(arg_0):
        return _ZL8__hisinf6__half_nbst(arg_0)

    @lower(__hisinf, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL8__hisinf6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL8__hisinf6__half_nbst_caller,
            signature(int32, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL8__hisinf6__half_nbst(shim_stream, shim_obj)


def __half_as_short():
    pass


def _lower__ZL15__half_as_short6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__half_as_short6__half_nbst(short &retval , __half* h) {
        retval = __half_as_short(*h);
        return 0;
    }
        """

    _ZL15__half_as_short6__half_nbst = declare_device(
        "_ZL15__half_as_short6__half_nbst", int16(CPointer(_type___half))
    )

    def _ZL15__half_as_short6__half_nbst_caller(arg_0):
        return _ZL15__half_as_short6__half_nbst(arg_0)

    @lower(__half_as_short, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__half_as_short6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__half_as_short6__half_nbst_caller,
            signature(int16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL15__half_as_short6__half_nbst(shim_stream, shim_obj)


def __half_as_ushort():
    pass


def _lower__ZL16__half_as_ushort6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__half_as_ushort6__half_nbst(unsigned short &retval , __half* h) {
        retval = __half_as_ushort(*h);
        return 0;
    }
        """

    _ZL16__half_as_ushort6__half_nbst = declare_device(
        "_ZL16__half_as_ushort6__half_nbst", uint16(CPointer(_type___half))
    )

    def _ZL16__half_as_ushort6__half_nbst_caller(arg_0):
        return _ZL16__half_as_ushort6__half_nbst(arg_0)

    @lower(__half_as_ushort, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__half_as_ushort6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__half_as_ushort6__half_nbst_caller,
            signature(uint16, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL16__half_as_ushort6__half_nbst(shim_stream, shim_obj)


def __short_as_half():
    pass


def _lower__ZL15__short_as_halfs_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__short_as_halfs_nbst(__half &retval , short* i) {
        retval = __short_as_half(*i);
        return 0;
    }
        """

    _ZL15__short_as_halfs_nbst = declare_device(
        "_ZL15__short_as_halfs_nbst", _type___half(CPointer(int16))
    )

    def _ZL15__short_as_halfs_nbst_caller(arg_0):
        return _ZL15__short_as_halfs_nbst(arg_0)

    @lower(__short_as_half, int16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL15__short_as_halfs_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__short_as_halfs_nbst_caller,
            signature(_type___half, CPointer(int16)),
            ptrs,
        )


_lower__ZL15__short_as_halfs_nbst(shim_stream, shim_obj)


def __ushort_as_half():
    pass


def _lower__ZL16__ushort_as_halft_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__ushort_as_halft_nbst(__half &retval , unsigned short* i) {
        retval = __ushort_as_half(*i);
        return 0;
    }
        """

    _ZL16__ushort_as_halft_nbst = declare_device(
        "_ZL16__ushort_as_halft_nbst", _type___half(CPointer(uint16))
    )

    def _ZL16__ushort_as_halft_nbst_caller(arg_0):
        return _ZL16__ushort_as_halft_nbst(arg_0)

    @lower(__ushort_as_half, uint16)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL16__ushort_as_halft_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__ushort_as_halft_nbst_caller,
            signature(_type___half, CPointer(uint16)),
            ptrs,
        )


_lower__ZL16__ushort_as_halft_nbst(shim_stream, shim_obj)


def __hmax():
    pass


def _lower__ZL6__hmax6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hmax6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmax(*a, *b);
        return 0;
    }
        """

    _ZL6__hmax6__halfS__nbst = declare_device(
        "_ZL6__hmax6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hmax6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hmax6__halfS__nbst(arg_0, arg_1)

    @lower(__hmax, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hmax6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hmax6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hmax6__halfS__nbst(shim_stream, shim_obj)


def __hmin():
    pass


def _lower__ZL6__hmin6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hmin6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmin(*a, *b);
        return 0;
    }
        """

    _ZL6__hmin6__halfS__nbst = declare_device(
        "_ZL6__hmin6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hmin6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hmin6__halfS__nbst(arg_0, arg_1)

    @lower(__hmin, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hmin6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hmin6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hmin6__halfS__nbst(shim_stream, shim_obj)


def __shfl_sync():
    pass


def _lower__ZL11__shfl_syncj6__halfii_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL11__shfl_syncj6__halfii_nbst(__half &retval , unsigned int* mask, __half* var, int* srcLane, int* width) {
        retval = __shfl_sync(*mask, *var, *srcLane, *width);
        return 0;
    }
        """

    _ZL11__shfl_syncj6__halfii_nbst = declare_device(
        "_ZL11__shfl_syncj6__halfii_nbst",
        _type___half(
            CPointer(uint32),
            CPointer(_type___half),
            CPointer(int32),
            CPointer(int32),
        ),
    )

    def _ZL11__shfl_syncj6__halfii_nbst_caller(arg_0, arg_1, arg_2, arg_3):
        return _ZL11__shfl_syncj6__halfii_nbst(arg_0, arg_1, arg_2, arg_3)

    @lower(__shfl_sync, uint32, _type___half, int32, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL11__shfl_syncj6__halfii_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL11__shfl_syncj6__halfii_nbst_caller,
            signature(
                _type___half,
                CPointer(uint32),
                CPointer(_type___half),
                CPointer(int32),
                CPointer(int32),
            ),
            ptrs,
        )


_lower__ZL11__shfl_syncj6__halfii_nbst(shim_stream, shim_obj)


def __shfl_up_sync():
    pass


def _lower__ZL14__shfl_up_syncj6__halfji_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL14__shfl_up_syncj6__halfji_nbst(__half &retval , unsigned int* mask, __half* var, unsigned int* delta, int* width) {
        retval = __shfl_up_sync(*mask, *var, *delta, *width);
        return 0;
    }
        """

    _ZL14__shfl_up_syncj6__halfji_nbst = declare_device(
        "_ZL14__shfl_up_syncj6__halfji_nbst",
        _type___half(
            CPointer(uint32),
            CPointer(_type___half),
            CPointer(uint32),
            CPointer(int32),
        ),
    )

    def _ZL14__shfl_up_syncj6__halfji_nbst_caller(arg_0, arg_1, arg_2, arg_3):
        return _ZL14__shfl_up_syncj6__halfji_nbst(arg_0, arg_1, arg_2, arg_3)

    @lower(__shfl_up_sync, uint32, _type___half, uint32, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL14__shfl_up_syncj6__halfji_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL14__shfl_up_syncj6__halfji_nbst_caller,
            signature(
                _type___half,
                CPointer(uint32),
                CPointer(_type___half),
                CPointer(uint32),
                CPointer(int32),
            ),
            ptrs,
        )


_lower__ZL14__shfl_up_syncj6__halfji_nbst(shim_stream, shim_obj)


def __shfl_down_sync():
    pass


def _lower__ZL16__shfl_down_syncj6__halfji_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL16__shfl_down_syncj6__halfji_nbst(__half &retval , unsigned int* mask, __half* var, unsigned int* delta, int* width) {
        retval = __shfl_down_sync(*mask, *var, *delta, *width);
        return 0;
    }
        """

    _ZL16__shfl_down_syncj6__halfji_nbst = declare_device(
        "_ZL16__shfl_down_syncj6__halfji_nbst",
        _type___half(
            CPointer(uint32),
            CPointer(_type___half),
            CPointer(uint32),
            CPointer(int32),
        ),
    )

    def _ZL16__shfl_down_syncj6__halfji_nbst_caller(arg_0, arg_1, arg_2, arg_3):
        return _ZL16__shfl_down_syncj6__halfji_nbst(arg_0, arg_1, arg_2, arg_3)

    @lower(__shfl_down_sync, uint32, _type___half, uint32, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL16__shfl_down_syncj6__halfji_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL16__shfl_down_syncj6__halfji_nbst_caller,
            signature(
                _type___half,
                CPointer(uint32),
                CPointer(_type___half),
                CPointer(uint32),
                CPointer(int32),
            ),
            ptrs,
        )


_lower__ZL16__shfl_down_syncj6__halfji_nbst(shim_stream, shim_obj)


def __shfl_xor_sync():
    pass


def _lower__ZL15__shfl_xor_syncj6__halfii_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL15__shfl_xor_syncj6__halfii_nbst(__half &retval , unsigned int* mask, __half* var, int* laneMask, int* width) {
        retval = __shfl_xor_sync(*mask, *var, *laneMask, *width);
        return 0;
    }
        """

    _ZL15__shfl_xor_syncj6__halfii_nbst = declare_device(
        "_ZL15__shfl_xor_syncj6__halfii_nbst",
        _type___half(
            CPointer(uint32),
            CPointer(_type___half),
            CPointer(int32),
            CPointer(int32),
        ),
    )

    def _ZL15__shfl_xor_syncj6__halfii_nbst_caller(arg_0, arg_1, arg_2, arg_3):
        return _ZL15__shfl_xor_syncj6__halfii_nbst(arg_0, arg_1, arg_2, arg_3)

    @lower(__shfl_xor_sync, uint32, _type___half, int32, int32)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL15__shfl_xor_syncj6__halfii_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL15__shfl_xor_syncj6__halfii_nbst_caller,
            signature(
                _type___half,
                CPointer(uint32),
                CPointer(_type___half),
                CPointer(int32),
                CPointer(int32),
            ),
            ptrs,
        )


_lower__ZL15__shfl_xor_syncj6__halfii_nbst(shim_stream, shim_obj)


def __ldg():
    pass


def _lower__ZL5__ldgPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__ldgPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldg(*ptr);
        return 0;
    }
        """

    _ZL5__ldgPK6__half_nbst = declare_device(
        "_ZL5__ldgPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL5__ldgPK6__half_nbst_caller(arg_0):
        return _ZL5__ldgPK6__half_nbst(arg_0)

    @lower(__ldg, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__ldgPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__ldgPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL5__ldgPK6__half_nbst(shim_stream, shim_obj)


def __ldcg():
    pass


def _lower__ZL6__ldcgPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__ldcgPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldcg(*ptr);
        return 0;
    }
        """

    _ZL6__ldcgPK6__half_nbst = declare_device(
        "_ZL6__ldcgPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL6__ldcgPK6__half_nbst_caller(arg_0):
        return _ZL6__ldcgPK6__half_nbst(arg_0)

    @lower(__ldcg, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__ldcgPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__ldcgPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL6__ldcgPK6__half_nbst(shim_stream, shim_obj)


def __ldca():
    pass


def _lower__ZL6__ldcaPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__ldcaPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldca(*ptr);
        return 0;
    }
        """

    _ZL6__ldcaPK6__half_nbst = declare_device(
        "_ZL6__ldcaPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL6__ldcaPK6__half_nbst_caller(arg_0):
        return _ZL6__ldcaPK6__half_nbst(arg_0)

    @lower(__ldca, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__ldcaPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__ldcaPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL6__ldcaPK6__half_nbst(shim_stream, shim_obj)


def __ldcs():
    pass


def _lower__ZL6__ldcsPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__ldcsPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldcs(*ptr);
        return 0;
    }
        """

    _ZL6__ldcsPK6__half_nbst = declare_device(
        "_ZL6__ldcsPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL6__ldcsPK6__half_nbst_caller(arg_0):
        return _ZL6__ldcsPK6__half_nbst(arg_0)

    @lower(__ldcs, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__ldcsPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__ldcsPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL6__ldcsPK6__half_nbst(shim_stream, shim_obj)


def __ldlu():
    pass


def _lower__ZL6__ldluPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__ldluPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldlu(*ptr);
        return 0;
    }
        """

    _ZL6__ldluPK6__half_nbst = declare_device(
        "_ZL6__ldluPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL6__ldluPK6__half_nbst_caller(arg_0):
        return _ZL6__ldluPK6__half_nbst(arg_0)

    @lower(__ldlu, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__ldluPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__ldluPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL6__ldluPK6__half_nbst(shim_stream, shim_obj)


def __ldcv():
    pass


def _lower__ZL6__ldcvPK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__ldcvPK6__half_nbst(__half &retval , __half ** ptr) {
        retval = __ldcv(*ptr);
        return 0;
    }
        """

    _ZL6__ldcvPK6__half_nbst = declare_device(
        "_ZL6__ldcvPK6__half_nbst",
        _type___half(CPointer(CPointer(_type___half))),
    )

    def _ZL6__ldcvPK6__half_nbst_caller(arg_0):
        return _ZL6__ldcvPK6__half_nbst(arg_0)

    @lower(__ldcv, CPointer(_type___half))
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__ldcvPK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__ldcvPK6__half_nbst_caller,
            signature(_type___half, CPointer(CPointer(_type___half))),
            ptrs,
        )


_lower__ZL6__ldcvPK6__half_nbst(shim_stream, shim_obj)


def __stwb():
    pass


def _lower__ZL6__stwbP6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__stwbP6__halfS__nbst(int &retval , __half ** ptr, __half* value) {
        __stwb(*ptr, *value);
        return 0;
    }
        """

    _ZL6__stwbP6__halfS__nbst = declare_device(
        "_ZL6__stwbP6__halfS__nbst",
        void(CPointer(CPointer(_type___half)), CPointer(_type___half)),
    )

    def _ZL6__stwbP6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__stwbP6__halfS__nbst(arg_0, arg_1)

    @lower(__stwb, CPointer(_type___half), _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__stwbP6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__stwbP6__halfS__nbst_caller,
            signature(
                void, CPointer(CPointer(_type___half)), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__stwbP6__halfS__nbst(shim_stream, shim_obj)


def __stcg():
    pass


def _lower__ZL6__stcgP6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__stcgP6__halfS__nbst(int &retval , __half ** ptr, __half* value) {
        __stcg(*ptr, *value);
        return 0;
    }
        """

    _ZL6__stcgP6__halfS__nbst = declare_device(
        "_ZL6__stcgP6__halfS__nbst",
        void(CPointer(CPointer(_type___half)), CPointer(_type___half)),
    )

    def _ZL6__stcgP6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__stcgP6__halfS__nbst(arg_0, arg_1)

    @lower(__stcg, CPointer(_type___half), _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__stcgP6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__stcgP6__halfS__nbst_caller,
            signature(
                void, CPointer(CPointer(_type___half)), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__stcgP6__halfS__nbst(shim_stream, shim_obj)


def __stcs():
    pass


def _lower__ZL6__stcsP6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__stcsP6__halfS__nbst(int &retval , __half ** ptr, __half* value) {
        __stcs(*ptr, *value);
        return 0;
    }
        """

    _ZL6__stcsP6__halfS__nbst = declare_device(
        "_ZL6__stcsP6__halfS__nbst",
        void(CPointer(CPointer(_type___half)), CPointer(_type___half)),
    )

    def _ZL6__stcsP6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__stcsP6__halfS__nbst(arg_0, arg_1)

    @lower(__stcs, CPointer(_type___half), _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__stcsP6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__stcsP6__halfS__nbst_caller,
            signature(
                void, CPointer(CPointer(_type___half)), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__stcsP6__halfS__nbst(shim_stream, shim_obj)


def __stwt():
    pass


def _lower__ZL6__stwtP6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__stwtP6__halfS__nbst(int &retval , __half ** ptr, __half* value) {
        __stwt(*ptr, *value);
        return 0;
    }
        """

    _ZL6__stwtP6__halfS__nbst = declare_device(
        "_ZL6__stwtP6__halfS__nbst",
        void(CPointer(CPointer(_type___half)), CPointer(_type___half)),
    )

    def _ZL6__stwtP6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__stwtP6__halfS__nbst(arg_0, arg_1)

    @lower(__stwt, CPointer(_type___half), _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__stwtP6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__stwtP6__halfS__nbst_caller,
            signature(
                void, CPointer(CPointer(_type___half)), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__stwtP6__halfS__nbst(shim_stream, shim_obj)


def __habs():
    pass


def _lower__ZL6__habs6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__habs6__half_nbst(__half &retval , __half* a) {
        retval = __habs(*a);
        return 0;
    }
        """

    _ZL6__habs6__half_nbst = declare_device(
        "_ZL6__habs6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6__habs6__half_nbst_caller(arg_0):
        return _ZL6__habs6__half_nbst(arg_0)

    @lower(__habs, _type___half)
    @lower(abs, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__habs6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__habs6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__habs6__half_nbst(shim_stream, shim_obj)


def __hadd():
    pass


def _lower__ZL6__hadd6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hadd6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hadd(*a, *b);
        return 0;
    }
        """

    _ZL6__hadd6__halfS__nbst = declare_device(
        "_ZL6__hadd6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hadd6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hadd6__halfS__nbst(arg_0, arg_1)

    @lower(__hadd, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hadd6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hadd6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hadd6__halfS__nbst(shim_stream, shim_obj)


def __hsub():
    pass


def _lower__ZL6__hsub6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hsub6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hsub(*a, *b);
        return 0;
    }
        """

    _ZL6__hsub6__halfS__nbst = declare_device(
        "_ZL6__hsub6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hsub6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hsub6__halfS__nbst(arg_0, arg_1)

    @lower(__hsub, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hsub6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hsub6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hsub6__halfS__nbst(shim_stream, shim_obj)


def __hmul():
    pass


def _lower__ZL6__hmul6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hmul6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmul(*a, *b);
        return 0;
    }
        """

    _ZL6__hmul6__halfS__nbst = declare_device(
        "_ZL6__hmul6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hmul6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hmul6__halfS__nbst(arg_0, arg_1)

    @lower(__hmul, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hmul6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hmul6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hmul6__halfS__nbst(shim_stream, shim_obj)


def __hadd_rn():
    pass


def _lower__ZL9__hadd_rn6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL9__hadd_rn6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hadd_rn(*a, *b);
        return 0;
    }
        """

    _ZL9__hadd_rn6__halfS__nbst = declare_device(
        "_ZL9__hadd_rn6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL9__hadd_rn6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL9__hadd_rn6__halfS__nbst(arg_0, arg_1)

    @lower(__hadd_rn, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL9__hadd_rn6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL9__hadd_rn6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL9__hadd_rn6__halfS__nbst(shim_stream, shim_obj)


def __hsub_rn():
    pass


def _lower__ZL9__hsub_rn6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL9__hsub_rn6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hsub_rn(*a, *b);
        return 0;
    }
        """

    _ZL9__hsub_rn6__halfS__nbst = declare_device(
        "_ZL9__hsub_rn6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL9__hsub_rn6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL9__hsub_rn6__halfS__nbst(arg_0, arg_1)

    @lower(__hsub_rn, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL9__hsub_rn6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL9__hsub_rn6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL9__hsub_rn6__halfS__nbst(shim_stream, shim_obj)


def __hmul_rn():
    pass


def _lower__ZL9__hmul_rn6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL9__hmul_rn6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmul_rn(*a, *b);
        return 0;
    }
        """

    _ZL9__hmul_rn6__halfS__nbst = declare_device(
        "_ZL9__hmul_rn6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL9__hmul_rn6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL9__hmul_rn6__halfS__nbst(arg_0, arg_1)

    @lower(__hmul_rn, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL9__hmul_rn6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL9__hmul_rn6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL9__hmul_rn6__halfS__nbst(shim_stream, shim_obj)


def __hdiv():
    pass


def _lower__ZL6__hdiv6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hdiv6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hdiv(*a, *b);
        return 0;
    }
        """

    _ZL6__hdiv6__halfS__nbst = declare_device(
        "_ZL6__hdiv6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hdiv6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hdiv6__halfS__nbst(arg_0, arg_1)

    @lower(__hdiv, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hdiv6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hdiv6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL6__hdiv6__halfS__nbst(shim_stream, shim_obj)


def __hadd_sat():
    pass


def _lower__ZL10__hadd_sat6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hadd_sat6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hadd_sat(*a, *b);
        return 0;
    }
        """

    _ZL10__hadd_sat6__halfS__nbst = declare_device(
        "_ZL10__hadd_sat6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL10__hadd_sat6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL10__hadd_sat6__halfS__nbst(arg_0, arg_1)

    @lower(__hadd_sat, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hadd_sat6__halfS__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hadd_sat6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL10__hadd_sat6__halfS__nbst(shim_stream, shim_obj)


def __hsub_sat():
    pass


def _lower__ZL10__hsub_sat6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hsub_sat6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hsub_sat(*a, *b);
        return 0;
    }
        """

    _ZL10__hsub_sat6__halfS__nbst = declare_device(
        "_ZL10__hsub_sat6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL10__hsub_sat6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL10__hsub_sat6__halfS__nbst(arg_0, arg_1)

    @lower(__hsub_sat, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hsub_sat6__halfS__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hsub_sat6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL10__hsub_sat6__halfS__nbst(shim_stream, shim_obj)


def __hmul_sat():
    pass


def _lower__ZL10__hmul_sat6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hmul_sat6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmul_sat(*a, *b);
        return 0;
    }
        """

    _ZL10__hmul_sat6__halfS__nbst = declare_device(
        "_ZL10__hmul_sat6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL10__hmul_sat6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL10__hmul_sat6__halfS__nbst(arg_0, arg_1)

    @lower(__hmul_sat, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hmul_sat6__halfS__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hmul_sat6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL10__hmul_sat6__halfS__nbst(shim_stream, shim_obj)


def __hfma():
    pass


def _lower__ZL6__hfma6__halfS_S__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hfma6__halfS_S__nbst(__half &retval , __half* a, __half* b, __half* c) {
        retval = __hfma(*a, *b, *c);
        return 0;
    }
        """

    _ZL6__hfma6__halfS_S__nbst = declare_device(
        "_ZL6__hfma6__halfS_S__nbst",
        _type___half(
            CPointer(_type___half),
            CPointer(_type___half),
            CPointer(_type___half),
        ),
    )

    def _ZL6__hfma6__halfS_S__nbst_caller(arg_0, arg_1, arg_2):
        return _ZL6__hfma6__halfS_S__nbst(arg_0, arg_1, arg_2)

    @lower(__hfma, _type___half, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hfma6__halfS_S__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hfma6__halfS_S__nbst_caller,
            signature(
                _type___half,
                CPointer(_type___half),
                CPointer(_type___half),
                CPointer(_type___half),
            ),
            ptrs,
        )


_lower__ZL6__hfma6__halfS_S__nbst(shim_stream, shim_obj)


def __hfma_sat():
    pass


def _lower__ZL10__hfma_sat6__halfS_S__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hfma_sat6__halfS_S__nbst(__half &retval , __half* a, __half* b, __half* c) {
        retval = __hfma_sat(*a, *b, *c);
        return 0;
    }
        """

    _ZL10__hfma_sat6__halfS_S__nbst = declare_device(
        "_ZL10__hfma_sat6__halfS_S__nbst",
        _type___half(
            CPointer(_type___half),
            CPointer(_type___half),
            CPointer(_type___half),
        ),
    )

    def _ZL10__hfma_sat6__halfS_S__nbst_caller(arg_0, arg_1, arg_2):
        return _ZL10__hfma_sat6__halfS_S__nbst(arg_0, arg_1, arg_2)

    @lower(__hfma_sat, _type___half, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hfma_sat6__halfS_S__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hfma_sat6__halfS_S__nbst_caller,
            signature(
                _type___half,
                CPointer(_type___half),
                CPointer(_type___half),
                CPointer(_type___half),
            ),
            ptrs,
        )


_lower__ZL10__hfma_sat6__halfS_S__nbst(shim_stream, shim_obj)


def __hneg():
    pass


def _lower__ZL6__hneg6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hneg6__half_nbst(__half &retval , __half* a) {
        retval = __hneg(*a);
        return 0;
    }
        """

    _ZL6__hneg6__half_nbst = declare_device(
        "_ZL6__hneg6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6__hneg6__half_nbst_caller(arg_0):
        return _ZL6__hneg6__half_nbst(arg_0)

    @lower(__hneg, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hneg6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hneg6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hneg6__half_nbst(shim_stream, shim_obj)


def __heq():
    pass


def _lower__ZL5__heq6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__heq6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __heq(*a, *b);
        return 0;
    }
        """

    _ZL5__heq6__halfS__nbst = declare_device(
        "_ZL5__heq6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__heq6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__heq6__halfS__nbst(arg_0, arg_1)

    @lower(__heq, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__heq6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__heq6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__heq6__halfS__nbst(shim_stream, shim_obj)


def __hne():
    pass


def _lower__ZL5__hne6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__hne6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hne(*a, *b);
        return 0;
    }
        """

    _ZL5__hne6__halfS__nbst = declare_device(
        "_ZL5__hne6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__hne6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__hne6__halfS__nbst(arg_0, arg_1)

    @lower(__hne, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__hne6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__hne6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__hne6__halfS__nbst(shim_stream, shim_obj)


def __hle():
    pass


def _lower__ZL5__hle6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__hle6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hle(*a, *b);
        return 0;
    }
        """

    _ZL5__hle6__halfS__nbst = declare_device(
        "_ZL5__hle6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__hle6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__hle6__halfS__nbst(arg_0, arg_1)

    @lower(__hle, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__hle6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__hle6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__hle6__halfS__nbst(shim_stream, shim_obj)


def __hge():
    pass


def _lower__ZL5__hge6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__hge6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hge(*a, *b);
        return 0;
    }
        """

    _ZL5__hge6__halfS__nbst = declare_device(
        "_ZL5__hge6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__hge6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__hge6__halfS__nbst(arg_0, arg_1)

    @lower(__hge, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__hge6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__hge6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__hge6__halfS__nbst(shim_stream, shim_obj)


def __hlt():
    pass


def _lower__ZL5__hlt6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__hlt6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hlt(*a, *b);
        return 0;
    }
        """

    _ZL5__hlt6__halfS__nbst = declare_device(
        "_ZL5__hlt6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__hlt6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__hlt6__halfS__nbst(arg_0, arg_1)

    @lower(__hlt, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__hlt6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__hlt6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__hlt6__halfS__nbst(shim_stream, shim_obj)


def __hgt():
    pass


def _lower__ZL5__hgt6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5__hgt6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hgt(*a, *b);
        return 0;
    }
        """

    _ZL5__hgt6__halfS__nbst = declare_device(
        "_ZL5__hgt6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL5__hgt6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL5__hgt6__halfS__nbst(arg_0, arg_1)

    @lower(__hgt, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5__hgt6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5__hgt6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5__hgt6__halfS__nbst(shim_stream, shim_obj)


def __hequ():
    pass


def _lower__ZL6__hequ6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hequ6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hequ(*a, *b);
        return 0;
    }
        """

    _ZL6__hequ6__halfS__nbst = declare_device(
        "_ZL6__hequ6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hequ6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hequ6__halfS__nbst(arg_0, arg_1)

    @lower(__hequ, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hequ6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hequ6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hequ6__halfS__nbst(shim_stream, shim_obj)


def __hneu():
    pass


def _lower__ZL6__hneu6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hneu6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hneu(*a, *b);
        return 0;
    }
        """

    _ZL6__hneu6__halfS__nbst = declare_device(
        "_ZL6__hneu6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hneu6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hneu6__halfS__nbst(arg_0, arg_1)

    @lower(__hneu, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hneu6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hneu6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hneu6__halfS__nbst(shim_stream, shim_obj)


def __hleu():
    pass


def _lower__ZL6__hleu6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hleu6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hleu(*a, *b);
        return 0;
    }
        """

    _ZL6__hleu6__halfS__nbst = declare_device(
        "_ZL6__hleu6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hleu6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hleu6__halfS__nbst(arg_0, arg_1)

    @lower(__hleu, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hleu6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hleu6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hleu6__halfS__nbst(shim_stream, shim_obj)


def __hgeu():
    pass


def _lower__ZL6__hgeu6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hgeu6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hgeu(*a, *b);
        return 0;
    }
        """

    _ZL6__hgeu6__halfS__nbst = declare_device(
        "_ZL6__hgeu6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hgeu6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hgeu6__halfS__nbst(arg_0, arg_1)

    @lower(__hgeu, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hgeu6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hgeu6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hgeu6__halfS__nbst(shim_stream, shim_obj)


def __hltu():
    pass


def _lower__ZL6__hltu6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hltu6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hltu(*a, *b);
        return 0;
    }
        """

    _ZL6__hltu6__halfS__nbst = declare_device(
        "_ZL6__hltu6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hltu6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hltu6__halfS__nbst(arg_0, arg_1)

    @lower(__hltu, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hltu6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hltu6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hltu6__halfS__nbst(shim_stream, shim_obj)


def __hgtu():
    pass


def _lower__ZL6__hgtu6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6__hgtu6__halfS__nbst(bool &retval , __half* a, __half* b) {
        retval = __hgtu(*a, *b);
        return 0;
    }
        """

    _ZL6__hgtu6__halfS__nbst = declare_device(
        "_ZL6__hgtu6__halfS__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL6__hgtu6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL6__hgtu6__halfS__nbst(arg_0, arg_1)

    @lower(__hgtu, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6__hgtu6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6__hgtu6__halfS__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6__hgtu6__halfS__nbst(shim_stream, shim_obj)


def __hisnan():
    pass


def _lower__ZL8__hisnan6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL8__hisnan6__half_nbst(bool &retval , __half* a) {
        retval = __hisnan(*a);
        return 0;
    }
        """

    _ZL8__hisnan6__half_nbst = declare_device(
        "_ZL8__hisnan6__half_nbst", bool_(CPointer(_type___half))
    )

    def _ZL8__hisnan6__half_nbst_caller(arg_0):
        return _ZL8__hisnan6__half_nbst(arg_0)

    @lower(__hisnan, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL8__hisnan6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL8__hisnan6__half_nbst_caller,
            signature(bool_, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL8__hisnan6__half_nbst(shim_stream, shim_obj)


def __hmax_nan():
    pass


def _lower__ZL10__hmax_nan6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hmax_nan6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmax_nan(*a, *b);
        return 0;
    }
        """

    _ZL10__hmax_nan6__halfS__nbst = declare_device(
        "_ZL10__hmax_nan6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL10__hmax_nan6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL10__hmax_nan6__halfS__nbst(arg_0, arg_1)

    @lower(__hmax_nan, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hmax_nan6__halfS__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hmax_nan6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL10__hmax_nan6__halfS__nbst(shim_stream, shim_obj)


def __hmin_nan():
    pass


def _lower__ZL10__hmin_nan6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL10__hmin_nan6__halfS__nbst(__half &retval , __half* a, __half* b) {
        retval = __hmin_nan(*a, *b);
        return 0;
    }
        """

    _ZL10__hmin_nan6__halfS__nbst = declare_device(
        "_ZL10__hmin_nan6__halfS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZL10__hmin_nan6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL10__hmin_nan6__halfS__nbst(arg_0, arg_1)

    @lower(__hmin_nan, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL10__hmin_nan6__halfS__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL10__hmin_nan6__halfS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZL10__hmin_nan6__halfS__nbst(shim_stream, shim_obj)


def __hfma_relu():
    pass


def _lower__ZL11__hfma_relu6__halfS_S__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL11__hfma_relu6__halfS_S__nbst(__half &retval , __half* a, __half* b, __half* c) {
        retval = __hfma_relu(*a, *b, *c);
        return 0;
    }
        """

    _ZL11__hfma_relu6__halfS_S__nbst = declare_device(
        "_ZL11__hfma_relu6__halfS_S__nbst",
        _type___half(
            CPointer(_type___half),
            CPointer(_type___half),
            CPointer(_type___half),
        ),
    )

    def _ZL11__hfma_relu6__halfS_S__nbst_caller(arg_0, arg_1, arg_2):
        return _ZL11__hfma_relu6__halfS_S__nbst(arg_0, arg_1, arg_2)

    @lower(__hfma_relu, _type___half, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL11__hfma_relu6__halfS_S__nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL11__hfma_relu6__halfS_S__nbst_caller,
            signature(
                _type___half,
                CPointer(_type___half),
                CPointer(_type___half),
                CPointer(_type___half),
            ),
            ptrs,
        )


_lower__ZL11__hfma_relu6__halfS_S__nbst(shim_stream, shim_obj)


def hsqrt():
    pass


def _lower__ZL5hsqrt6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5hsqrt6__half_nbst(__half &retval , __half* a) {
        retval = hsqrt(*a);
        return 0;
    }
        """

    _ZL5hsqrt6__half_nbst = declare_device(
        "_ZL5hsqrt6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5hsqrt6__half_nbst_caller(arg_0):
        return _ZL5hsqrt6__half_nbst(arg_0)

    @lower(hsqrt, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5hsqrt6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5hsqrt6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5hsqrt6__half_nbst(shim_stream, shim_obj)


def hrsqrt():
    pass


def _lower__ZL6hrsqrt6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6hrsqrt6__half_nbst(__half &retval , __half* a) {
        retval = hrsqrt(*a);
        return 0;
    }
        """

    _ZL6hrsqrt6__half_nbst = declare_device(
        "_ZL6hrsqrt6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6hrsqrt6__half_nbst_caller(arg_0):
        return _ZL6hrsqrt6__half_nbst(arg_0)

    @lower(hrsqrt, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6hrsqrt6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6hrsqrt6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6hrsqrt6__half_nbst(shim_stream, shim_obj)


def hrcp():
    pass


def _lower__ZL4hrcp6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL4hrcp6__half_nbst(__half &retval , __half* a) {
        retval = hrcp(*a);
        return 0;
    }
        """

    _ZL4hrcp6__half_nbst = declare_device(
        "_ZL4hrcp6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL4hrcp6__half_nbst_caller(arg_0):
        return _ZL4hrcp6__half_nbst(arg_0)

    @lower(hrcp, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL4hrcp6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL4hrcp6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL4hrcp6__half_nbst(shim_stream, shim_obj)


def hlog():
    pass


def _lower__ZL4hlog6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL4hlog6__half_nbst(__half &retval , __half* a) {
        retval = hlog(*a);
        return 0;
    }
        """

    _ZL4hlog6__half_nbst = declare_device(
        "_ZL4hlog6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL4hlog6__half_nbst_caller(arg_0):
        return _ZL4hlog6__half_nbst(arg_0)

    @lower(hlog, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL4hlog6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL4hlog6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL4hlog6__half_nbst(shim_stream, shim_obj)


def hlog2():
    pass


def _lower__ZL5hlog26__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5hlog26__half_nbst(__half &retval , __half* a) {
        retval = hlog2(*a);
        return 0;
    }
        """

    _ZL5hlog26__half_nbst = declare_device(
        "_ZL5hlog26__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5hlog26__half_nbst_caller(arg_0):
        return _ZL5hlog26__half_nbst(arg_0)

    @lower(hlog2, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5hlog26__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5hlog26__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5hlog26__half_nbst(shim_stream, shim_obj)


def hlog10():
    pass


def _lower__ZL6hlog106__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6hlog106__half_nbst(__half &retval , __half* a) {
        retval = hlog10(*a);
        return 0;
    }
        """

    _ZL6hlog106__half_nbst = declare_device(
        "_ZL6hlog106__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6hlog106__half_nbst_caller(arg_0):
        return _ZL6hlog106__half_nbst(arg_0)

    @lower(hlog10, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6hlog106__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6hlog106__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6hlog106__half_nbst(shim_stream, shim_obj)


def hexp():
    pass


def _lower__ZL4hexp6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL4hexp6__half_nbst(__half &retval , __half* a) {
        retval = hexp(*a);
        return 0;
    }
        """

    _ZL4hexp6__half_nbst = declare_device(
        "_ZL4hexp6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL4hexp6__half_nbst_caller(arg_0):
        return _ZL4hexp6__half_nbst(arg_0)

    @lower(hexp, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL4hexp6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL4hexp6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL4hexp6__half_nbst(shim_stream, shim_obj)


def htanh_approx():
    pass


def _lower__ZL12htanh_approx6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL12htanh_approx6__half_nbst(__half &retval , __half* a) {
        retval = htanh_approx(*a);
        return 0;
    }
        """

    _ZL12htanh_approx6__half_nbst = declare_device(
        "_ZL12htanh_approx6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL12htanh_approx6__half_nbst_caller(arg_0):
        return _ZL12htanh_approx6__half_nbst(arg_0)

    @lower(htanh_approx, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key(
            "_ZL12htanh_approx6__half_nbst", shim_raw_str
        )
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL12htanh_approx6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL12htanh_approx6__half_nbst(shim_stream, shim_obj)


def htanh():
    pass


def _lower__ZL5htanh6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5htanh6__half_nbst(__half &retval , __half* a) {
        retval = htanh(*a);
        return 0;
    }
        """

    _ZL5htanh6__half_nbst = declare_device(
        "_ZL5htanh6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5htanh6__half_nbst_caller(arg_0):
        return _ZL5htanh6__half_nbst(arg_0)

    @lower(htanh, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5htanh6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5htanh6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5htanh6__half_nbst(shim_stream, shim_obj)


def hexp2():
    pass


def _lower__ZL5hexp26__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL5hexp26__half_nbst(__half &retval , __half* a) {
        retval = hexp2(*a);
        return 0;
    }
        """

    _ZL5hexp26__half_nbst = declare_device(
        "_ZL5hexp26__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL5hexp26__half_nbst_caller(arg_0):
        return _ZL5hexp26__half_nbst(arg_0)

    @lower(hexp2, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL5hexp26__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL5hexp26__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL5hexp26__half_nbst(shim_stream, shim_obj)


def hexp10():
    pass


def _lower__ZL6hexp106__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL6hexp106__half_nbst(__half &retval , __half* a) {
        retval = hexp10(*a);
        return 0;
    }
        """

    _ZL6hexp106__half_nbst = declare_device(
        "_ZL6hexp106__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL6hexp106__half_nbst_caller(arg_0):
        return _ZL6hexp106__half_nbst(arg_0)

    @lower(hexp10, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL6hexp106__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL6hexp106__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL6hexp106__half_nbst(shim_stream, shim_obj)


def hcos():
    pass


def _lower__ZL4hcos6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL4hcos6__half_nbst(__half &retval , __half* a) {
        retval = hcos(*a);
        return 0;
    }
        """

    _ZL4hcos6__half_nbst = declare_device(
        "_ZL4hcos6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL4hcos6__half_nbst_caller(arg_0):
        return _ZL4hcos6__half_nbst(arg_0)

    @lower(hcos, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL4hcos6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL4hcos6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL4hcos6__half_nbst(shim_stream, shim_obj)


def hsin():
    pass


def _lower__ZL4hsin6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL4hsin6__half_nbst(__half &retval , __half* a) {
        retval = hsin(*a);
        return 0;
    }
        """

    _ZL4hsin6__half_nbst = declare_device(
        "_ZL4hsin6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZL4hsin6__half_nbst_caller(arg_0):
        return _ZL4hsin6__half_nbst(arg_0)

    @lower(hsin, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL4hsin6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL4hsin6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZL4hsin6__half_nbst(shim_stream, shim_obj)


def atomicAdd():
    pass


def _lower__ZL9atomicAddP6__halfS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZL9atomicAddP6__halfS__nbst(__half &retval , __half ** address, __half* val) {
        retval = atomicAdd(*address, *val);
        return 0;
    }
        """

    _ZL9atomicAddP6__halfS__nbst = declare_device(
        "_ZL9atomicAddP6__halfS__nbst",
        _type___half(CPointer(CPointer(_type___half)), CPointer(_type___half)),
    )

    def _ZL9atomicAddP6__halfS__nbst_caller(arg_0, arg_1):
        return _ZL9atomicAddP6__halfS__nbst(arg_0, arg_1)

    @lower(atomicAdd, CPointer(_type___half), _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZL9atomicAddP6__halfS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZL9atomicAddP6__halfS__nbst_caller,
            signature(
                _type___half,
                CPointer(CPointer(_type___half)),
                CPointer(_type___half),
            ),
            ptrs,
        )


_lower__ZL9atomicAddP6__halfS__nbst(shim_stream, shim_obj)


def _lower__ZplRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZplRK6__halfS1__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator+(*lh, *rh);
        return 0;
    }
        """

    _ZplRK6__halfS1__nbst = declare_device(
        "_ZplRK6__halfS1__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZplRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZplRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.add, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZplRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZplRK6__halfS1__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZplRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZmiRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZmiRK6__halfS1__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator-(*lh, *rh);
        return 0;
    }
        """

    _ZmiRK6__halfS1__nbst = declare_device(
        "_ZmiRK6__halfS1__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZmiRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZmiRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.sub, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZmiRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZmiRK6__halfS1__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZmiRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZmlRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZmlRK6__halfS1__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator*(*lh, *rh);
        return 0;
    }
        """

    _ZmlRK6__halfS1__nbst = declare_device(
        "_ZmlRK6__halfS1__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZmlRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZmlRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.mul, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZmlRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZmlRK6__halfS1__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZmlRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZdvRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZdvRK6__halfS1__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator/(*lh, *rh);
        return 0;
    }
        """

    _ZdvRK6__halfS1__nbst = declare_device(
        "_ZdvRK6__halfS1__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZdvRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZdvRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.truediv, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZdvRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZdvRK6__halfS1__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZdvRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZpLR6__halfRKS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZpLR6__halfRKS__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator+=(*lh, *rh);
        return 0;
    }
        """

    _ZpLR6__halfRKS__nbst = declare_device(
        "_ZpLR6__halfRKS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZpLR6__halfRKS__nbst_caller(arg_0, arg_1):
        return _ZpLR6__halfRKS__nbst(arg_0, arg_1)

    @lower(operator.iadd, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZpLR6__halfRKS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZpLR6__halfRKS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZpLR6__halfRKS__nbst(shim_stream, shim_obj)


def _lower__ZmIR6__halfRKS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZmIR6__halfRKS__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator-=(*lh, *rh);
        return 0;
    }
        """

    _ZmIR6__halfRKS__nbst = declare_device(
        "_ZmIR6__halfRKS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZmIR6__halfRKS__nbst_caller(arg_0, arg_1):
        return _ZmIR6__halfRKS__nbst(arg_0, arg_1)

    @lower(operator.isub, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZmIR6__halfRKS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZmIR6__halfRKS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZmIR6__halfRKS__nbst(shim_stream, shim_obj)


def _lower__ZmLR6__halfRKS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZmLR6__halfRKS__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator*=(*lh, *rh);
        return 0;
    }
        """

    _ZmLR6__halfRKS__nbst = declare_device(
        "_ZmLR6__halfRKS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZmLR6__halfRKS__nbst_caller(arg_0, arg_1):
        return _ZmLR6__halfRKS__nbst(arg_0, arg_1)

    @lower(operator.imul, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZmLR6__halfRKS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZmLR6__halfRKS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZmLR6__halfRKS__nbst(shim_stream, shim_obj)


def _lower__ZdVR6__halfRKS__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZdVR6__halfRKS__nbst(__half &retval , __half* lh, __half* rh) {
        retval = operator/=(*lh, *rh);
        return 0;
    }
        """

    _ZdVR6__halfRKS__nbst = declare_device(
        "_ZdVR6__halfRKS__nbst",
        _type___half(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZdVR6__halfRKS__nbst_caller(arg_0, arg_1):
        return _ZdVR6__halfRKS__nbst(arg_0, arg_1)

    @lower(operator.itruediv, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZdVR6__halfRKS__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZdVR6__halfRKS__nbst_caller,
            signature(
                _type___half, CPointer(_type___half), CPointer(_type___half)
            ),
            ptrs,
        )


_lower__ZdVR6__halfRKS__nbst(shim_stream, shim_obj)


def _lower__ZpsRK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZpsRK6__half_nbst(__half &retval , __half* h) {
        retval = operator+(*h);
        return 0;
    }
        """

    _ZpsRK6__half_nbst = declare_device(
        "_ZpsRK6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZpsRK6__half_nbst_caller(arg_0):
        return _ZpsRK6__half_nbst(arg_0)

    @lower(operator.pos, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZpsRK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZpsRK6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZpsRK6__half_nbst(shim_stream, shim_obj)


def _lower__ZngRK6__half_nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZngRK6__half_nbst(__half &retval , __half* h) {
        retval = operator-(*h);
        return 0;
    }
        """

    _ZngRK6__half_nbst = declare_device(
        "_ZngRK6__half_nbst", _type___half(CPointer(_type___half))
    )

    def _ZngRK6__half_nbst_caller(arg_0):
        return _ZngRK6__half_nbst(arg_0)

    @lower(operator.neg, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZngRK6__half_nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZngRK6__half_nbst_caller,
            signature(_type___half, CPointer(_type___half)),
            ptrs,
        )


_lower__ZngRK6__half_nbst(shim_stream, shim_obj)


def _lower__ZeqRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZeqRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator==(*lh, *rh);
        return 0;
    }
        """

    _ZeqRK6__halfS1__nbst = declare_device(
        "_ZeqRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZeqRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZeqRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.eq, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZeqRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZeqRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZeqRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZneRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZneRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator!=(*lh, *rh);
        return 0;
    }
        """

    _ZneRK6__halfS1__nbst = declare_device(
        "_ZneRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZneRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZneRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.ne, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZneRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZneRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZneRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZgtRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZgtRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator>(*lh, *rh);
        return 0;
    }
        """

    _ZgtRK6__halfS1__nbst = declare_device(
        "_ZgtRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZgtRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZgtRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.gt, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZgtRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZgtRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZgtRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZltRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZltRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator<(*lh, *rh);
        return 0;
    }
        """

    _ZltRK6__halfS1__nbst = declare_device(
        "_ZltRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZltRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZltRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.lt, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZltRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZltRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZltRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZgeRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZgeRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator>=(*lh, *rh);
        return 0;
    }
        """

    _ZgeRK6__halfS1__nbst = declare_device(
        "_ZgeRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZgeRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZgeRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.ge, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZgeRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZgeRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZgeRK6__halfS1__nbst(shim_stream, shim_obj)


def _lower__ZleRK6__halfS1__nbst(shim_stream, shim_obj):
    shim_raw_str = """
    extern "C" __device__ int
    _ZleRK6__halfS1__nbst(bool &retval , __half* lh, __half* rh) {
        retval = operator<=(*lh, *rh);
        return 0;
    }
        """

    _ZleRK6__halfS1__nbst = declare_device(
        "_ZleRK6__halfS1__nbst",
        bool_(CPointer(_type___half), CPointer(_type___half)),
    )

    def _ZleRK6__halfS1__nbst_caller(arg_0, arg_1):
        return _ZleRK6__halfS1__nbst(arg_0, arg_1)

    @lower(operator.le, _type___half, _type___half)
    def impl(context, builder, sig, args):
        context.active_code_library.add_linking_file(shim_obj)
        shim_stream.write_with_key("_ZleRK6__halfS1__nbst", shim_raw_str)
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _ZleRK6__halfS1__nbst_caller,
            signature(bool_, CPointer(_type___half), CPointer(_type___half)),
            ptrs,
        )


_lower__ZleRK6__halfS1__nbst(shim_stream, shim_obj)


@register
class _typing___double2half(ConcreteTemplate):
    key = globals()["__double2half"]
    cases = [signature(_type___half, float64)]


register_global(__double2half, types.Function(_typing___double2half))


@register
class _typing___float2half(ConcreteTemplate):
    key = globals()["__float2half"]
    cases = [signature(_type___half, float32)]


register_global(__float2half, types.Function(_typing___float2half))


@register
class _typing___float2half_rn(ConcreteTemplate):
    key = globals()["__float2half_rn"]
    cases = [signature(_type___half, float32)]


register_global(__float2half_rn, types.Function(_typing___float2half_rn))


@register
class _typing___float2half_rz(ConcreteTemplate):
    key = globals()["__float2half_rz"]
    cases = [signature(_type___half, float32)]


register_global(__float2half_rz, types.Function(_typing___float2half_rz))


@register
class _typing___float2half_rd(ConcreteTemplate):
    key = globals()["__float2half_rd"]
    cases = [signature(_type___half, float32)]


register_global(__float2half_rd, types.Function(_typing___float2half_rd))


@register
class _typing___float2half_ru(ConcreteTemplate):
    key = globals()["__float2half_ru"]
    cases = [signature(_type___half, float32)]


register_global(__float2half_ru, types.Function(_typing___float2half_ru))


@register
class _typing___half2float(ConcreteTemplate):
    key = globals()["__half2float"]
    cases = [signature(float32, _type___half)]


register_global(__half2float, types.Function(_typing___half2float))


@register
class _typing___half2char_rz(ConcreteTemplate):
    key = globals()["__half2char_rz"]
    cases = [signature(int8, _type___half)]


register_global(__half2char_rz, types.Function(_typing___half2char_rz))


@register
class _typing___half2uchar_rz(ConcreteTemplate):
    key = globals()["__half2uchar_rz"]
    cases = [signature(uint8, _type___half)]


register_global(__half2uchar_rz, types.Function(_typing___half2uchar_rz))


@register
class _typing___half2short_rz(ConcreteTemplate):
    key = globals()["__half2short_rz"]
    cases = [signature(int16, _type___half)]


register_global(__half2short_rz, types.Function(_typing___half2short_rz))


@register
class _typing___half2ushort_rz(ConcreteTemplate):
    key = globals()["__half2ushort_rz"]
    cases = [signature(uint16, _type___half)]


register_global(__half2ushort_rz, types.Function(_typing___half2ushort_rz))


@register
class _typing___half2int_rz(ConcreteTemplate):
    key = globals()["__half2int_rz"]
    cases = [signature(int32, _type___half)]


register_global(__half2int_rz, types.Function(_typing___half2int_rz))


@register
class _typing___half2uint_rz(ConcreteTemplate):
    key = globals()["__half2uint_rz"]
    cases = [signature(uint32, _type___half)]


register_global(__half2uint_rz, types.Function(_typing___half2uint_rz))


@register
class _typing___half2ll_rz(ConcreteTemplate):
    key = globals()["__half2ll_rz"]
    cases = [signature(int64, _type___half)]


register_global(__half2ll_rz, types.Function(_typing___half2ll_rz))


@register
class _typing___half2ull_rz(ConcreteTemplate):
    key = globals()["__half2ull_rz"]
    cases = [signature(uint64, _type___half)]


register_global(__half2ull_rz, types.Function(_typing___half2ull_rz))


@register
class _typing___half2int_rn(ConcreteTemplate):
    key = globals()["__half2int_rn"]
    cases = [signature(int32, _type___half)]


register_global(__half2int_rn, types.Function(_typing___half2int_rn))


@register
class _typing___half2int_rd(ConcreteTemplate):
    key = globals()["__half2int_rd"]
    cases = [signature(int32, _type___half)]


register_global(__half2int_rd, types.Function(_typing___half2int_rd))


@register
class _typing___half2int_ru(ConcreteTemplate):
    key = globals()["__half2int_ru"]
    cases = [signature(int32, _type___half)]


register_global(__half2int_ru, types.Function(_typing___half2int_ru))


@register
class _typing___int2half_rn(ConcreteTemplate):
    key = globals()["__int2half_rn"]
    cases = [signature(_type___half, int32)]


register_global(__int2half_rn, types.Function(_typing___int2half_rn))


@register
class _typing___int2half_rz(ConcreteTemplate):
    key = globals()["__int2half_rz"]
    cases = [signature(_type___half, int32)]


register_global(__int2half_rz, types.Function(_typing___int2half_rz))


@register
class _typing___int2half_rd(ConcreteTemplate):
    key = globals()["__int2half_rd"]
    cases = [signature(_type___half, int32)]


register_global(__int2half_rd, types.Function(_typing___int2half_rd))


@register
class _typing___int2half_ru(ConcreteTemplate):
    key = globals()["__int2half_ru"]
    cases = [signature(_type___half, int32)]


register_global(__int2half_ru, types.Function(_typing___int2half_ru))


@register
class _typing___half2short_rn(ConcreteTemplate):
    key = globals()["__half2short_rn"]
    cases = [signature(int16, _type___half)]


register_global(__half2short_rn, types.Function(_typing___half2short_rn))


@register
class _typing___half2short_rd(ConcreteTemplate):
    key = globals()["__half2short_rd"]
    cases = [signature(int16, _type___half)]


register_global(__half2short_rd, types.Function(_typing___half2short_rd))


@register
class _typing___half2short_ru(ConcreteTemplate):
    key = globals()["__half2short_ru"]
    cases = [signature(int16, _type___half)]


register_global(__half2short_ru, types.Function(_typing___half2short_ru))


@register
class _typing___short2half_rn(ConcreteTemplate):
    key = globals()["__short2half_rn"]
    cases = [signature(_type___half, int16)]


register_global(__short2half_rn, types.Function(_typing___short2half_rn))


@register
class _typing___short2half_rz(ConcreteTemplate):
    key = globals()["__short2half_rz"]
    cases = [signature(_type___half, int16)]


register_global(__short2half_rz, types.Function(_typing___short2half_rz))


@register
class _typing___short2half_rd(ConcreteTemplate):
    key = globals()["__short2half_rd"]
    cases = [signature(_type___half, int16)]


register_global(__short2half_rd, types.Function(_typing___short2half_rd))


@register
class _typing___short2half_ru(ConcreteTemplate):
    key = globals()["__short2half_ru"]
    cases = [signature(_type___half, int16)]


register_global(__short2half_ru, types.Function(_typing___short2half_ru))


@register
class _typing___half2uint_rn(ConcreteTemplate):
    key = globals()["__half2uint_rn"]
    cases = [signature(uint32, _type___half)]


register_global(__half2uint_rn, types.Function(_typing___half2uint_rn))


@register
class _typing___half2uint_rd(ConcreteTemplate):
    key = globals()["__half2uint_rd"]
    cases = [signature(uint32, _type___half)]


register_global(__half2uint_rd, types.Function(_typing___half2uint_rd))


@register
class _typing___half2uint_ru(ConcreteTemplate):
    key = globals()["__half2uint_ru"]
    cases = [signature(uint32, _type___half)]


register_global(__half2uint_ru, types.Function(_typing___half2uint_ru))


@register
class _typing___uint2half_rn(ConcreteTemplate):
    key = globals()["__uint2half_rn"]
    cases = [signature(_type___half, uint32)]


register_global(__uint2half_rn, types.Function(_typing___uint2half_rn))


@register
class _typing___uint2half_rz(ConcreteTemplate):
    key = globals()["__uint2half_rz"]
    cases = [signature(_type___half, uint32)]


register_global(__uint2half_rz, types.Function(_typing___uint2half_rz))


@register
class _typing___uint2half_rd(ConcreteTemplate):
    key = globals()["__uint2half_rd"]
    cases = [signature(_type___half, uint32)]


register_global(__uint2half_rd, types.Function(_typing___uint2half_rd))


@register
class _typing___uint2half_ru(ConcreteTemplate):
    key = globals()["__uint2half_ru"]
    cases = [signature(_type___half, uint32)]


register_global(__uint2half_ru, types.Function(_typing___uint2half_ru))


@register
class _typing___half2ushort_rn(ConcreteTemplate):
    key = globals()["__half2ushort_rn"]
    cases = [signature(uint16, _type___half)]


register_global(__half2ushort_rn, types.Function(_typing___half2ushort_rn))


@register
class _typing___half2ushort_rd(ConcreteTemplate):
    key = globals()["__half2ushort_rd"]
    cases = [signature(uint16, _type___half)]


register_global(__half2ushort_rd, types.Function(_typing___half2ushort_rd))


@register
class _typing___half2ushort_ru(ConcreteTemplate):
    key = globals()["__half2ushort_ru"]
    cases = [signature(uint16, _type___half)]


register_global(__half2ushort_ru, types.Function(_typing___half2ushort_ru))


@register
class _typing___ushort2half_rn(ConcreteTemplate):
    key = globals()["__ushort2half_rn"]
    cases = [signature(_type___half, uint16)]


register_global(__ushort2half_rn, types.Function(_typing___ushort2half_rn))


@register
class _typing___ushort2half_rz(ConcreteTemplate):
    key = globals()["__ushort2half_rz"]
    cases = [signature(_type___half, uint16)]


register_global(__ushort2half_rz, types.Function(_typing___ushort2half_rz))


@register
class _typing___ushort2half_rd(ConcreteTemplate):
    key = globals()["__ushort2half_rd"]
    cases = [signature(_type___half, uint16)]


register_global(__ushort2half_rd, types.Function(_typing___ushort2half_rd))


@register
class _typing___ushort2half_ru(ConcreteTemplate):
    key = globals()["__ushort2half_ru"]
    cases = [signature(_type___half, uint16)]


register_global(__ushort2half_ru, types.Function(_typing___ushort2half_ru))


@register
class _typing___half2ull_rn(ConcreteTemplate):
    key = globals()["__half2ull_rn"]
    cases = [signature(uint64, _type___half)]


register_global(__half2ull_rn, types.Function(_typing___half2ull_rn))


@register
class _typing___half2ull_rd(ConcreteTemplate):
    key = globals()["__half2ull_rd"]
    cases = [signature(uint64, _type___half)]


register_global(__half2ull_rd, types.Function(_typing___half2ull_rd))


@register
class _typing___half2ull_ru(ConcreteTemplate):
    key = globals()["__half2ull_ru"]
    cases = [signature(uint64, _type___half)]


register_global(__half2ull_ru, types.Function(_typing___half2ull_ru))


@register
class _typing___ull2half_rn(ConcreteTemplate):
    key = globals()["__ull2half_rn"]
    cases = [signature(_type___half, uint64)]


register_global(__ull2half_rn, types.Function(_typing___ull2half_rn))


@register
class _typing___ull2half_rz(ConcreteTemplate):
    key = globals()["__ull2half_rz"]
    cases = [signature(_type___half, uint64)]


register_global(__ull2half_rz, types.Function(_typing___ull2half_rz))


@register
class _typing___ull2half_rd(ConcreteTemplate):
    key = globals()["__ull2half_rd"]
    cases = [signature(_type___half, uint64)]


register_global(__ull2half_rd, types.Function(_typing___ull2half_rd))


@register
class _typing___ull2half_ru(ConcreteTemplate):
    key = globals()["__ull2half_ru"]
    cases = [signature(_type___half, uint64)]


register_global(__ull2half_ru, types.Function(_typing___ull2half_ru))


@register
class _typing___half2ll_rn(ConcreteTemplate):
    key = globals()["__half2ll_rn"]
    cases = [signature(int64, _type___half)]


register_global(__half2ll_rn, types.Function(_typing___half2ll_rn))


@register
class _typing___half2ll_rd(ConcreteTemplate):
    key = globals()["__half2ll_rd"]
    cases = [signature(int64, _type___half)]


register_global(__half2ll_rd, types.Function(_typing___half2ll_rd))


@register
class _typing___half2ll_ru(ConcreteTemplate):
    key = globals()["__half2ll_ru"]
    cases = [signature(int64, _type___half)]


register_global(__half2ll_ru, types.Function(_typing___half2ll_ru))


@register
class _typing___ll2half_rn(ConcreteTemplate):
    key = globals()["__ll2half_rn"]
    cases = [signature(_type___half, int64)]


register_global(__ll2half_rn, types.Function(_typing___ll2half_rn))


@register
class _typing___ll2half_rz(ConcreteTemplate):
    key = globals()["__ll2half_rz"]
    cases = [signature(_type___half, int64)]


register_global(__ll2half_rz, types.Function(_typing___ll2half_rz))


@register
class _typing___ll2half_rd(ConcreteTemplate):
    key = globals()["__ll2half_rd"]
    cases = [signature(_type___half, int64)]


register_global(__ll2half_rd, types.Function(_typing___ll2half_rd))


@register
class _typing___ll2half_ru(ConcreteTemplate):
    key = globals()["__ll2half_ru"]
    cases = [signature(_type___half, int64)]


register_global(__ll2half_ru, types.Function(_typing___ll2half_ru))


@register
class _typing_htrunc(ConcreteTemplate):
    key = globals()["htrunc"]
    cases = [signature(_type___half, _type___half)]


register_global(htrunc, types.Function(_typing_htrunc))


@register
class _typing_hceil(ConcreteTemplate):
    key = globals()["hceil"]
    cases = [signature(_type___half, _type___half)]


register_global(hceil, types.Function(_typing_hceil))


@register
class _typing_hfloor(ConcreteTemplate):
    key = globals()["hfloor"]
    cases = [signature(_type___half, _type___half)]


register_global(hfloor, types.Function(_typing_hfloor))


@register
class _typing_hrint(ConcreteTemplate):
    key = globals()["hrint"]
    cases = [signature(_type___half, _type___half)]


register_global(hrint, types.Function(_typing_hrint))


@register
class _typing___hisinf(ConcreteTemplate):
    key = globals()["__hisinf"]
    cases = [signature(int32, _type___half)]


register_global(__hisinf, types.Function(_typing___hisinf))


@register
class _typing___half_as_short(ConcreteTemplate):
    key = globals()["__half_as_short"]
    cases = [signature(int16, _type___half)]


register_global(__half_as_short, types.Function(_typing___half_as_short))


@register
class _typing___half_as_ushort(ConcreteTemplate):
    key = globals()["__half_as_ushort"]
    cases = [signature(uint16, _type___half)]


register_global(__half_as_ushort, types.Function(_typing___half_as_ushort))


@register
class _typing___short_as_half(ConcreteTemplate):
    key = globals()["__short_as_half"]
    cases = [signature(_type___half, int16)]


register_global(__short_as_half, types.Function(_typing___short_as_half))


@register
class _typing___ushort_as_half(ConcreteTemplate):
    key = globals()["__ushort_as_half"]
    cases = [signature(_type___half, uint16)]


register_global(__ushort_as_half, types.Function(_typing___ushort_as_half))


@register
class _typing___hmax(ConcreteTemplate):
    key = globals()["__hmax"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmax, types.Function(_typing___hmax))


@register
class _typing___hmin(ConcreteTemplate):
    key = globals()["__hmin"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmin, types.Function(_typing___hmin))


@register
class _typing___shfl_sync(ConcreteTemplate):
    key = globals()["__shfl_sync"]
    cases = [signature(_type___half, uint32, _type___half, int32, int32)]


register_global(__shfl_sync, types.Function(_typing___shfl_sync))


@register
class _typing___shfl_up_sync(ConcreteTemplate):
    key = globals()["__shfl_up_sync"]
    cases = [signature(_type___half, uint32, _type___half, uint32, int32)]


register_global(__shfl_up_sync, types.Function(_typing___shfl_up_sync))


@register
class _typing___shfl_down_sync(ConcreteTemplate):
    key = globals()["__shfl_down_sync"]
    cases = [signature(_type___half, uint32, _type___half, uint32, int32)]


register_global(__shfl_down_sync, types.Function(_typing___shfl_down_sync))


@register
class _typing___shfl_xor_sync(ConcreteTemplate):
    key = globals()["__shfl_xor_sync"]
    cases = [signature(_type___half, uint32, _type___half, int32, int32)]


register_global(__shfl_xor_sync, types.Function(_typing___shfl_xor_sync))


@register
class _typing___ldg(ConcreteTemplate):
    key = globals()["__ldg"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldg, types.Function(_typing___ldg))


@register
class _typing___ldcg(ConcreteTemplate):
    key = globals()["__ldcg"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldcg, types.Function(_typing___ldcg))


@register
class _typing___ldca(ConcreteTemplate):
    key = globals()["__ldca"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldca, types.Function(_typing___ldca))


@register
class _typing___ldcs(ConcreteTemplate):
    key = globals()["__ldcs"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldcs, types.Function(_typing___ldcs))


@register
class _typing___ldlu(ConcreteTemplate):
    key = globals()["__ldlu"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldlu, types.Function(_typing___ldlu))


@register
class _typing___ldcv(ConcreteTemplate):
    key = globals()["__ldcv"]
    cases = [signature(_type___half, CPointer(_type___half))]


register_global(__ldcv, types.Function(_typing___ldcv))


@register
class _typing___stwb(ConcreteTemplate):
    key = globals()["__stwb"]
    cases = [signature(void, CPointer(_type___half), _type___half)]


register_global(__stwb, types.Function(_typing___stwb))


@register
class _typing___stcg(ConcreteTemplate):
    key = globals()["__stcg"]
    cases = [signature(void, CPointer(_type___half), _type___half)]


register_global(__stcg, types.Function(_typing___stcg))


@register
class _typing___stcs(ConcreteTemplate):
    key = globals()["__stcs"]
    cases = [signature(void, CPointer(_type___half), _type___half)]


register_global(__stcs, types.Function(_typing___stcs))


@register
class _typing___stwt(ConcreteTemplate):
    key = globals()["__stwt"]
    cases = [signature(void, CPointer(_type___half), _type___half)]


register_global(__stwt, types.Function(_typing___stwt))


@register
class _typing___habs(ConcreteTemplate):
    key = globals()["__habs"]
    cases = [signature(_type___half, _type___half)]


register_global(__habs, types.Function(_typing___habs))


@register
class _typing___hadd(ConcreteTemplate):
    key = globals()["__hadd"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hadd, types.Function(_typing___hadd))


@register
class _typing___hsub(ConcreteTemplate):
    key = globals()["__hsub"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hsub, types.Function(_typing___hsub))


@register
class _typing___hmul(ConcreteTemplate):
    key = globals()["__hmul"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmul, types.Function(_typing___hmul))


@register
class _typing___hadd_rn(ConcreteTemplate):
    key = globals()["__hadd_rn"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hadd_rn, types.Function(_typing___hadd_rn))


@register
class _typing___hsub_rn(ConcreteTemplate):
    key = globals()["__hsub_rn"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hsub_rn, types.Function(_typing___hsub_rn))


@register
class _typing___hmul_rn(ConcreteTemplate):
    key = globals()["__hmul_rn"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmul_rn, types.Function(_typing___hmul_rn))


@register
class _typing___hdiv(ConcreteTemplate):
    key = globals()["__hdiv"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hdiv, types.Function(_typing___hdiv))


@register
class _typing___hadd_sat(ConcreteTemplate):
    key = globals()["__hadd_sat"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hadd_sat, types.Function(_typing___hadd_sat))


@register
class _typing___hsub_sat(ConcreteTemplate):
    key = globals()["__hsub_sat"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hsub_sat, types.Function(_typing___hsub_sat))


@register
class _typing___hmul_sat(ConcreteTemplate):
    key = globals()["__hmul_sat"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmul_sat, types.Function(_typing___hmul_sat))


@register
class _typing___hfma(ConcreteTemplate):
    key = globals()["__hfma"]
    cases = [signature(_type___half, _type___half, _type___half, _type___half)]


register_global(__hfma, types.Function(_typing___hfma))


@register
class _typing___hfma_sat(ConcreteTemplate):
    key = globals()["__hfma_sat"]
    cases = [signature(_type___half, _type___half, _type___half, _type___half)]


register_global(__hfma_sat, types.Function(_typing___hfma_sat))


@register
class _typing___hneg(ConcreteTemplate):
    key = globals()["__hneg"]
    cases = [signature(_type___half, _type___half)]


register_global(__hneg, types.Function(_typing___hneg))


@register
class _typing___heq(ConcreteTemplate):
    key = globals()["__heq"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__heq, types.Function(_typing___heq))


@register
class _typing___hne(ConcreteTemplate):
    key = globals()["__hne"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hne, types.Function(_typing___hne))


@register
class _typing___hle(ConcreteTemplate):
    key = globals()["__hle"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hle, types.Function(_typing___hle))


@register
class _typing___hge(ConcreteTemplate):
    key = globals()["__hge"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hge, types.Function(_typing___hge))


@register
class _typing___hlt(ConcreteTemplate):
    key = globals()["__hlt"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hlt, types.Function(_typing___hlt))


@register
class _typing___hgt(ConcreteTemplate):
    key = globals()["__hgt"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hgt, types.Function(_typing___hgt))


@register
class _typing___hequ(ConcreteTemplate):
    key = globals()["__hequ"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hequ, types.Function(_typing___hequ))


@register
class _typing___hneu(ConcreteTemplate):
    key = globals()["__hneu"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hneu, types.Function(_typing___hneu))


@register
class _typing___hleu(ConcreteTemplate):
    key = globals()["__hleu"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hleu, types.Function(_typing___hleu))


@register
class _typing___hgeu(ConcreteTemplate):
    key = globals()["__hgeu"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hgeu, types.Function(_typing___hgeu))


@register
class _typing___hltu(ConcreteTemplate):
    key = globals()["__hltu"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hltu, types.Function(_typing___hltu))


@register
class _typing___hgtu(ConcreteTemplate):
    key = globals()["__hgtu"]
    cases = [signature(bool_, _type___half, _type___half)]


register_global(__hgtu, types.Function(_typing___hgtu))


@register
class _typing___hisnan(ConcreteTemplate):
    key = globals()["__hisnan"]
    cases = [signature(bool_, _type___half)]


register_global(__hisnan, types.Function(_typing___hisnan))


@register
class _typing___hmax_nan(ConcreteTemplate):
    key = globals()["__hmax_nan"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmax_nan, types.Function(_typing___hmax_nan))


@register
class _typing___hmin_nan(ConcreteTemplate):
    key = globals()["__hmin_nan"]
    cases = [signature(_type___half, _type___half, _type___half)]


register_global(__hmin_nan, types.Function(_typing___hmin_nan))


@register
class _typing___hfma_relu(ConcreteTemplate):
    key = globals()["__hfma_relu"]
    cases = [signature(_type___half, _type___half, _type___half, _type___half)]


register_global(__hfma_relu, types.Function(_typing___hfma_relu))


@register
class _typing_hsqrt(ConcreteTemplate):
    key = globals()["hsqrt"]
    cases = [signature(_type___half, _type___half)]


register_global(hsqrt, types.Function(_typing_hsqrt))


@register
class _typing_hrsqrt(ConcreteTemplate):
    key = globals()["hrsqrt"]
    cases = [signature(_type___half, _type___half)]


register_global(hrsqrt, types.Function(_typing_hrsqrt))


@register
class _typing_hrcp(ConcreteTemplate):
    key = globals()["hrcp"]
    cases = [signature(_type___half, _type___half)]


register_global(hrcp, types.Function(_typing_hrcp))


@register
class _typing_hlog(ConcreteTemplate):
    key = globals()["hlog"]
    cases = [signature(_type___half, _type___half)]


register_global(hlog, types.Function(_typing_hlog))


@register
class _typing_hlog2(ConcreteTemplate):
    key = globals()["hlog2"]
    cases = [signature(_type___half, _type___half)]


register_global(hlog2, types.Function(_typing_hlog2))


@register
class _typing_hlog10(ConcreteTemplate):
    key = globals()["hlog10"]
    cases = [signature(_type___half, _type___half)]


register_global(hlog10, types.Function(_typing_hlog10))


@register
class _typing_hexp(ConcreteTemplate):
    key = globals()["hexp"]
    cases = [signature(_type___half, _type___half)]


register_global(hexp, types.Function(_typing_hexp))


@register
class _typing_htanh_approx(ConcreteTemplate):
    key = globals()["htanh_approx"]
    cases = [signature(_type___half, _type___half)]


register_global(htanh_approx, types.Function(_typing_htanh_approx))


@register
class _typing_htanh(ConcreteTemplate):
    key = globals()["htanh"]
    cases = [signature(_type___half, _type___half)]


register_global(htanh, types.Function(_typing_htanh))


@register
class _typing_hexp2(ConcreteTemplate):
    key = globals()["hexp2"]
    cases = [signature(_type___half, _type___half)]


register_global(hexp2, types.Function(_typing_hexp2))


@register
class _typing_hexp10(ConcreteTemplate):
    key = globals()["hexp10"]
    cases = [signature(_type___half, _type___half)]


register_global(hexp10, types.Function(_typing_hexp10))


@register
class _typing_hcos(ConcreteTemplate):
    key = globals()["hcos"]
    cases = [signature(_type___half, _type___half)]


register_global(hcos, types.Function(_typing_hcos))


@register
class _typing_hsin(ConcreteTemplate):
    key = globals()["hsin"]
    cases = [signature(_type___half, _type___half)]


register_global(hsin, types.Function(_typing_hsin))


@register
class _typing_atomicAdd(ConcreteTemplate):
    key = globals()["atomicAdd"]
    cases = [signature(_type___half, CPointer(_type___half), _type___half)]


register_global(atomicAdd, types.Function(_typing_atomicAdd))


def float16_float_ty_constraint(bitwidth):
    typemap = {32: ("f32", "f"), 64: ("f64", "d")}

    try:
        return typemap[bitwidth]
    except KeyError:
        msg = f"Conversion between float16 and float{bitwidth} unsupported"
        raise errors.CudaLoweringError(msg)


@lower_cast(types.float16, types.Float)
def float16_to_float_cast(context, builder, fromty, toty, val):
    if fromty.bitwidth == toty.bitwidth:
        return val

    ty, constraint = float16_float_ty_constraint(toty.bitwidth)

    fnty = ir.FunctionType(context.get_value_type(toty), [ir.IntType(16)])
    asm = ir.InlineAsm(fnty, f"cvt.{ty}.f16 $0, $1;", f"={constraint},h")
    return builder.call(asm, [val])


@lower_cast(types.Float, types.float16)
def float_to_float16_cast(context, builder, fromty, toty, val):
    if fromty.bitwidth == toty.bitwidth:
        return val

    ty, constraint = float16_float_ty_constraint(fromty.bitwidth)

    fnty = ir.FunctionType(ir.IntType(16), [context.get_value_type(fromty)])
    asm = ir.InlineAsm(fnty, f"cvt.rn.f16.{ty} $0, $1;", f"=h,{constraint}")
    return builder.call(asm, [val])


def float16_int_constraint(bitwidth):
    typemap = {8: "c", 16: "h", 32: "r", 64: "l"}

    try:
        return typemap[bitwidth]
    except KeyError:
        msg = f"Conversion between float16 and int{bitwidth} unsupported"
        raise errors.CudaLoweringError(msg)


@lower_cast(types.float16, types.Integer)
def float16_to_integer_cast(context, builder, fromty, toty, val):
    bitwidth = toty.bitwidth
    constraint = float16_int_constraint(bitwidth)
    signedness = "s" if toty.signed else "u"

    fnty = ir.FunctionType(context.get_value_type(toty), [ir.IntType(16)])
    asm = ir.InlineAsm(
        fnty, f"cvt.rni.{signedness}{bitwidth}.f16 $0, $1;", f"={constraint},h"
    )
    return builder.call(asm, [val])


@lower_cast(types.Integer, types.float16)
@lower_cast(types.IntegerLiteral, types.float16)
def integer_to_float16_cast(context, builder, fromty, toty, val):
    bitwidth = fromty.bitwidth
    constraint = float16_int_constraint(bitwidth)
    signedness = "s" if fromty.signed else "u"

    fnty = ir.FunctionType(ir.IntType(16), [context.get_value_type(fromty)])
    asm = ir.InlineAsm(
        fnty, f"cvt.rn.f16.{signedness}{bitwidth} $0, $1;", f"=h,{constraint}"
    )
    return builder.call(asm, [val])


def _genfp16_unary_operator(l_key):
    @register_global(l_key)
    class Cuda_fp16_unary(AbstractTemplate):
        key = l_key

        def generic(self, args, kws):
            assert not kws
            if len(args) == 1 and args[0] == types.float16:
                return signature(types.float16, types.float16)

    return Cuda_fp16_unary


def _fp16_binary_operator(l_key, retty):
    @register_global(l_key)
    class Cuda_fp16_operator(AbstractTemplate):
        key = l_key

        def generic(self, args, kws):
            assert not kws

            if len(args) == 2 and (
                args[0] == types.float16 or args[1] == types.float16
            ):
                if args[0] == types.float16:
                    convertible = self.context.can_convert(args[1], args[0])
                else:
                    convertible = self.context.can_convert(args[0], args[1])
                # We allow three cases here:
                #
                # 1. fp16 to fp16 - Conversion.exact
                # 2. fp16 to other types fp16 can be promoted to
                #  - Conversion.promote
                # 3. fp16 to int8 (safe conversion) -
                #  - Conversion.safe

                if (
                    (convertible == numba.cuda.typeconv.Conversion.exact)
                    or (convertible == numba.cuda.typeconv.Conversion.promote)
                    or (convertible == numba.cuda.typeconv.Conversion.safe)
                ):
                    return signature(retty, types.float16, types.float16)

    return Cuda_fp16_operator


def _genfp16_comparison_operator(op):
    return _fp16_binary_operator(op, types.b1)


def _genfp16_binary_operator(op):
    return _fp16_binary_operator(op, types.float16)


_genfp16_unary_operator(abs)
_genfp16_unary_operator(operator.abs)
_genfp16_unary_operator(operator.neg)
_genfp16_unary_operator(operator.pos)
_genfp16_binary_operator(operator.add)
_genfp16_binary_operator(operator.iadd)
_genfp16_binary_operator(operator.sub)
_genfp16_binary_operator(operator.isub)
_genfp16_binary_operator(operator.mul)
_genfp16_binary_operator(operator.imul)
_genfp16_binary_operator(operator.truediv)
_genfp16_binary_operator(operator.itruediv)
_genfp16_comparison_operator(operator.eq)
_genfp16_comparison_operator(operator.ne)
_genfp16_comparison_operator(operator.ge)
_genfp16_comparison_operator(operator.gt)
_genfp16_comparison_operator(operator.le)
_genfp16_comparison_operator(operator.lt)


# Aliases:
__half_raw = unnamed1362071
__nv_half_raw = unnamed1362071
__half2_raw = unnamed1362180
__nv_half2_raw = unnamed1362180
half = __half
__nv_half = __half
nv_half = __half


# Symbols:


_NBTYPE_SYMBOLS = [
    "_type_unnamed1362071",
    "_type_unnamed1362180",
    "_type___half",
]


_RECORD_SYMBOLS = ["unnamed1362071", "unnamed1362180", "__half"]


_FUNCTION_SYMBOLS = [
    "__double2half",
    "__float2half",
    "__float2half_rn",
    "__float2half_rz",
    "__float2half_rd",
    "__float2half_ru",
    "__half2float",
    "__half2char_rz",
    "__half2uchar_rz",
    "__half2short_rz",
    "__half2ushort_rz",
    "__half2int_rz",
    "__half2uint_rz",
    "__half2ll_rz",
    "__half2ull_rz",
    "__half2int_rn",
    "__half2int_rd",
    "__half2int_ru",
    "__int2half_rn",
    "__int2half_rz",
    "__int2half_rd",
    "__int2half_ru",
    "__half2short_rn",
    "__half2short_rd",
    "__half2short_ru",
    "__short2half_rn",
    "__short2half_rz",
    "__short2half_rd",
    "__short2half_ru",
    "__half2uint_rn",
    "__half2uint_rd",
    "__half2uint_ru",
    "__uint2half_rn",
    "__uint2half_rz",
    "__uint2half_rd",
    "__uint2half_ru",
    "__half2ushort_rn",
    "__half2ushort_rd",
    "__half2ushort_ru",
    "__ushort2half_rn",
    "__ushort2half_rz",
    "__ushort2half_rd",
    "__ushort2half_ru",
    "__half2ull_rn",
    "__half2ull_rd",
    "__half2ull_ru",
    "__ull2half_rn",
    "__ull2half_rz",
    "__ull2half_rd",
    "__ull2half_ru",
    "__half2ll_rn",
    "__half2ll_rd",
    "__half2ll_ru",
    "__ll2half_rn",
    "__ll2half_rz",
    "__ll2half_rd",
    "__ll2half_ru",
    "htrunc",
    "hceil",
    "hfloor",
    "hrint",
    "__hisinf",
    "__half_as_short",
    "__half_as_ushort",
    "__short_as_half",
    "__ushort_as_half",
    "__hmax",
    "__hmin",
    "__shfl_sync",
    "__shfl_up_sync",
    "__shfl_down_sync",
    "__shfl_xor_sync",
    "__ldg",
    "__ldcg",
    "__ldca",
    "__ldcs",
    "__ldlu",
    "__ldcv",
    "__stwb",
    "__stcg",
    "__stcs",
    "__stwt",
    "__habs",
    "__hadd",
    "__hsub",
    "__hmul",
    "__hadd_rn",
    "__hsub_rn",
    "__hmul_rn",
    "__hdiv",
    "__hadd_sat",
    "__hsub_sat",
    "__hmul_sat",
    "__hfma",
    "__hfma_sat",
    "__hneg",
    "__heq",
    "__hne",
    "__hle",
    "__hge",
    "__hlt",
    "__hgt",
    "__hequ",
    "__hneu",
    "__hleu",
    "__hgeu",
    "__hltu",
    "__hgtu",
    "__hisnan",
    "__hmax_nan",
    "__hmin_nan",
    "__hfma_relu",
    "hsqrt",
    "hrsqrt",
    "hrcp",
    "hlog",
    "hlog2",
    "hlog10",
    "hexp",
    "htanh_approx",
    "htanh",
    "hexp2",
    "hexp10",
    "hcos",
    "hsin",
    "atomicAdd",
    "operator+",
    "operator-",
    "operator*",
    "operator/",
    "operator+=",
    "operator-=",
    "operator*=",
    "operator/=",
    "operator+",
    "operator-",
    "operator==",
    "operator!=",
    "operator>",
    "operator<",
    "operator>=",
    "operator<=",
]


__all__ = _NBTYPE_SYMBOLS + _RECORD_SYMBOLS + _FUNCTION_SYMBOLS
