/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.rendering;

import androidx.compose.runtime.internal.StabilityInferred;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.markdown.rendering.DefaultImageSourceResolver;

@ExperimentalJewelApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bg\u0018\u0000 \u00052\u00020\u0001:\u0002\u0005\u0006J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver;", "", "resolve", "", "rawDestination", "Companion", "ResolveCapability", "intellij.platform.jewel.markdown.core"})
@ApiStatus.Experimental
public interface ImageSourceResolver {
    @NotNull
    public static final Companion Companion = org.jetbrains.jewel.markdown.rendering.ImageSourceResolver$Companion.$$INSTANCE;

    @Nullable
    public String resolve(@NotNull String var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$Companion;", "", "<init>", "()V", "defaultCapabilities", "", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "getDefaultCapabilities$intellij_platform_jewel_markdown_core", "()Ljava/util/Set;", "create", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver;", "rootDir", "Ljava/nio/file/Path;", "logResolveFailure", "", "resolveCapabilities", "intellij.platform.jewel.markdown.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @VisibleForTesting
        @NotNull
        private static final Set<ResolveCapability> defaultCapabilities;

        private Companion() {
        }

        @NotNull
        public final Set<ResolveCapability> getDefaultCapabilities$intellij_platform_jewel_markdown_core() {
            return defaultCapabilities;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageSourceResolver create(@NotNull Path rootDir, boolean logResolveFailure) {
            void $this$create_u24lambda_u240;
            Set set;
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Set set2 = set = SetsKt.createSetBuilder();
            Companion companion = this;
            boolean bl = false;
            $this$create_u24lambda_u240.addAll((Collection)defaultCapabilities);
            $this$create_u24lambda_u240.add(new ResolveCapability.RelativePath(rootDir));
            return companion.create(SetsKt.build((Set)set), logResolveFailure);
        }

        @NotNull
        public final ImageSourceResolver create(@NotNull Set<? extends ResolveCapability> resolveCapabilities, boolean logResolveFailure) {
            Intrinsics.checkNotNullParameter(resolveCapabilities, (String)"resolveCapabilities");
            return new DefaultImageSourceResolver(resolveCapabilities, logResolveFailure);
        }

        public static /* synthetic */ ImageSourceResolver create$default(Companion companion, Set set, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                set = defaultCapabilities;
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.create(set, bl);
        }

        static {
            $$INSTANCE = new Companion();
            Object[] objectArray = new ResolveCapability[]{ResolveCapability.PlainUri.INSTANCE, new ResolveCapability.RelativePathInResources(null, 1, null), ResolveCapability.AbsolutePath.INSTANCE};
            defaultCapabilities = SetsKt.setOf((Object[])objectArray);
        }
    }

    @ExperimentalJewelApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u0082\u0001\u0004\t\n\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "", "resolve", "", "rawDestination", "PlainUri", "RelativePathInResources", "AbsolutePath", "RelativePath", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$AbsolutePath;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$PlainUri;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$RelativePath;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$RelativePathInResources;", "intellij.platform.jewel.markdown.core"})
    @ApiStatus.Experimental
    public static sealed interface ResolveCapability {
        @Nullable
        public String resolve(@NotNull String var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$AbsolutePath;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "<init>", "()V", "resolve", "", "rawDestination", "intellij.platform.jewel.markdown.core"})
        @StabilityInferred(parameters=1)
        public static final class AbsolutePath
        implements ResolveCapability {
            @NotNull
            public static final AbsolutePath INSTANCE = new AbsolutePath();
            public static final int $stable;

            private AbsolutePath() {
            }

            @Override
            @Nullable
            public String resolve(@NotNull String rawDestination) {
                Intrinsics.checkNotNullParameter((Object)rawDestination, (String)"rawDestination");
                Path rawPath = Path.of(rawDestination, new String[0]);
                if (rawPath.isAbsolute()) {
                    return rawDestination;
                }
                return null;
            }
        }

        @ExperimentalJewelApi
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$PlainUri;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "<init>", "()V", "toString", "", "resolve", "rawDestination", "intellij.platform.jewel.markdown.core"})
        @ApiStatus.Experimental
        @StabilityInferred(parameters=1)
        @SourceDebugExtension(value={"SMAP\nImageSourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSourceResolver.kt\norg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$PlainUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
        public static final class PlainUri
        implements ResolveCapability {
            @NotNull
            public static final PlainUri INSTANCE = new PlainUri();
            public static final int $stable;

            private PlainUri() {
            }

            @NotNull
            public String toString() {
                return "PlainUri";
            }

            @Override
            @Nullable
            public String resolve(@NotNull String rawDestination) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)rawDestination, (String)"rawDestination");
                Object object2 = this;
                try {
                    PlainUri $this$resolve_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)URI.create(rawDestination));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                URI uRI = (URI)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (uRI == null) {
                    return null;
                }
                URI uri = uRI;
                return uri.isAbsolute() ? rawDestination : null;
            }
        }

        @ExperimentalJewelApi
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$RelativePath;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "rootDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "resolve", "", "rawDestination", "toString", "intellij.platform.jewel.markdown.core"})
        @ApiStatus.Experimental
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nImageSourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSourceResolver.kt\norg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$RelativePath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
        public static final class RelativePath
        implements ResolveCapability {
            @NotNull
            private final Path rootDir;
            public static final int $stable = 8;

            public RelativePath(@NotNull Path rootDir) {
                Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
                this.rootDir = rootDir;
            }

            @Override
            @Nullable
            public String resolve(@NotNull String rawDestination) {
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter((Object)rawDestination, (String)"rawDestination");
                Path rawPath = Path.of(rawDestination, new String[0]);
                if (rawPath.isAbsolute()) {
                    return null;
                }
                Object object3 = this;
                try {
                    RelativePath $this$resolve_u24lambda_u240 = object3;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)$this$resolve_u24lambda_u240.rootDir.toAbsolutePath().normalize());
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object3 = object2;
                Path path = (Path)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (path == null) {
                    return null;
                }
                Path normalizedRoot = path;
                object2 = this;
                try {
                    RelativePath $this$resolve_u24lambda_u241 = (RelativePath)object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)normalizedRoot.resolve(rawPath).normalize());
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                Path path2 = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (path2 == null) {
                    return null;
                }
                Path resolved = path2;
                return ((Object)resolved).toString();
            }

            @NotNull
            public String toString() {
                return "RelativePath(rootDir=" + this.rootDir + ")";
            }
        }

        @ExperimentalJewelApi
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability$RelativePathInResources;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver$ResolveCapability;", "resourceClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "toString", "", "resolve", "rawDestination", "intellij.platform.jewel.markdown.core"})
        @ApiStatus.Experimental
        @StabilityInferred(parameters=0)
        public static final class RelativePathInResources
        implements ResolveCapability {
            @Nullable
            private final Class<?> resourceClass;
            public static final int $stable = 8;

            public RelativePathInResources(@Nullable Class<?> resourceClass) {
                this.resourceClass = resourceClass;
            }

            public /* synthetic */ RelativePathInResources(Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    clazz = null;
                }
                this(clazz);
            }

            @NotNull
            public String toString() {
                return "RelativePathInResources";
            }

            @Override
            @Nullable
            public String resolve(@NotNull String rawDestination) {
                Intrinsics.checkNotNullParameter((Object)rawDestination, (String)"rawDestination");
                Class<?> clazz = this.resourceClass;
                if (clazz == null) {
                    clazz = this.getClass();
                }
                URL uRL = clazz.getClassLoader().getResource(StringsKt.removePrefix((String)rawDestination, (CharSequence)"/"));
                return uRL != null ? uRL.toExternalForm() : null;
            }

            public RelativePathInResources() {
                this(null, 1, null);
            }
        }
    }
}

