/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.DatatypeRepertoire;

class DatatypeInferrer {
    private final DatatypeRepertoire.Type[] possibleTypes;
    private int nTypes;
    private int typicalMask = 0;
    private final String uri = datatypeRepertoire.getUri();
    private boolean allWhiteSpace = true;

    DatatypeInferrer(DatatypeRepertoire datatypeRepertoire, String string) {
        this.possibleTypes = new DatatypeRepertoire.Type[datatypeRepertoire.size()];
        int n = 0;
        while (n < this.possibleTypes.length) {
            this.possibleTypes[n] = datatypeRepertoire.get(n);
            ++n;
        }
        this.nTypes = this.possibleTypes.length;
        this.addValue(string);
    }

    public void addValue(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nTypes) {
            if (!this.possibleTypes[n2].matches(string)) {
                ++n;
            } else {
                if (this.possibleTypes[n2].isTypical(string)) {
                    this.typicalMask |= 1 << this.possibleTypes[n2].getIndex();
                }
                if (n > 0) {
                    this.possibleTypes[n2 - n] = this.possibleTypes[n2];
                    this.possibleTypes[n2] = null;
                }
            }
            ++n2;
        }
        this.nTypes -= n;
        if (!DatatypeInferrer.isWhiteSpace(string)) {
            this.allWhiteSpace = false;
        }
    }

    static boolean isWhiteSpace(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public Name getTypeName() {
        int n = 0;
        while (n < this.nTypes) {
            if ((1 << this.possibleTypes[n].getIndex() & this.typicalMask) != 0) {
                return new Name(this.uri, this.possibleTypes[n].getName());
            }
            ++n;
        }
        return null;
    }

    public boolean isAllWhiteSpace() {
        return this.allWhiteSpace;
    }
}

