/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicDelegator;
import net.sourceforge.plantuml.klimt.shape.ULine;

public class UGraphicInterceptorOneSwimlane
extends UGraphicDelegator {
    private final Swimlane swimlane;
    private final List<Swimlane> orderedList;

    public UGraphicInterceptorOneSwimlane(UGraphic ug, Swimlane swimlane, List<Swimlane> orderedList) {
        super(ug);
        this.swimlane = swimlane;
        this.orderedList = orderedList;
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof Ftile) {
            Ftile tile = (Ftile)shape;
            Set<Swimlane> swimlanes = tile.getSwimlanes();
            boolean contained = swimlanes.contains(this.swimlane);
            if (contained) {
                tile.drawU(this);
            }
        } else if (shape instanceof Gtile) {
            Gtile tile = (Gtile)shape;
            Set<Swimlane> swimlanes = tile.getSwimlanes();
            boolean contained = swimlanes.contains(this.swimlane);
            if (contained) {
                tile.drawU(this);
            }
        } else if (shape instanceof GConnection) {
            GConnection connection = (GConnection)shape;
            List<GPoint> hooks = connection.getHooks();
            GPoint point0 = hooks.get(0);
            GPoint point1 = hooks.get(1);
            if (point0.match(this.swimlane) && point1.match(this.swimlane)) {
                connection.drawU(this);
            }
        } else if (shape instanceof Connection) {
            boolean contained2;
            Connection connection = (Connection)shape;
            Ftile tile1 = connection.getFtile1();
            Ftile tile2 = connection.getFtile2();
            boolean contained1 = tile1 == null || tile1.getSwimlaneOut() == null || tile1.getSwimlaneOut() == this.swimlane;
            boolean bl = contained2 = tile2 == null || tile2.getSwimlaneIn() == null || tile2.getSwimlaneIn() == this.swimlane;
            if (contained1 && contained2) {
                connection.drawU(this);
            }
        } else {
            this.getUg().draw(shape);
        }
    }

    private void drawGoto() {
        UGraphic ugGoto = this.getUg().apply(HColors.GREEN).apply(HColors.GREEN.bg());
        ugGoto.draw(new ULine(100.0, 100.0));
    }

    @Override
    public UGraphic apply(UChange change) {
        return new UGraphicInterceptorOneSwimlane(this.getUg().apply(change), this.swimlane, this.orderedList);
    }

    public final Swimlane getSwimlane() {
        return this.swimlane;
    }

    public final List<Swimlane> getOrderedListOfAllSwimlanes() {
        return Collections.unmodifiableList(this.orderedList);
    }
}

