/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class YearWithCommasCompiledPattern
extends CompiledPattern {
    public YearWithCommasCompiledPattern(Set<PatternModifier> modifiers) {
        super(ChronoUnitEnum.YEARS, modifiers);
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        String formattedValue = String.format(Locale.ROOT, "%04d", dateTime.getYear());
        formattedValue = formattedValue.substring(0, formattedValue.length() - 3) + "," + formattedValue.substring(formattedValue.length() - 3);
        if (this.modifiers.contains((Object)PatternModifier.TH_UPPER) || this.modifiers.contains((Object)PatternModifier.TH_LOWER)) {
            String suffix;
            switch (formattedValue.charAt(formattedValue.length() - 1)) {
                case '1': {
                    suffix = "st";
                    break;
                }
                case '2': {
                    suffix = "nd";
                    break;
                }
                case '\u0003': {
                    suffix = "rd";
                    break;
                }
                default: {
                    suffix = "th";
                }
            }
            if (this.modifiers.contains((Object)PatternModifier.TH_UPPER)) {
                return formattedValue + suffix.toUpperCase(Locale.ROOT);
            }
            return formattedValue + suffix;
        }
        return formattedValue;
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        int endIndex;
        String inputTrimmed = input.substring(inputPosition.getIndex());
        int commaIndex = inputTrimmed.indexOf(44);
        if (commaIndex <= 0 || commaIndex > 3) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        String thousands = inputTrimmed.substring(0, commaIndex);
        if (enforceLength) {
            if (inputPosition.getIndex() + commaIndex + 4 > input.length()) {
                throw new ParseException("Unable to parse value", inputPosition.getIndex());
            }
            endIndex = commaIndex + 4;
        } else {
            for (endIndex = commaIndex + 1; endIndex < inputTrimmed.length() && Character.isDigit(inputTrimmed.charAt(endIndex)); ++endIndex) {
            }
            if (endIndex == commaIndex + 1 || endIndex > commaIndex + 4) {
                inputPosition.setErrorIndex(inputPosition.getIndex());
                throw new ParseException("Unable to parse value", inputPosition.getIndex());
            }
        }
        String remainingDigits = inputTrimmed.substring(commaIndex + 1, endIndex);
        if (this.modifiers.contains((Object)PatternModifier.TH_UPPER) || this.modifiers.contains((Object)PatternModifier.TH_LOWER)) {
            if (endIndex < inputTrimmed.length() - 1) {
                endIndex += 2;
            } else if (endIndex < inputTrimmed.length()) {
                ++endIndex;
            }
        }
        inputPosition.setIndex(inputPosition.getIndex() + endIndex);
        return Integer.parseInt(thousands) * 1000 + Integer.parseInt(remainingDigits);
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 5;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

