/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.bouncycastle.crypto.Digest;
import org.cryptacular.CryptUtil;
import org.cryptacular.generator.AbstractOTPGenerator;
import org.cryptacular.spec.DigestSpec;
import org.cryptacular.spec.Spec;

public class TOTPGenerator
extends AbstractOTPGenerator {
    private static final Instant DEFAULT_START_TIME = Instant.EPOCH;
    private static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Spec<Digest> digestSpecification;
    private final Instant startTime;
    private final Duration timeStep;
    private Instant currentTime;

    public TOTPGenerator() {
        this(new DigestSpec("SHA1"), 6, DEFAULT_START_TIME, DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(int numberOfDigits) {
        this(new DigestSpec("SHA1"), numberOfDigits, DEFAULT_START_TIME, DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(Spec<Digest> specification) {
        this(specification, 6, DEFAULT_START_TIME, DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(Spec<Digest> specification, int numberOfDigits) {
        this(specification, numberOfDigits, DEFAULT_START_TIME, DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(Spec<Digest> specification, int numberOfDigits, Instant startTime) {
        this(specification, numberOfDigits, startTime, DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(Spec<Digest> specification, int numberOfDigits, Duration timeStep) {
        this(specification, numberOfDigits, DEFAULT_START_TIME, timeStep);
    }

    public TOTPGenerator(Spec<Digest> specification, int numberOfDigits, Instant startTime, Duration timeStep) {
        super(numberOfDigits);
        CryptUtil.assertNotNullArg(specification, "Specification cannot be null");
        CryptUtil.assertNotNullArg(startTime, "Start time cannot be null");
        CryptUtil.assertNotNullArg(timeStep, "Time step cannot be null");
        if (!("SHA1".equalsIgnoreCase(specification.getAlgorithm()) || "SHA-1".equalsIgnoreCase(specification.getAlgorithm()) || "SHA256".equalsIgnoreCase(specification.getAlgorithm()) || "SHA-256".equalsIgnoreCase(specification.getAlgorithm()) || "SHA512".equalsIgnoreCase(specification.getAlgorithm()) || "SHA-512".equalsIgnoreCase(specification.getAlgorithm()))) {
            throw new IllegalArgumentException("Unsupported digest algorithm " + specification);
        }
        this.digestSpecification = specification;
        this.startTime = startTime.truncatedTo(ChronoUnit.SECONDS);
        this.timeStep = timeStep;
    }

    public Spec<Digest> getDigestSpecification() {
        return this.digestSpecification;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }

    public int generate(byte[] key) {
        CryptUtil.assertNotNullArg(key, "Key cannot be null");
        long t = (this.currentTime().getEpochSecond() - this.startTime.getEpochSecond()) / this.timeStep.getSeconds();
        return this.generateInternal(key, t);
    }

    @Override
    protected Digest getDigest() {
        return this.digestSpecification.newInstance();
    }

    protected void setCurrentTime(Instant time) {
        this.currentTime = time.truncatedTo(ChronoUnit.SECONDS);
    }

    protected Instant currentTime() {
        if (this.currentTime != null) {
            return this.currentTime;
        }
        return Instant.now().truncatedTo(ChronoUnit.SECONDS);
    }
}

