/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public final class RolesInjector {
    private final Logger log = LogManager.getLogger(RolesInjector.class);
    private final AuditLog auditLog;

    public RolesInjector(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public Set<String> injectUserAndRoles(ThreadPool threadPool) {
        String injectedUserAndRoles = (String)threadPool.getThreadContext().getTransient("opendistro_security_injected_roles");
        if (injectedUserAndRoles == null) {
            return null;
        }
        this.log.debug("Injected roles: {}", (Object)injectedUserAndRoles);
        String[] strs = injectedUserAndRoles.split("\\|");
        if (strs.length == 0) {
            this.log.error("Roles injected string malformed, could not extract parts. User string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)StringUtils.trim((String)strs[0]))) {
            this.log.error("Username must be provided, injected string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        if (strs.length < 2 || StringUtils.isEmpty((CharSequence)StringUtils.trim((String)strs[0]))) {
            this.log.error("Roles must be provided, injected string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        ImmutableSet roles = ImmutableSet.copyOf((Object[])strs[1].split(","));
        Map customAttributes = (Map)threadPool.getThreadContext().getTransient("injected_user_custom_attributes");
        User user = new User(strs[0]).withSecurityRoles((Collection<String>)roles).withAttributes(customAttributes);
        this.addUser(user, threadPool);
        return roles;
    }

    private void addUser(User user, ThreadPool threadPool) {
        ThreadContext ctx = threadPool.getThreadContext();
        if (ctx.getTransient("_opendistro_security_user") == null) {
            ctx.putTransient("_opendistro_security_user", (Object)user);
        }
        if (ctx.getPersistent("_opendistro_security_authenticated_user") == null) {
            ctx.putPersistent("_opendistro_security_authenticated_user", (Object)new UserSubjectImpl(threadPool, user));
        }
    }
}

