/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.termvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.termvectors.FieldStatistics;
import org.opensearch.client.opensearch.core.termvectors.Term;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermVector
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TermVector> {
    @Nullable
    private final FieldStatistics fieldStatistics;
    @Nonnull
    private final Map<String, Term> terms;
    public static final JsonpDeserializer<TermVector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermVector::setupTermVectorDeserializer);

    private TermVector(Builder builder) {
        this.fieldStatistics = builder.fieldStatistics;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static TermVector of(Function<Builder, ObjectBuilder<TermVector>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldStatistics fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nonnull
    public final Map<String, Term> terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fieldStatistics != null) {
            generator.writeKey("field_statistics");
            this.fieldStatistics.serialize(generator, mapper);
        }
        generator.writeKey("terms");
        generator.writeStartObject();
        for (Map.Entry<String, Term> item0 : this.terms.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermVectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldStatistics, FieldStatistics._DESERIALIZER, "field_statistics");
        op.add(Builder::terms, JsonpDeserializer.stringMapDeserializer(Term._DESERIALIZER), "terms");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.fieldStatistics);
        result = 31 * result + this.terms.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermVector other = (TermVector)o;
        return Objects.equals(this.fieldStatistics, other.fieldStatistics) && this.terms.equals(other.terms);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TermVector> {
        @Nullable
        private FieldStatistics fieldStatistics;
        private Map<String, Term> terms;

        public Builder() {
        }

        private Builder(TermVector o) {
            this.fieldStatistics = o.fieldStatistics;
            this.terms = Builder._mapCopy(o.terms);
        }

        private Builder(Builder o) {
            this.fieldStatistics = o.fieldStatistics;
            this.terms = Builder._mapCopy(o.terms);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder fieldStatistics(@Nullable FieldStatistics value) {
            this.fieldStatistics = value;
            return this;
        }

        @Nonnull
        public final Builder fieldStatistics(Function<FieldStatistics.Builder, ObjectBuilder<FieldStatistics>> fn) {
            return this.fieldStatistics(fn.apply(new FieldStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder terms(Map<String, Term> map) {
            this.terms = Builder._mapPutAll(this.terms, map);
            return this;
        }

        @Nonnull
        public final Builder terms(String key, Term value) {
            this.terms = Builder._mapPut(this.terms, key, value);
            return this;
        }

        @Nonnull
        public final Builder terms(String key, Function<Term.Builder, ObjectBuilder<Term>> fn) {
            return this.terms(key, fn.apply(new Term.Builder()).build());
        }

        @Override
        @Nonnull
        public TermVector build() {
            this._checkSingleUse();
            return new TermVector(this);
        }
    }
}

