/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.env.Environment;
import org.opensearch.ml.action.stats.MLStatsNodeRequest;
import org.opensearch.ml.action.stats.MLStatsNodeResponse;
import org.opensearch.ml.action.stats.MLStatsNodesAction;
import org.opensearch.ml.action.stats.MLStatsNodesRequest;
import org.opensearch.ml.action.stats.MLStatsNodesResponse;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionStats;
import org.opensearch.ml.stats.MLAlgoStats;
import org.opensearch.ml.stats.MLModelStats;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStatLevel;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.stats.MLStatsInput;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class MLStatsNodesTransportAction
extends TransportNodesAction<MLStatsNodesRequest, MLStatsNodesResponse, MLStatsNodeRequest, MLStatsNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLStatsNodesTransportAction.class);
    private MLStats mlStats;
    private final JvmService jvmService;
    private final Client client;
    private final MLModelManager mlModelManager;

    @Inject
    public MLStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLStats mlStats, Environment environment, Client client, MLModelManager mlModelManager) {
        super(MLStatsNodesAction.NAME, threadPool, clusterService, transportService, actionFilters, MLStatsNodesRequest::new, MLStatsNodeRequest::new, "management", MLStatsNodeResponse.class);
        this.mlStats = mlStats;
        this.jvmService = new JvmService(environment.settings());
        this.client = client;
        this.mlModelManager = mlModelManager;
    }

    protected MLStatsNodesResponse newResponse(MLStatsNodesRequest request, List<MLStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLStatsNodeRequest newNodeRequest(MLStatsNodesRequest request) {
        return new MLStatsNodeRequest(request);
    }

    protected MLStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLStatsNodeResponse(in);
    }

    protected MLStatsNodeResponse nodeOperation(MLStatsNodeRequest request) {
        return this.createMLStatsNodeResponse(request.getMlStatsNodesRequest());
    }

    private MLStatsNodeResponse createMLStatsNodeResponse(MLStatsNodesRequest request) {
        Map<MLNodeLevelStat, Object> nodeLevelStats = this.getNodeLevelStats(request.getMlStatsInput());
        Map<FunctionName, MLAlgoStats> algoStats = this.getAlgorithmStats(request.getMlStatsInput());
        Map<String, MLModelStats> modelStats = this.getModelStats(request);
        return new MLStatsNodeResponse(this.clusterService.localNode(), nodeLevelStats, algoStats, modelStats);
    }

    private Map<MLNodeLevelStat, Object> getNodeLevelStats(MLStatsInput input) {
        HashMap<MLNodeLevelStat, Object> stats = new HashMap<MLNodeLevelStat, Object>();
        if (input.getTargetStatLevels().contains((Object)MLStatLevel.NODE)) {
            if (input.retrieveStat(MLNodeLevelStat.ML_JVM_HEAP_USAGE)) {
                long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
                stats.put(MLNodeLevelStat.ML_JVM_HEAP_USAGE, heapUsedPercent);
            }
            this.mlStats.getNodeStats().forEach((statName, stat) -> {
                if (input.retrieveStat((Enum<?>)statName)) {
                    stats.put((MLNodeLevelStat)((Object)statName), stat.getValue());
                }
            });
        }
        return stats;
    }

    private Map<FunctionName, MLAlgoStats> getAlgorithmStats(MLStatsInput input) {
        HashMap<FunctionName, MLAlgoStats> stats = new HashMap<FunctionName, MLAlgoStats>();
        if (input.includeAlgoStats()) {
            for (FunctionName algo : this.mlStats.getAllAlgorithms()) {
                if (!input.retrieveStatsForAlgo(algo)) continue;
                Map<ActionName, MLActionStats> actionStats = this.collectActionStats(this.mlStats.getAlgorithmStats(algo), input);
                stats.put(algo, new MLAlgoStats(actionStats));
            }
        }
        return stats;
    }

    private Map<ActionName, MLActionStats> collectActionStats(Map<ActionName, MLActionStats> stats, MLStatsInput input) {
        HashMap<ActionName, MLActionStats> filteredStats = new HashMap<ActionName, MLActionStats>();
        stats.forEach((action, stat) -> {
            if (input.retrieveStatsForAction((ActionName)((Object)action))) {
                filteredStats.put((ActionName)((Object)action), (MLActionStats)stat);
            }
        });
        return filteredStats;
    }

    private Map<String, MLModelStats> getModelStats(MLStatsNodesRequest request) {
        HashMap<String, MLModelStats> stats = new HashMap<String, MLModelStats>();
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        Set hiddenModels = Optional.ofNullable(request.getHiddenModelIds()).orElse(Collections.emptySet());
        for (String modelId : this.mlStats.getAllModels()) {
            if (!isSuperAdmin && hiddenModels.contains(modelId) || !request.getMlStatsInput().retrieveStatsForModel(modelId)) continue;
            Map<ActionName, MLActionStats> actionStats = this.collectActionStats(this.mlStats.getModelStats(modelId), request.getMlStatsInput());
            boolean isHidden = hiddenModels.contains(modelId);
            stats.put(modelId, new MLModelStats(actionStats, isHidden));
        }
        return stats;
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

