/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.index.search.OpenSearchToParentBlockJoinQuery;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public abstract class BaseQueryFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(BaseQueryFactory.class);

    protected static Query getFilterQuery(CreateQueryRequest createQueryRequest) {
        Query filterQuery;
        if (!createQueryRequest.getFilter().isPresent()) {
            return null;
        }
        QueryShardContext queryShardContext = createQueryRequest.getContext().orElseThrow(() -> new RuntimeException("Shard context cannot be null"));
        log.debug(String.format("Creating query with filter for index [%s], field [%s]", createQueryRequest.getIndexName(), createQueryRequest.getFieldName()));
        LinkedList<ObjectMapper> nestedLevelStack = new LinkedList<ObjectMapper>();
        ObjectMapper objectMapper = null;
        if (queryShardContext.nestedScope() != null) {
            while ((objectMapper = queryShardContext.nestedScope().getObjectMapper()) != null) {
                nestedLevelStack.push(objectMapper);
                queryShardContext.nestedScope().previousLevel();
            }
        }
        try {
            filterQuery = createQueryRequest.getFilter().get().toQuery(queryShardContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create query with filter", e);
        }
        finally {
            while ((objectMapper = (ObjectMapper)nestedLevelStack.peek()) != null) {
                queryShardContext.nestedScope().nextLevel(objectMapper);
                nestedLevelStack.pop();
            }
        }
        if (filterQuery != null && queryShardContext.getParentFilter() != null) {
            OpenSearchToParentBlockJoinQuery toParentQuery;
            if (filterQuery instanceof OpenSearchToParentBlockJoinQuery && (toParentQuery = (OpenSearchToParentBlockJoinQuery)filterQuery).getPath() == null) {
                return toParentQuery.getChildQuery();
            }
            Query parentQuery = Queries.newNonNestedFilter();
            BitSetProducer parentFilter = queryShardContext.bitsetFilter(parentQuery);
            Object nonNestedFilterQuery = new NestedHelper(queryShardContext.getMapperService()).mightMatchNestedDocs(filterQuery) ? Queries.filtered((Query)filterQuery, (Query)parentQuery) : filterQuery;
            return new ToChildBlockJoinQuery(nonNestedFilterQuery, parentFilter);
        }
        return filterQuery;
    }

    public static class CreateQueryRequest {
        @NonNull
        private KNNEngine knnEngine;
        @NonNull
        private String indexName;
        private String fieldName;
        private float[] vector;
        private float[] originalVector;
        private byte[] byteVector;
        private VectorDataType vectorDataType;
        private Map<String, ?> methodParameters;
        private Integer k;
        private Float radius;
        private QueryBuilder filter;
        private QueryShardContext context;
        private RescoreContext rescoreContext;
        private boolean expandNested;
        private boolean memoryOptimizedSearchEnabled;

        public Optional<QueryBuilder> getFilter() {
            return Optional.ofNullable(this.filter);
        }

        public Optional<QueryShardContext> getContext() {
            return Optional.ofNullable(this.context);
        }

        public Optional<RescoreContext> getRescoreContext() {
            return Optional.ofNullable(this.rescoreContext);
        }

        public boolean isExpandNested() {
            return this.expandNested;
        }

        @Generated
        public static CreateQueryRequestBuilder builder() {
            return new CreateQueryRequestBuilder();
        }

        @Generated
        public CreateQueryRequest(@NonNull KNNEngine knnEngine, @NonNull String indexName, String fieldName, float[] vector, float[] originalVector, byte[] byteVector, VectorDataType vectorDataType, Map<String, ?> methodParameters, Integer k, Float radius, QueryBuilder filter, QueryShardContext context, RescoreContext rescoreContext, boolean expandNested, boolean memoryOptimizedSearchEnabled) {
            if (knnEngine == null) {
                throw new NullPointerException("knnEngine is marked non-null but is null");
            }
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.knnEngine = knnEngine;
            this.indexName = indexName;
            this.fieldName = fieldName;
            this.vector = vector;
            this.originalVector = originalVector;
            this.byteVector = byteVector;
            this.vectorDataType = vectorDataType;
            this.methodParameters = methodParameters;
            this.k = k;
            this.radius = radius;
            this.filter = filter;
            this.context = context;
            this.rescoreContext = rescoreContext;
            this.expandNested = expandNested;
            this.memoryOptimizedSearchEnabled = memoryOptimizedSearchEnabled;
        }

        @NonNull
        @Generated
        public KNNEngine getKnnEngine() {
            return this.knnEngine;
        }

        @NonNull
        @Generated
        public String getIndexName() {
            return this.indexName;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public float[] getVector() {
            return this.vector;
        }

        @Generated
        public float[] getOriginalVector() {
            return this.originalVector;
        }

        @Generated
        public byte[] getByteVector() {
            return this.byteVector;
        }

        @Generated
        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        @Generated
        public Map<String, ?> getMethodParameters() {
            return this.methodParameters;
        }

        @Generated
        public Integer getK() {
            return this.k;
        }

        @Generated
        public Float getRadius() {
            return this.radius;
        }

        @Generated
        public boolean isMemoryOptimizedSearchEnabled() {
            return this.memoryOptimizedSearchEnabled;
        }

        @Generated
        public static class CreateQueryRequestBuilder {
            @Generated
            private KNNEngine knnEngine;
            @Generated
            private String indexName;
            @Generated
            private String fieldName;
            @Generated
            private float[] vector;
            @Generated
            private float[] originalVector;
            @Generated
            private byte[] byteVector;
            @Generated
            private VectorDataType vectorDataType;
            @Generated
            private Map<String, ?> methodParameters;
            @Generated
            private Integer k;
            @Generated
            private Float radius;
            @Generated
            private QueryBuilder filter;
            @Generated
            private QueryShardContext context;
            @Generated
            private RescoreContext rescoreContext;
            @Generated
            private boolean expandNested;
            @Generated
            private boolean memoryOptimizedSearchEnabled;

            @Generated
            CreateQueryRequestBuilder() {
            }

            @Generated
            public CreateQueryRequestBuilder knnEngine(@NonNull KNNEngine knnEngine) {
                if (knnEngine == null) {
                    throw new NullPointerException("knnEngine is marked non-null but is null");
                }
                this.knnEngine = knnEngine;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder indexName(@NonNull String indexName) {
                if (indexName == null) {
                    throw new NullPointerException("indexName is marked non-null but is null");
                }
                this.indexName = indexName;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder vector(float[] vector) {
                this.vector = vector;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder originalVector(float[] originalVector) {
                this.originalVector = originalVector;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder byteVector(byte[] byteVector) {
                this.byteVector = byteVector;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder vectorDataType(VectorDataType vectorDataType) {
                this.vectorDataType = vectorDataType;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder methodParameters(Map<String, ?> methodParameters) {
                this.methodParameters = methodParameters;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder k(Integer k) {
                this.k = k;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder radius(Float radius) {
                this.radius = radius;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder filter(QueryBuilder filter) {
                this.filter = filter;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder context(QueryShardContext context) {
                this.context = context;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder rescoreContext(RescoreContext rescoreContext) {
                this.rescoreContext = rescoreContext;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder expandNested(boolean expandNested) {
                this.expandNested = expandNested;
                return this;
            }

            @Generated
            public CreateQueryRequestBuilder memoryOptimizedSearchEnabled(boolean memoryOptimizedSearchEnabled) {
                this.memoryOptimizedSearchEnabled = memoryOptimizedSearchEnabled;
                return this;
            }

            @Generated
            public CreateQueryRequest build() {
                return new CreateQueryRequest(this.knnEngine, this.indexName, this.fieldName, this.vector, this.originalVector, this.byteVector, this.vectorDataType, this.methodParameters, this.k, this.radius, this.filter, this.context, this.rescoreContext, this.expandNested, this.memoryOptimizedSearchEnabled);
            }

            @Generated
            public String toString() {
                return "BaseQueryFactory.CreateQueryRequest.CreateQueryRequestBuilder(knnEngine=" + String.valueOf(this.knnEngine) + ", indexName=" + this.indexName + ", fieldName=" + this.fieldName + ", vector=" + Arrays.toString(this.vector) + ", originalVector=" + Arrays.toString(this.originalVector) + ", byteVector=" + Arrays.toString(this.byteVector) + ", vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", methodParameters=" + String.valueOf(this.methodParameters) + ", k=" + this.k + ", radius=" + this.radius + ", filter=" + String.valueOf(this.filter) + ", context=" + String.valueOf(this.context) + ", rescoreContext=" + String.valueOf(this.rescoreContext) + ", expandNested=" + this.expandNested + ", memoryOptimizedSearchEnabled=" + this.memoryOptimizedSearchEnabled + ")";
            }
        }
    }
}

