/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationParams;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.knn.index.engine.faiss.QFrameBitEncoder;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;

public class ScalarQuantizationParams
implements QuantizationParams {
    private final ScalarQuantizationType sqType;
    private final boolean enableRandomRotation;
    private final boolean enableADC;

    public static String generateTypeIdentifier(ScalarQuantizationType sqType) {
        return ScalarQuantizationParams.generateIdentifier(sqType.getId());
    }

    @Override
    public String getTypeIdentifier() {
        return ScalarQuantizationParams.generateIdentifier(this.sqType.getId());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sqType.getId());
        out.writeBoolean(this.enableRandomRotation);
        out.writeBoolean(this.enableADC);
    }

    public ScalarQuantizationParams(StreamInput in, int version) throws IOException {
        int typeId = in.readVInt();
        this.sqType = ScalarQuantizationType.fromId(typeId);
        if (Version.fromId((int)version).onOrAfter(Version.V_3_2_0)) {
            this.enableRandomRotation = in.readBoolean();
            this.enableADC = in.readBoolean();
        } else {
            this.enableRandomRotation = QFrameBitEncoder.DEFAULT_ENABLE_RANDOM_ROTATION;
            this.enableADC = QFrameBitEncoder.DEFAULT_ENABLE_ADC;
        }
    }

    private static String generateIdentifier(int id) {
        return "ScalarQuantizationParams_" + id;
    }

    @Generated
    private static boolean $default$enableRandomRotation() {
        return QFrameBitEncoder.DEFAULT_ENABLE_RANDOM_ROTATION;
    }

    @Generated
    private static boolean $default$enableADC() {
        return QFrameBitEncoder.DEFAULT_ENABLE_ADC;
    }

    @Generated
    public static ScalarQuantizationParamsBuilder builder() {
        return new ScalarQuantizationParamsBuilder();
    }

    @Generated
    public ScalarQuantizationType getSqType() {
        return this.sqType;
    }

    @Generated
    public boolean isEnableRandomRotation() {
        return this.enableRandomRotation;
    }

    @Generated
    public boolean isEnableADC() {
        return this.enableADC;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalarQuantizationParams)) {
            return false;
        }
        ScalarQuantizationParams other = (ScalarQuantizationParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableRandomRotation() != other.isEnableRandomRotation()) {
            return false;
        }
        if (this.isEnableADC() != other.isEnableADC()) {
            return false;
        }
        ScalarQuantizationType this$sqType = this.getSqType();
        ScalarQuantizationType other$sqType = other.getSqType();
        return !(this$sqType == null ? other$sqType != null : !((Object)((Object)this$sqType)).equals((Object)other$sqType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScalarQuantizationParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableRandomRotation() ? 79 : 97);
        result = result * 59 + (this.isEnableADC() ? 79 : 97);
        ScalarQuantizationType $sqType = this.getSqType();
        result = result * 59 + ($sqType == null ? 43 : ((Object)((Object)$sqType)).hashCode());
        return result;
    }

    @Generated
    public ScalarQuantizationParams(ScalarQuantizationType sqType, boolean enableRandomRotation, boolean enableADC) {
        this.sqType = sqType;
        this.enableRandomRotation = enableRandomRotation;
        this.enableADC = enableADC;
    }

    @Generated
    public ScalarQuantizationParams() {
        this.sqType = null;
        this.enableRandomRotation = ScalarQuantizationParams.$default$enableRandomRotation();
        this.enableADC = ScalarQuantizationParams.$default$enableADC();
    }

    @Generated
    public static class ScalarQuantizationParamsBuilder {
        @Generated
        private ScalarQuantizationType sqType;
        @Generated
        private boolean enableRandomRotation$set;
        @Generated
        private boolean enableRandomRotation$value;
        @Generated
        private boolean enableADC$set;
        @Generated
        private boolean enableADC$value;

        @Generated
        ScalarQuantizationParamsBuilder() {
        }

        @Generated
        public ScalarQuantizationParamsBuilder sqType(ScalarQuantizationType sqType) {
            this.sqType = sqType;
            return this;
        }

        @Generated
        public ScalarQuantizationParamsBuilder enableRandomRotation(boolean enableRandomRotation) {
            this.enableRandomRotation$value = enableRandomRotation;
            this.enableRandomRotation$set = true;
            return this;
        }

        @Generated
        public ScalarQuantizationParamsBuilder enableADC(boolean enableADC) {
            this.enableADC$value = enableADC;
            this.enableADC$set = true;
            return this;
        }

        @Generated
        public ScalarQuantizationParams build() {
            boolean enableRandomRotation$value = this.enableRandomRotation$value;
            if (!this.enableRandomRotation$set) {
                enableRandomRotation$value = ScalarQuantizationParams.$default$enableRandomRotation();
            }
            boolean enableADC$value = this.enableADC$value;
            if (!this.enableADC$set) {
                enableADC$value = ScalarQuantizationParams.$default$enableADC();
            }
            return new ScalarQuantizationParams(this.sqType, enableRandomRotation$value, enableADC$value);
        }

        @Generated
        public String toString() {
            return "ScalarQuantizationParams.ScalarQuantizationParamsBuilder(sqType=" + String.valueOf((Object)this.sqType) + ", enableRandomRotation$value=" + this.enableRandomRotation$value + ", enableADC$value=" + this.enableADC$value + ")";
        }
    }
}

