/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;

public class FSTCompletion {
    public static final int DEFAULT_BUCKETS = 10;
    private static final ArrayList<Completion> EMPTY_RESULT = new ArrayList();
    private final FST<Object> automaton;
    private final FST.Arc<Object>[] rootArcs;
    private final boolean exactFirst;
    private final boolean higherWeightsFirst;

    public FSTCompletion(FST<Object> automaton, boolean higherWeightsFirst, boolean exactFirst) {
        this.automaton = automaton;
        this.rootArcs = automaton != null ? FSTCompletion.cacheRootArcs(automaton) : new FST.Arc[0];
        this.higherWeightsFirst = higherWeightsFirst;
        this.exactFirst = exactFirst;
    }

    public FSTCompletion(FST<Object> automaton) {
        this(automaton, true, true);
    }

    private static FST.Arc<Object>[] cacheRootArcs(FST<Object> automaton) {
        try {
            ArrayList<FST.Arc> rootArcs = new ArrayList<FST.Arc>();
            FST.Arc arc = automaton.getFirstArc(new FST.Arc());
            FST.BytesReader fstReader = automaton.getBytesReader();
            automaton.readFirstTargetArc(arc, arc, fstReader);
            while (true) {
                rootArcs.add(new FST.Arc().copyFrom(arc));
                if (arc.isLast()) break;
                automaton.readNextArc(arc, fstReader);
            }
            Collections.reverse(rootArcs);
            return rootArcs.toArray(new FST.Arc[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getExactMatchStartingFromRootArc(int rootArcIndex, BytesRef utf8) {
        try {
            FST.Arc scratch = new FST.Arc();
            FST.BytesReader fstReader = this.automaton.getBytesReader();
            while (rootArcIndex < this.rootArcs.length) {
                FST.Arc<Object> rootArc = this.rootArcs[rootArcIndex];
                FST.Arc arc = scratch.copyFrom(rootArc);
                if (this.descendWithPrefix((FST.Arc<Object>)arc, utf8)) {
                    this.automaton.readFirstTargetArc(arc, arc, fstReader);
                    if (arc.label() == -1) {
                        return rootArc.label();
                    }
                }
                ++rootArcIndex;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return -1;
    }

    public List<Completion> lookup(CharSequence key, int num) {
        if (key.isEmpty() || this.automaton == null) {
            return EMPTY_RESULT;
        }
        if (!this.higherWeightsFirst && this.rootArcs.length > 1) {
            return this.lookup(key).sorted().limit(num).toList();
        }
        return this.lookup(key).limit(num).toList();
    }

    public Stream<Completion> lookup(CharSequence key) {
        if (key.isEmpty() || this.automaton == null) {
            return Stream.empty();
        }
        try {
            return this.lookupSortedByWeight(new BytesRef(key));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Completion> lookupSortedByWeight(BytesRef key) throws IOException {
        Completion exactCompletion;
        if (this.exactFirst) {
            Completion c = null;
            for (int i2 = 0; i2 < this.rootArcs.length; ++i2) {
                int exactMatchBucket = this.getExactMatchStartingFromRootArc(i2, key);
                if (exactMatchBucket == -1) continue;
                c = new Completion(key, exactMatchBucket);
                break;
            }
            exactCompletion = c;
        } else {
            exactCompletion = null;
        }
        Stream<Completion> stream = IntStream.range(0, this.rootArcs.length).boxed().flatMap(i -> {
            try {
                FST.Arc<Object> rootArc = this.rootArcs[i];
                FST.Arc arc = new FST.Arc().copyFrom(rootArc);
                if (this.descendWithPrefix((FST.Arc<Object>)arc, key)) {
                    BytesRef output = BytesRef.deepCopyOf((BytesRef)key);
                    output.length = key.length;
                    return this.completionStream(output, rootArc.label(), (FST.Arc<Object>)arc);
                }
                return Stream.empty();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (this.exactFirst && exactCompletion != null) {
            stream = Stream.concat(Stream.of(exactCompletion), stream.filter(completion -> exactCompletion.compareTo((Completion)completion) != 0));
        }
        return stream;
    }

    private Stream<? extends Completion> completionStream(final BytesRef output, final int bucket, FST.Arc<Object> fromArc) throws IOException {
        final FST.BytesReader fstReader = this.automaton.getBytesReader();
        final ArrayDeque<State> states = new ArrayDeque<State>();
        class State {
            final FST.Arc<Object> arc;
            final int outputLength;
            final /* synthetic */ FST.BytesReader val$fstReader;

            State(FST.Arc<Object> arc, int outputLength) throws IOException {
                this.val$fstReader = var4_4;
                this.arc = this$0.automaton.readFirstTargetArc(arc, new FST.Arc(), this.val$fstReader);
                this.outputLength = outputLength;
            }
        }
        states.addLast(new State(this, fromArc, output.length, fstReader));
        return StreamSupport.stream(new Spliterator<Completion>(){

            @Override
            public boolean tryAdvance(Consumer<? super Completion> action) {
                try {
                    while (!states.isEmpty()) {
                        State state = (State)states.peekLast();
                        output.length = state.outputLength;
                        FST.Arc<Object> arc = state.arc;
                        int arcLabel = arc.label();
                        if (arcLabel == -1) {
                            Completion completion = new Completion(output, bucket);
                            action.accept(completion);
                            if (arc.isLast()) {
                                states.removeLast();
                            } else {
                                FSTCompletion.this.automaton.readNextArc(arc, fstReader);
                            }
                            return true;
                        }
                        assert (output.offset == 0);
                        if (output.length == output.bytes.length) {
                            output.bytes = ArrayUtil.grow((byte[])output.bytes);
                        }
                        output.bytes[output.length++] = (byte)arcLabel;
                        State newState = new State(FSTCompletion.this, arc, output.length, fstReader);
                        if (arc.isLast()) {
                            states.removeLast();
                        } else {
                            FSTCompletion.this.automaton.readNextArc(arc, fstReader);
                        }
                        states.addLast(newState);
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Spliterator<Completion> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 272;
            }
        }, false);
    }

    private boolean descendWithPrefix(FST.Arc<Object> arc, BytesRef utf8) throws IOException {
        int max = utf8.offset + utf8.length;
        FST.BytesReader fstReader = this.automaton.getBytesReader();
        for (int i = utf8.offset; i < max; ++i) {
            if (this.automaton.findTargetArc(utf8.bytes[i] & 0xFF, arc, arc, fstReader) != null) continue;
            return false;
        }
        return true;
    }

    public int getBucketCount() {
        return this.rootArcs.length;
    }

    public int getBucket(CharSequence key) {
        return this.getExactMatchStartingFromRootArc(0, new BytesRef(key));
    }

    public FST<Object> getFST() {
        return this.automaton;
    }

    public static final class Completion
    implements Comparable<Completion> {
        public final BytesRef utf8;
        public final int bucket;

        Completion(BytesRef key, int bucket) {
            this.utf8 = BytesRef.deepCopyOf((BytesRef)key);
            this.bucket = bucket;
        }

        public String toString() {
            return this.utf8.utf8ToString() + "/" + this.bucket;
        }

        @Override
        public int compareTo(Completion o) {
            return this.utf8.compareTo(o.utf8);
        }
    }
}

