/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import java.io.IOException;
import java.util.Map;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ShardOperationFailedException;
import org.opensearch.protobufs.ClusterStatistics;
import org.opensearch.protobufs.PhaseTook;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.transport.grpc.proto.response.search.ProtoActionsProtoUtils;
import org.opensearch.transport.grpc.proto.response.search.SearchResponseSectionsProtoUtils;

public class SearchResponseProtoUtils {
    private SearchResponseProtoUtils() {
    }

    public static SearchResponse toProto(org.opensearch.action.search.SearchResponse response) throws IOException {
        SearchResponse.Builder searchResponseProtoBuilder = SearchResponse.newBuilder();
        SearchResponseProtoUtils.toProto(response, searchResponseProtoBuilder);
        return searchResponseProtoBuilder.build();
    }

    public static void toProto(org.opensearch.action.search.SearchResponse response, SearchResponse.Builder searchResponseProtoBuilder) throws IOException {
        if (response.getScrollId() != null) {
            searchResponseProtoBuilder.setXScrollId(response.getScrollId());
        }
        if (response.pointInTimeId() != null) {
            searchResponseProtoBuilder.setPitId(response.pointInTimeId());
        }
        searchResponseProtoBuilder.setTook(response.getTook().getMillis());
        searchResponseProtoBuilder.setTimedOut(response.isTimedOut());
        if (response.getPhaseTook() != null) {
            PhaseTook.Builder phaseTookBuilder = PhaseTook.newBuilder();
            PhaseTookProtoUtils.toProto(response.getPhaseTook(), phaseTookBuilder);
            searchResponseProtoBuilder.setPhaseTook(phaseTookBuilder.build());
        }
        if (response.isTerminatedEarly() != null) {
            searchResponseProtoBuilder.setTerminatedEarly(response.isTerminatedEarly().booleanValue());
        }
        if (response.getNumReducePhases() != 1) {
            searchResponseProtoBuilder.setNumReducePhases(response.getNumReducePhases());
        }
        ProtoActionsProtoUtils.buildBroadcastShardsHeader(searchResponseProtoBuilder, response.getTotalShards(), response.getSuccessfulShards(), response.getSkippedShards(), response.getFailedShards(), (ShardOperationFailedException[])response.getShardFailures());
        ClustersProtoUtils.toProto(searchResponseProtoBuilder, response.getClusters());
        SearchResponseSectionsProtoUtils.toProto(searchResponseProtoBuilder, response);
    }

    protected static class PhaseTookProtoUtils {
        private PhaseTookProtoUtils() {
        }

        protected static void toProto(SearchResponse.PhaseTook phaseTook, PhaseTook.Builder phaseTookProtoBuilder) {
            if (phaseTook == null) {
                return;
            }
            Map phaseTookMap = phaseTook.getPhaseTookMap();
            block8: for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
                long value = phaseTookMap.getOrDefault(searchPhaseName.getName(), 0L);
                switch (searchPhaseName) {
                    case DFS_PRE_QUERY: {
                        phaseTookProtoBuilder.setDfsPreQuery(value);
                        continue block8;
                    }
                    case QUERY: {
                        phaseTookProtoBuilder.setQuery(value);
                        continue block8;
                    }
                    case FETCH: {
                        phaseTookProtoBuilder.setFetch(value);
                        continue block8;
                    }
                    case DFS_QUERY: {
                        phaseTookProtoBuilder.setDfsQuery(value);
                        continue block8;
                    }
                    case EXPAND: {
                        phaseTookProtoBuilder.setExpand(value);
                        continue block8;
                    }
                    case CAN_MATCH: {
                        phaseTookProtoBuilder.setCanMatch(value);
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException("searchPhaseName cannot be converted to phaseTook protobuf type");
                    }
                }
            }
        }
    }

    protected static class ClustersProtoUtils {
        private ClustersProtoUtils() {
        }

        protected static void toProto(SearchResponse.Builder protoResponseBuilder, SearchResponse.Clusters clusters) {
            if (clusters.getTotal() > 0) {
                ClusterStatistics.Builder clusterStatistics = ClusterStatistics.newBuilder().setTotal(clusters.getTotal()).setSuccessful(clusters.getSuccessful()).setSkipped(clusters.getSkipped());
                protoResponseBuilder.setXClusters(clusterStatistics.build());
            }
        }
    }
}

