/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.FileUtils;

public class WebAuthnMetadataService {
    private static final String FILE_NAME = "keycloak-webauthn-metadata.json";
    private Map<String, String> aaguidToProviderNames;

    private Map<String, String> readMetadata() {
        Map<String, String> map;
        block8: {
            InputStream is = FileUtils.getJsonFileFromClasspathOrConfFolder(FILE_NAME);
            try {
                Map map2 = (Map)JsonSerialization.readValue((InputStream)is, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
                map = map2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    String value = (String)((Map)entry.getValue()).get("name");
                    if (value == null) {
                        throw new IllegalStateException("Not found 'name' for the AAGUID '" + (String)entry.getKey() + "' in the file 'keycloak-webauthn-metadata.json'.");
                    }
                    return value;
                }));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Error loading the webauthn metadata from file keycloak-webauthn-metadata.json", ioe);
                }
            }
            is.close();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAaguidToProviderNames() {
        if (this.aaguidToProviderNames == null) {
            WebAuthnMetadataService webAuthnMetadataService = this;
            synchronized (webAuthnMetadataService) {
                if (this.aaguidToProviderNames == null) {
                    this.aaguidToProviderNames = this.readMetadata();
                }
            }
        }
        return this.aaguidToProviderNames;
    }

    public String getAuthenticatorProvider(String aaguid) {
        return aaguid == null ? null : this.getAaguidToProviderNames().get(aaguid);
    }
}

