/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.listeners;

import java.lang.invoke.MethodHandles;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

abstract class BaseUserSessionExpirationListener {
    protected static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final KeycloakSessionFactory factory;
    private final BlockingManager blockingManager;

    BaseUserSessionExpirationListener(KeycloakSessionFactory factory, BlockingManager blockingManager) {
        this.factory = factory;
        this.blockingManager = blockingManager;
    }

    protected void sendExpirationEvent(String userSessionId, String userId, String realmId) {
        this.blockingManager.runBlocking(() -> this.doSend(userSessionId, userId, realmId), (Object)("expired-" + userSessionId));
    }

    private void doSend(String userSessionId, String userId, String realmId) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, session -> {
            logger.debugf("User session expired. sessionId=%s, userId=%s, realmId=%s", (Object)userSessionId, (Object)userId, (Object)realmId);
            RealmModel realm = session.realms().getRealm(realmId);
            if (realm == null) {
                return;
            }
            session.getContext().setRealm(realm);
            new EventBuilder(realm, session).session(userSessionId).user(userId).event(EventType.USER_SESSION_DELETED).detail("reason", "user_session_expired").success();
        });
    }
}

