/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.EnumSet;
import java.util.Set;
import org.infinispan.security.AuthorizationPermission;

public class SubjectACL {
    private final Set<String> roles;
    private final int mask;

    public SubjectACL(Set<String> roles, int mask) {
        this.roles = Set.copyOf(roles);
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean containsRole(String role) {
        return this.roles.contains(role);
    }

    public boolean matches(int permissionMask) {
        return (this.mask & permissionMask) == permissionMask;
    }

    public String toString() {
        return "SubjectACL [roles=" + String.valueOf(this.roles) + ", mask=" + this.mask + "]";
    }

    public EnumSet<AuthorizationPermission> getPermissions() {
        EnumSet<AuthorizationPermission> permissions = EnumSet.noneOf(AuthorizationPermission.class);
        for (AuthorizationPermission permission : AuthorizationPermission.values()) {
            if ((this.mask & permission.getMask()) == 0) continue;
            permissions.add(permission);
        }
        return permissions;
    }
}

