/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPTransaction;

public class LDAPStorageUserManager {
    private final Map<String, LDAPObject> managedLDAPObjects = new HashMap<String, LDAPObject>();
    private final Map<String, ManagedUserEntry> managedUsers = new HashMap<String, ManagedUserEntry>();
    private final LDAPStorageProvider provider;

    public LDAPStorageUserManager(LDAPStorageProvider provider) {
        this.provider = provider;
    }

    public UserModel getManagedProxiedUser(String userId) {
        ManagedUserEntry entry = this.managedUsers.get(userId);
        return entry == null ? null : entry.getManagedProxiedUser();
    }

    public LDAPObject getManagedLDAPObject(String userId) {
        ManagedUserEntry entry = this.managedUsers.get(userId);
        if (entry != null) {
            return entry.getLdapUser();
        }
        return this.managedLDAPObjects.get(userId);
    }

    public void setManagedLDAPObject(String userId, LDAPObject ldapObject) {
        LDAPObject object = this.managedLDAPObjects.get(userId);
        if (object != null) {
            throw new IllegalStateException("Don't expect to have ldap object for user " + userId);
        }
        this.managedLDAPObjects.put(userId, ldapObject);
    }

    public LDAPTransaction getTransaction(String userId) {
        ManagedUserEntry entry = this.managedUsers.get(userId);
        if (entry == null) {
            throw new IllegalStateException("Shouldn't happen to not have entry for userId: " + userId);
        }
        return entry.getLdapTransaction();
    }

    public void setManagedProxiedUser(UserModel proxiedUser, LDAPObject ldapObject) {
        String userId = proxiedUser.getId();
        ManagedUserEntry entry = this.managedUsers.get(userId);
        if (entry != null) {
            throw new IllegalStateException("Don't expect to have entry for user " + userId);
        }
        LDAPTransaction ldapTransaction = new LDAPTransaction(this.provider, ldapObject);
        ManagedUserEntry newEntry = new ManagedUserEntry(proxiedUser, ldapObject, ldapTransaction);
        this.managedUsers.put(userId, newEntry);
    }

    public void removeManagedUserEntry(String userId) {
        this.managedUsers.remove(userId);
    }

    private static class ManagedUserEntry {
        private final UserModel managedProxiedUser;
        private final LDAPObject ldapUser;
        private final LDAPTransaction ldapTransaction;

        public ManagedUserEntry(UserModel managedProxiedUser, LDAPObject ldapUser, LDAPTransaction ldapTransaction) {
            this.managedProxiedUser = managedProxiedUser;
            this.ldapUser = ldapUser;
            this.ldapTransaction = ldapTransaction;
        }

        public UserModel getManagedProxiedUser() {
            return this.managedProxiedUser;
        }

        public LDAPObject getLdapUser() {
            return this.ldapUser;
        }

        public LDAPTransaction getLdapTransaction() {
            return this.ldapTransaction;
        }
    }
}

