/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.impl.wrappers.ContextualConsumer;
import java.util.function.Consumer;

public class ContextualConsumerN<T>
implements ContextualConsumer<T> {
    private ThreadLocal<Object>[] tl;
    private Object[] state;
    private final Consumer<T> consumer;

    public ContextualConsumerN(Consumer<T> consumer, int n) {
        this.consumer = consumer;
        this.tl = new ThreadLocal[n];
        this.state = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t) {
        int i;
        Object[] moved = new Object[this.tl.length];
        for (i = 0; i < this.tl.length; ++i) {
            moved[i] = this.tl[i].get();
            this.tl[i].set(this.state[i]);
        }
        try {
            this.consumer.accept(t);
        }
        finally {
            for (i = 0; i < this.tl.length; ++i) {
                this.tl[i].set(moved[i]);
            }
        }
    }

    @Override
    public void captureThreadLocal(int index, ThreadLocal<Object> threadLocal, Object value) {
        if (index < 0 || index >= this.state.length) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        this.tl[index] = threadLocal;
        this.state[index] = value;
    }
}

