import { __exports as iteratorProxy } from '../../../../_virtual/iteratorProxy.js';

var hasRequiredIteratorProxy;

function requireIteratorProxy () {
	if (hasRequiredIteratorProxy) return iteratorProxy;
	hasRequiredIteratorProxy = 1;

	Object.defineProperty(iteratorProxy, "__esModule", {
	  value: true
	});
	iteratorProxy.default = undefined;

	// eslint-disable-next-line no-unused-vars
	function iteratorProxy$1() {
	  var values = this;
	  var index = 0;
	  var iter = {
	    '@@iterator': function iterator() {
	      return iter;
	    },
	    next: function next() {
	      if (index < values.length) {
	        var value = values[index];
	        index = index + 1;
	        return {
	          done: false,
	          value: value
	        };
	      } else {
	        return {
	          done: true
	        };
	      }
	    }
	  };
	  return iter;
	}
	var _default = iteratorProxy$1;
	iteratorProxy.default = _default;
	return iteratorProxy;
}

export { requireIteratorProxy as __require };
//# sourceMappingURL=iteratorProxy.js.map
