/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.InstanceHolder;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    public static final boolean isEnabledAggregated = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.report-aggregated-stats-to-otel", true);
    public static final boolean isEnabledDetailed = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.listen", false);

    public static boolean isDetailedWatcherEnabled() {
        return isEnabledDetailed;
    }

    public static boolean isAggregatedWatcherEnabled() {
        return isEnabledAggregated;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application app;
        if (!EventWatcher.isDetailedWatcherEnabled() && !EventWatcher.isAggregatedWatcherEnabled()) {
            return null;
        }
        EventWatcher result2 = InstanceHolder.instance;
        if (result2 == null && LoadingState.COMPONENTS_LOADED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            InstanceHolder.instance = result2 = app.getService(EventWatcher.class);
        }
        return result2;
    }

    public void runnableTaskFinished(@NotNull Runnable var1, long var2, int var4, long var5, boolean var7);
}

