/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.component;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.component.ConfigurationVariantMapping;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.jspecify.annotations.Nullable;

public class DefaultAdhocSoftwareComponent
implements AdhocComponentWithVariants,
SoftwareComponentInternal {
    private final String componentName;
    private final ObjectFactory objectFactory;
    private final List<ConfigurationVariantAction> actions;
    private @Nullable ImmutableSet<UsageContext> cachedVariants;

    @Inject
    public DefaultAdhocSoftwareComponent(String componentName, ObjectFactory objectFactory) {
        this.componentName = componentName;
        this.objectFactory = objectFactory;
        this.actions = new ArrayList<ConfigurationVariantAction>();
    }

    public String getName() {
        return this.componentName;
    }

    public void addVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> spec) {
        this.checkNotObserved();
        this.actions.add(new ConfigurationVariantAction(() -> outgoingConfiguration, spec, false));
    }

    public void addVariantsFromConfiguration(Provider<ConsumableConfiguration> outgoingConfiguration, Action<? super ConfigurationVariantDetails> action) {
        this.checkNotObserved();
        this.actions.add(new ConfigurationVariantAction(() -> outgoingConfiguration.get(), action, false));
    }

    public void withVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> action) {
        this.checkNotObserved();
        this.actions.add(new ConfigurationVariantAction(() -> outgoingConfiguration, action, true));
    }

    public void withVariantsFromConfiguration(Provider<ConsumableConfiguration> outgoingConfiguration, Action<? super ConfigurationVariantDetails> action) {
        this.checkNotObserved();
        this.actions.add(new ConfigurationVariantAction(() -> outgoingConfiguration.get(), action, true));
    }

    public Set<? extends UsageContext> getUsages() {
        if (this.cachedVariants == null) {
            this.cachedVariants = this.computeVariants();
        }
        return this.cachedVariants;
    }

    private ImmutableSet<UsageContext> computeVariants() {
        LinkedHashMap<Configuration, ConfigurationVariantMapping> variants = new LinkedHashMap<Configuration, ConfigurationVariantMapping>(4);
        for (ConfigurationVariantAction action : this.actions) {
            Configuration configuration = action.getConfiguration();
            if (!action.isMutate()) {
                variants.put(configuration, new ConfigurationVariantMapping((ConfigurationInternal)configuration, action.getSpec(), this.objectFactory));
                continue;
            }
            if (!variants.containsKey(configuration)) {
                throw new InvalidUserDataException("Variant for configuration '" + configuration.getName() + "' does not exist in component '" + this.componentName + "'. For a given configuration, 'addVariantsFromConfiguration' must be called before 'withVariantsFromConfiguration'.");
            }
            ((ConfigurationVariantMapping)variants.get(configuration)).addAction(action.getSpec());
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (ConfigurationVariantMapping variant : variants.values()) {
            variant.collectVariants(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    protected void checkNotObserved() {
        if (this.cachedVariants != null) {
            throw new MetadataModificationException("Gradle Module Metadata can't be modified after an eagerly populated publication.");
        }
    }

    private static final class ConfigurationVariantAction {
        private final Supplier<Configuration> configuration;
        private final Action<? super ConfigurationVariantDetails> spec;
        private final boolean mutate;

        public ConfigurationVariantAction(Supplier<Configuration> configuration, Action<? super ConfigurationVariantDetails> spec, boolean mutate) {
            this.configuration = configuration;
            this.spec = spec;
            this.mutate = mutate;
        }

        public Configuration getConfiguration() {
            return this.configuration.get();
        }

        public Action<? super ConfigurationVariantDetails> getSpec() {
            return this.spec;
        }

        public boolean isMutate() {
            return this.mutate;
        }
    }

    public static final class MetadataModificationException
    extends GradleException
    implements ResolutionProvider {
        public MetadataModificationException(String message) {
            super(message);
        }

        public List<String> getResolutions() {
            return Collections.singletonList(Documentation.upgradeMinorGuide((int)8, (String)"gmm_modification_after_publication_populated").getConsultDocumentationMessage());
        }
    }
}

