/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractVariableRemapper;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessorKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="JvmOptimizationLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "Transformer", "backend.jvm.lower"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public JvmOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        return Intrinsics.areEqual((Object)$this$isObjectEquals.getName().asString(), (Object)"equals") && IrUtilsKt.hasShape$default($this$isObjectEquals, true, false, 0, 1, null, 22, null) && IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getParameters().get(1).getType());
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair pair;
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.context.getIrBuiltIns().getEqeqSymbol()) || this.isObjectEquals((IrFunction)call2.getSymbol().getOwner())) {
            Object e2 = call2.getArguments().get(0);
            Intrinsics.checkNotNull(e2);
            IrExpression left = (IrExpression)e2;
            Object e3 = call2.getArguments().get(1);
            Intrinsics.checkNotNull(e3);
            IrExpression right = (IrExpression)e3;
            pair = TuplesKt.to((Object)left, (Object)right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren(new Transformer(irFile.getFileEntry(), IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context)), null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "<init>", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNegation(IrExpression expression2) {
            if (!(expression2 instanceof IrCall)) return false;
            IrSimpleFunction not = (IrSimpleFunction)((IrCall)expression2).getSymbol().getOwner();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)not.getName(), (Object)OperatorNameConventions.NOT)) return false;
            if (!IrUtilsKt.hasShape$default(not, true, false, 0, 0, null, 30, null)) return false;
            if (!IrTypePredicatesKt.isBoolean(not.getParameters().get(0).getType())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002J \u0010 \u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020&2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020&H\u0002J\u001e\u0010)\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+\u0018\u00010*2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\f\u0010,\u001a\u00020-*\u00020\u000eH\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010\u0015*\u00020&H\u0002J\u001a\u0010/\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00101\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u000202H\u0002J$\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u0002022\b\u00105\u001a\u0004\u0018\u00010\u00132\u0006\u00106\u001a\u00020-H\u0002J\u0018\u00107\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002022\u0006\u00108\u001a\u00020+H\u0002J\u0018\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;Lorg/jetbrains/kotlin/ir/IrFileEntry;Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "dontTouchTemporaryVals", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "data", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "optimizePropertyAccess", "unwrapSingleExpressionBlock", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "getInlineableValueForTemporaryVal", "statement", "removeUnnecessaryTemporaryVariables", "", "statements", "", "removeUnnecessaryIrTypeOperatorCall", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "reuseLoopVariableAsInductionVariableIfPossible", "irForLoopBlock", "findLoopVariablePosition", "Lkotlin/Pair;", "", "isLoopVariable", "", "rewritePostfixIncrDecr", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "rewritePrefixIncrDecr", "rewriteCompoundAssignmentAsPrefixIncrDecr", "value", "isMinus", "prefixIncr", "delta", "hasSameLineNumber", "e1", "Lorg/jetbrains/kotlin/ir/IrElement;", "e2", "getLineNumberForOffset", "offset", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,513:1\n1#2:514\n79#3,8:515\n223#4,6:523\n133#5:529\n134#5:533\n1761#6,3:530\n774#6:534\n865#6,2:535\n1869#6,2:537\n360#6,7:539\n360#6,7:546\n*S KotlinDebug\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n*L\n106#1:515,8\n106#1:523,6\n106#1:529\n106#1:533\n111#1:530,3\n274#1:534\n274#1:535,2\n282#1:537,2\n323#1:539,7\n366#1:546,7\n*E\n"})
    private final class Transformer
    extends IrTransformer<IrDeclaration> {
        @NotNull
        private final IrFileEntry fileEntry;
        @NotNull
        private final IrInlineScopeResolver inlineScopeResolver;
        @NotNull
        private final HashSet<IrVariable> dontTouchTemporaryVals;

        public Transformer(@NotNull IrFileEntry fileEntry, IrInlineScopeResolver inlineScopeResolver) {
            Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
            Intrinsics.checkNotNullParameter((Object)inlineScopeResolver, (String)"inlineScopeResolver");
            this.fileEntry = fileEntry;
            this.inlineScopeResolver = inlineScopeResolver;
            this.dontTouchTemporaryVals = new HashSet();
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return super.visitDeclaration(declaration, declaration);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
                return this.optimizePropertyAccess(expression2, data);
            }
            if (Companion.isNegation(expression2)) {
                Companion companion = Companion;
                IrExpression irExpression = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression);
                if (companion.isNegation(irExpression)) {
                    IrExpression irExpression2 = expression2.getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                    IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression3);
                    return irExpression3;
                }
            }
            Pair pair = JvmOptimizationLowering.this.getOperandsIfCallToEQEQOrEquals(expression2);
            if (pair != null) {
                Pair pair2 = pair;
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                Pair pair3 = pair2;
                boolean bl = false;
                IrExpression left = (IrExpression)pair3.component1();
                IrExpression right = (IrExpression)pair3.component2();
                if (IrUtilsKt.isNullConst(left) && IrUtilsKt.isNullConst(right)) {
                    return IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (IrUtilsKt.isNullConst(left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                    return IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
            }
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression optimizePropertyAccess(IrCall expression2, IrDeclaration data) {
            IrExpression irExpression;
            boolean bl;
            void $this$optimizePropertyAccess_u24lambda_u240;
            Transformer transformer2;
            void this_$iv$iv$iv;
            IrExpression receiver;
            IrField backingField;
            block15: {
                void origin$iv$iv;
                void endOffset$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlock$iv$iv;
                void $this$irBlock_u24default$iv;
                Object object;
                IrElement irElement;
                IrSimpleFunction accessor;
                block17: {
                    block16: {
                        accessor = (IrSimpleFunction)expression2.getSymbol().getOwner();
                        if (accessor.getModality() != Modality.FINAL || accessor.isExternal()) {
                            return expression2;
                        }
                        Object object2 = accessor.getCorrespondingPropertySymbol();
                        if (object2 == null || (object2 = (IrProperty)object2.getOwner()) == null) {
                            return expression2;
                        }
                        Object property2 = object2;
                        if (((IrProperty)property2).isLateinit()) {
                            return expression2;
                        }
                        IrField irField = ((IrProperty)property2).getBackingField();
                        if (irField == null) {
                            return expression2;
                        }
                        backingField = irField;
                        irElement = data;
                        if (irElement == null) break block16;
                        object = irElement;
                        IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
                        IrElement p0 = (IrElement)object;
                        boolean bl2 = false;
                        IrDeclarationContainer irDeclarationContainer = irInlineScopeResolver.findContainer(p0);
                        irElement = irDeclarationContainer;
                        if (irDeclarationContainer != null) break block17;
                    }
                    return expression2;
                }
                IrElement scope2 = irElement;
                if (!Intrinsics.areEqual((Object)scope2, (Object)accessor.getParent()) || !Intrinsics.areEqual((Object)scope2, (Object)backingField.getParent())) {
                    return expression2;
                }
                receiver = expression2.getDispatchReceiver();
                object = LowerUtilsKt.createIrBuilder(JvmOptimizationLowering.this.getContext(), (IrSymbol)expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                IrExpression expression$iv = expression2;
                Object origin$iv = null;
                IrType resultType$iv = expression$iv.getType();
                int startOffset$iv = expression$iv.getStartOffset();
                int endOffset$iv = expression$iv.getEndOffset();
                boolean $i$f$irBlock = false;
                void var15_16 = $this$irBlock_u24default$iv;
                int n2 = startOffset$iv;
                int n3 = endOffset$iv;
                Object var18_19 = origin$iv;
                IrType resultType$iv$iv = resultType$iv;
                boolean $i$f$irBlock2 = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, (int)endOffset$iv$iv, (IrStatementOrigin)origin$iv$iv, resultType$iv$iv, false, 64, null);
                boolean $i$f$block = false;
                void var23_24 = this_$iv$iv$iv;
                transformer2 = this;
                boolean bl3 = false;
                if (backingField.isStatic() && receiver != null && !(receiver instanceof IrGetValue)) {
                    $this$optimizePropertyAccess_u24lambda_u240.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$optimizePropertyAccess_u24lambda_u240.getContext().getIrBuiltIns()));
                }
                Iterable $this$any$iv = accessor.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl4 = false;
                        if (!(it.getKind() == IrParameterKind.Regular)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                IrExpression $i$f$any = irExpression = receiver;
                IrBuilder irBuilder = (IrBuilder)$this$optimizePropertyAccess_u24lambda_u240;
                void var32_39 = $this$optimizePropertyAccess_u24lambda_u240;
                boolean bl5 = false;
                boolean bl6 = backingField.isStatic();
                IrExpression irExpression2 = !bl6 ? irExpression : null;
                Object object = CollectionsKt.last((List)expression2.getArguments());
                Intrinsics.checkNotNull((Object)object);
                var32_39.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilder, irExpression2, backingField, (IrExpression)object, null, 8, null));
            } else {
                IrExpression it = irExpression = receiver;
                IrBuilder irBuilder = (IrBuilder)$this$optimizePropertyAccess_u24lambda_u240;
                void var32_40 = $this$optimizePropertyAccess_u24lambda_u240;
                boolean bl7 = false;
                boolean bl8 = backingField.isStatic();
                var32_40.unaryPlus(ExpressionHelpersKt.irGetField(irBuilder, !bl8 ? irExpression : null, backingField, expression2.getType()));
            }
            return transformer2.unwrapSingleExpressionBlock((IrExpression)this_$iv$iv$iv.doBuild());
        }

        private final IrExpression unwrapSingleExpressionBlock(IrExpression $this$unwrapSingleExpressionBlock) {
            IrStatement irStatement;
            Object object = $this$unwrapSingleExpressionBlock instanceof IrBlock ? (IrBlock)$this$unwrapSingleExpressionBlock : null;
            IrStatement irStatement2 = irStatement = object != null && (object = object.getStatements()) != null ? (IrStatement)CollectionsKt.singleOrNull((List)object) : null;
            IrExpression irExpression = irStatement instanceof IrExpression ? (IrExpression)irStatement : null;
            if (irExpression == null) {
                irExpression = $this$unwrapSingleExpressionBlock;
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            boolean isCompilerGenerated = expression2.getOrigin() == null;
            expression2.transformChildren(this, data);
            expression2.getBranches().removeIf(arg_0 -> Transformer.visitWhen$lambda$1(arg_0 -> Transformer.visitWhen$lambda$0(isCompilerGenerated, arg_0), arg_0));
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getANDAND())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl2 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32);
                }
                IrCallImpl $this$visitWhen_u24lambda_u243 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getAndandSymbol(), null, null, 48, null);
                boolean bl3 = false;
                $this$visitWhen_u24lambda_u243.getArguments().set(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u243.getArguments().set(1, expression2.getBranches().get(0).getResult());
                return irCallImpl;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getOROR())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl4 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52);
                }
                IrCallImpl $this$visitWhen_u24lambda_u245 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getOrorSymbol(), null, null, 48, null);
                boolean bl5 = false;
                $this$visitWhen_u24lambda_u245.getArguments().set(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u245.getArguments().set(1, expression2.getBranches().get(1).getResult());
                return irCallImpl;
            }
            if (expression2.getBranches().size() == 0) {
                return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
            IrBranch firstBranch = (IrBranch)CollectionsKt.first(expression2.getBranches());
            if (IrUtilsKt.isTrueConst(firstBranch.getCondition()) && isCompilerGenerated) {
                return firstBranch.getResult();
            }
            return expression2;
        }

        private final IrExpression getInlineableValueForTemporaryVal(IrStatement statement) {
            IrVariable irVariable = statement instanceof IrVariable ? (IrVariable)statement : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable variable = irVariable;
            if (!Intrinsics.areEqual((Object)variable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) || variable.isVar()) {
                return null;
            }
            if (this.dontTouchTemporaryVals.contains(variable)) {
                return null;
            }
            IrExpression initializer = variable.getInitializer();
            if (initializer instanceof IrConst) {
                return initializer;
            }
            if (initializer instanceof IrGetValue) {
                IrValueDeclaration initializerValue = ((IrGetValue)initializer).getSymbol().getOwner();
                if (initializerValue instanceof IrVariable) {
                    IrExpression irExpression;
                    if (((IrVariable)initializerValue).isVar()) {
                        irExpression = null;
                    } else if (Intrinsics.areEqual((Object)initializerValue.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE())) {
                        irExpression = this.getInlineableValueForTemporaryVal(initializerValue);
                        if (irExpression == null) {
                            irExpression = initializer;
                        }
                    } else {
                        irExpression = initializer;
                    }
                    return irExpression;
                }
                if (initializerValue instanceof IrValueParameter) {
                    return ((IrValueParameter)initializerValue).isAssignable() ? null : initializer;
                }
            }
            return null;
        }

        private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements) {
            block2: {
                statements.removeIf(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda$1(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda$0(this, arg_0), arg_0));
                if (statements.size() != 2) break block2;
                IrStatement first = statements.get(0);
                IrStatement second = statements.get(1);
                if (first instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)first).getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) && second instanceof IrGetValue && Intrinsics.areEqual((Object)((IrVariable)first).getSymbol(), (Object)((IrGetValue)second).getSymbol())) {
                    statements.clear();
                    IrExpression irExpression = ((IrVariable)first).getInitializer();
                    if (irExpression != null) {
                        IrExpression it = irExpression;
                        boolean bl = false;
                        statements.add(it);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnnecessaryIrTypeOperatorCall(List<IrStatement> statements, IrDeclaration data) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = statements;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrStatement it = (IrStatement)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)it).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT && ((IrTypeOperatorCall)it).getArgument() instanceof IrGetField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typeOperatorCalls = (List)destination$iv$iv;
            if (typeOperatorCalls.isEmpty()) {
                return;
            }
            Iterable $this$forEach$iv = typeOperatorCalls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall");
                IrExpression irExpression = ((IrTypeOperatorCall)it).getArgument();
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetField");
                IrField arg = (IrField)((IrGetField)irExpression).getSymbol().getOwner();
                IrDeclaration irDeclaration = data;
                if (!Intrinsics.areEqual((Object)IrUtilsKt.getParentClassOrNull(arg), (Object)(irDeclaration != null ? IrUtilsKt.getParentClassOrNull(irDeclaration) : null))) continue;
                statements.remove(it);
            }
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            body.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(body.getStatements());
            return body;
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclaration data) {
            IrCall irCall;
            IrStatement subject;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN()) && (subject = (IrStatement)CollectionsKt.firstOrNull(expression2.getStatements())) instanceof IrVariable && ((IrVariable)subject).getInitializer() instanceof IrGetValue) {
                this.dontTouchTemporaryVals.add((IrVariable)subject);
            }
            if ((Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR()) || Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR())) && (irCall = this.rewritePostfixIncrDecr(expression2)) != null) {
                IrCall it = irCall;
                boolean bl = false;
                return it;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP())) {
                this.reuseLoopVariableAsInductionVariableIfPossible(expression2);
            }
            expression2.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
            this.removeUnnecessaryIrTypeOperatorCall(expression2.getStatements(), data);
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final void reuseLoopVariableAsInductionVariableIfPossible(IrContainerExpression irForLoopBlock) {
            int inductionVariableIndex;
            IrStatement it;
            IrComposite loopInitialization;
            block13: {
                int n2;
                void $this$indexOfFirst$iv;
                if (irForLoopBlock.getStatements().size() != 2) {
                    return;
                }
                Object object = irForLoopBlock.getStatements().get(0);
                IrComposite irComposite = object instanceof IrComposite ? (IrComposite)object : null;
                if (irComposite == null) {
                    return;
                }
                loopInitialization = irComposite;
                object = loopInitialization.getStatements();
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (IrStatement)item$iv;
                    boolean bl = false;
                    if (HeaderProcessorKt.isInductionVariable(it, jvmOptimizationLowering.getContext())) {
                        n2 = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n2 = inductionVariableIndex = -1;
            }
            if (inductionVariableIndex < 0) {
                return;
            }
            IrStatement $i$f$indexOfFirst = loopInitialization.getStatements().get(inductionVariableIndex);
            IrVariable irVariable = $i$f$indexOfFirst instanceof IrVariable ? (IrVariable)$i$f$indexOfFirst : null;
            if (irVariable == null) {
                return;
            }
            IrVariable inductionVariable = irVariable;
            Pair<IrContainerExpression, Integer> pair = this.findLoopVariablePosition(irForLoopBlock.getStatements().get(1));
            if (pair == null) {
                return;
            }
            Pair<IrContainerExpression, Integer> loopVariablePosition = pair;
            IrContainerExpression loopVariableContainer = (IrContainerExpression)loopVariablePosition.component1();
            int loopVariableIndex = ((Number)loopVariablePosition.component2()).intValue();
            it = loopVariableContainer.getStatements().get(loopVariableIndex);
            IrVariable irVariable2 = it instanceof IrVariable ? (IrVariable)it : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable loopVariable = irVariable2;
            IrExpression irExpression = loopVariable.getInitializer();
            if (irExpression == null) {
                return;
            }
            IrExpression loopVariableInitializer = irExpression;
            if (!(loopVariableInitializer instanceof IrGetValue)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((IrGetValue)loopVariableInitializer).getSymbol(), (Object)inductionVariable.getSymbol())) {
                return;
            }
            IrType inductionVariableType = inductionVariable.getType();
            IrType loopVariableType = loopVariable.getType();
            if (IrTypeUtilsKt.isNullable(loopVariableType)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull(loopVariableType), (Object)IrTypesKt.getClassifierOrNull(inductionVariableType))) {
                return;
            }
            IrVariableImpl newLoopVariable = BuildersKt.IrVariableImpl(loopVariable.getStartOffset(), loopVariable.getEndOffset(), loopVariable.getOrigin(), new IrVariableSymbolImpl(null, 1, null), loopVariable.getName(), loopVariableType, true, false, false);
            newLoopVariable.setInitializer(inductionVariable.getInitializer());
            newLoopVariable.setParent(inductionVariable.getParent());
            loopInitialization.getStatements().set(inductionVariableIndex, newLoopVariable);
            loopVariableContainer.getStatements().remove(loopVariableIndex);
            AbstractVariableRemapper remapper2 = new AbstractVariableRemapper(inductionVariable, loopVariable, newLoopVariable){
                final /* synthetic */ IrVariable $inductionVariable;
                final /* synthetic */ IrVariable $loopVariable;
                final /* synthetic */ IrVariableImpl $newLoopVariable;
                {
                    this.$inductionVariable = $inductionVariable;
                    this.$loopVariable = $loopVariable;
                    this.$newLoopVariable = $newLoopVariable;
                }

                protected IrValueDeclaration remapVariable(IrValueDeclaration value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return Intrinsics.areEqual((Object)value2, (Object)this.$inductionVariable) || Intrinsics.areEqual((Object)value2, (Object)this.$loopVariable) ? (IrValueDeclaration)this.$newLoopVariable : null;
                }
            };
            irForLoopBlock.getStatements().get(1).transformChildren(remapper2, null);
        }

        private final Pair<IrContainerExpression, Integer> findLoopVariablePosition(IrStatement statement) {
            IrStatement irStatement = statement;
            if (irStatement instanceof IrDoWhileLoop) {
                int loopVariableIndex;
                IrComposite iterationInitialization;
                block10: {
                    int n2;
                    if (!Intrinsics.areEqual((Object)((IrDoWhileLoop)statement).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getDO_WHILE_COUNTER_LOOP())) {
                        return null;
                    }
                    IrExpression irExpression = ((IrDoWhileLoop)statement).getBody();
                    IrComposite irComposite = irExpression instanceof IrComposite ? (IrComposite)irExpression : null;
                    if (irComposite == null) {
                        return null;
                    }
                    IrComposite doWhileLoopBody = irComposite;
                    if (!Intrinsics.areEqual((Object)doWhileLoopBody.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE())) {
                        return null;
                    }
                    IrStatement irStatement2 = doWhileLoopBody.getStatements().get(0);
                    IrComposite irComposite2 = irStatement2 instanceof IrComposite ? (IrComposite)irStatement2 : null;
                    if (irComposite2 == null) {
                        return null;
                    }
                    iterationInitialization = irComposite2;
                    List<IrStatement> $this$indexOfFirst$iv = iterationInitialization.getStatements();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<IrStatement> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        IrStatement item$iv;
                        IrStatement it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (this.isLoopVariable(it)) {
                            n2 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n2 = loopVariableIndex = -1;
                }
                if (loopVariableIndex < 0) {
                    return null;
                }
                return TuplesKt.to((Object)iterationInitialization, (Object)loopVariableIndex);
            }
            if (irStatement instanceof IrWhen) {
                IrExpression irExpression = ((IrWhen)statement).getBranches().get(0).getResult();
                IrDoWhileLoop irDoWhileLoop = irExpression instanceof IrDoWhileLoop ? (IrDoWhileLoop)irExpression : null;
                if (irDoWhileLoop == null) {
                    return null;
                }
                IrDoWhileLoop doWhileLoop = irDoWhileLoop;
                return this.findLoopVariablePosition(doWhileLoop);
            }
            return null;
        }

        private final boolean isLoopVariable(IrStatement $this$isLoopVariable) {
            return $this$isLoopVariable instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)$this$isLoopVariable).getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_VARIABLE());
        }

        private final IrCall rewritePostfixIncrDecr(IrContainerExpression $this$rewritePostfixIncrDecr) {
            if (!Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR()) && !Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR())) {
                return null;
            }
            IrStatement irStatement = $this$rewritePostfixIncrDecr.getStatements().get(0);
            IrVariable irVariable = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable tmpVar = irVariable;
            IrExpression irExpression = tmpVar.getInitializer();
            IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            if (irGetValue == null) {
                return null;
            }
            IrGetValue getIncrVar = irGetValue;
            if (!IrTypePredicatesKt.isInt(getIncrVar.getType())) {
                return null;
            }
            IrStatement irStatement2 = $this$rewritePostfixIncrDecr.getStatements().get(1);
            IrSetValue irSetValue = irStatement2 instanceof IrSetValue ? (IrSetValue)irStatement2 : null;
            if (irSetValue == null) {
                return null;
            }
            IrSetValue setVar = irSetValue;
            if (!Intrinsics.areEqual((Object)setVar.getSymbol(), (Object)getIncrVar.getSymbol())) {
                return null;
            }
            IrExpression irExpression2 = setVar.getValue();
            IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
            if (irCall == null) {
                return null;
            }
            IrCall setVarValue = irCall;
            Name calleeName = ((IrSimpleFunction)setVarValue.getSymbol().getOwner()).getName();
            if (!Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) && !Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.DEC)) {
                return null;
            }
            IrExpression irExpression3 = setVarValue.getDispatchReceiver();
            IrGetValue irGetValue2 = irExpression3 instanceof IrGetValue ? (IrGetValue)irExpression3 : null;
            if (irGetValue2 == null) {
                return null;
            }
            IrGetValue calleeArg = irGetValue2;
            if (!Intrinsics.areEqual((Object)calleeArg.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrStatement irStatement3 = $this$rewritePostfixIncrDecr.getStatements().get(2);
            IrGetValue irGetValue3 = irStatement3 instanceof IrGetValue ? (IrGetValue)irStatement3 : null;
            if (irGetValue3 == null) {
                return null;
            }
            IrGetValue getTmpVar = irGetValue3;
            if (!Intrinsics.areEqual((Object)getTmpVar.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrConstImpl delta = Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) ? IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), 1) : IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), -1);
            IrStatement $this$rewritePostfixIncrDecr_u24lambda_u240 = irStatement3 = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getSymbols().getIntPostfixIncrDecr());
            boolean bl = false;
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u240).getArguments().set(0, getIncrVar);
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u240).getArguments().set(1, delta);
            return (IrCall)irStatement3;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration variable = expression2.getSymbol().getOwner();
            IrExpression replacement = this.getInlineableValueForTemporaryVal(variable);
            return replacement instanceof IrConst ? (IrExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrConstImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrConst)replacement).getType(), ((IrConst)replacement).getKind(), ((IrConst)replacement).getValue()) : (replacement instanceof IrGetValue ? (IrExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrGetValue)replacement).getType(), ((IrGetValue)replacement).getSymbol(), ((IrGetValue)replacement).getOrigin()) : (IrExpression)expression2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            IrExpression irExpression = this.rewritePrefixIncrDecr(expression2);
            if (irExpression == null) {
                irExpression = expression2;
            }
            return irExpression;
        }

        private final IrExpression rewritePrefixIncrDecr(IrSetValue expression2) {
            if (!IrTypePredicatesKt.isInt(expression2.getSymbol().getOwner().getType())) {
                return null;
            }
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_DECR())) {
                return this.prefixIncr(expression2, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) ? 1 : -1);
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPLUSEQ()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getMINUSEQ())) {
                IrExpression irExpression = expression2.getValue();
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                Object e2 = ((IrCall)irExpression).getArguments().get(1);
                Intrinsics.checkNotNull(e2);
                IrExpression argument = (IrExpression)e2;
                if (!this.hasSameLineNumber(argument, expression2)) {
                    return null;
                }
                return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getMINUSEQ()));
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getEQ())) {
                IrExpression value2 = expression2.getValue();
                if (!this.hasSameLineNumber(value2, expression2)) {
                    return null;
                }
                if (value2 instanceof IrCall) {
                    IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)((IrCall)value2).getArguments(), (int)0);
                    if (irExpression == null) {
                        return null;
                    }
                    IrExpression receiver = irExpression;
                    IrValueSymbol symbol = expression2.getSymbol();
                    if (!this.hasSameLineNumber(receiver, expression2)) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getPLUS()) || Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS())) {
                        Object e3 = ((IrCall)value2).getArguments().get(1);
                        Intrinsics.checkNotNull(e3);
                        IrExpression argument = (IrExpression)e3;
                        if (receiver instanceof IrGetValue && Intrinsics.areEqual((Object)((IrGetValue)receiver).getSymbol(), (Object)symbol) && this.hasSameLineNumber(argument, expression2)) {
                            return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument, Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS()));
                        }
                    }
                }
            }
            return null;
        }

        private final IrExpression rewriteCompoundAssignmentAsPrefixIncrDecr(IrSetValue expression2, IrExpression value2, boolean isMinus) {
            if (value2 instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)value2).getKind(), (Object)IrConstKind.Int.INSTANCE)) {
                Object object = ((IrConst)value2).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int delta = (Integer)object;
                int upperBound = 127 + (isMinus ? 1 : 0);
                int lowerBound = -128 + (isMinus ? 1 : 0);
                boolean bl = lowerBound <= delta ? delta <= upperBound : false;
                if (bl) {
                    return this.prefixIncr(expression2, isMinus ? -delta : delta);
                }
            }
            return null;
        }

        private final IrExpression prefixIncr(IrSetValue expression2, int delta) {
            int startOffset = expression2.getStartOffset();
            int endOffset = expression2.getEndOffset();
            IrCallImpl irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner(IrCallImpl.Companion, startOffset, endOffset, JvmOptimizationLowering.this.getContext().getSymbols().getIntPrefixIncrDecr());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrCallImpl $this$prefixIncr_u24lambda_u240 = irCallImpl;
            boolean bl = false;
            $this$prefixIncr_u24lambda_u240.getArguments().set(0, org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(startOffset, endOffset, expression2.getSymbol(), null, 8, null));
            $this$prefixIncr_u24lambda_u240.getArguments().set(1, IrConstImpl.Companion.int(startOffset, endOffset, jvmOptimizationLowering.getContext().getIrBuiltIns().getIntType(), delta));
            return irCallImpl;
        }

        private final boolean hasSameLineNumber(IrElement e1, IrElement e2) {
            return this.getLineNumberForOffset(e1.getStartOffset()) == this.getLineNumberForOffset(e2.getStartOffset());
        }

        private final int getLineNumberForOffset(int offset) {
            return this.fileEntry.getLineNumber(offset) + 1;
        }

        private static final boolean visitWhen$lambda$0(boolean $isCompilerGenerated, IrBranch it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return IrUtilsKt.isFalseConst(it.getCondition()) && $isCompilerGenerated;
        }

        private static final boolean visitWhen$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda$0(Transformer this$0, IrStatement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.getInlineableValueForTemporaryVal(it) != null;
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

