/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JvmDebugSpec;
import org.gradle.util.internal.ArgumentsSplitter;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmOptions {
    private static final String XMS_PREFIX = "-Xms";
    private static final String XMX_PREFIX = "-Xmx";
    private static final String BOOTCLASSPATH_PREFIX = "-Xbootclasspath:";
    public static final String FILE_ENCODING_KEY = "file.encoding";
    public static final String USER_LANGUAGE_KEY = "user.language";
    public static final String USER_COUNTRY_KEY = "user.country";
    public static final String USER_VARIANT_KEY = "user.variant";
    public static final String JMX_REMOTE_KEY = "com.sun.management.jmxremote";
    public static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    public static final String JAVA_SECURITY_PROPERTIES_KEY = "java.security.properties";
    public static final String JDK_ENABLE_ADS_KEY = "jdk.io.File.enableADS";
    public static final String SSL_KEYSTORE_KEY = "javax.net.ssl.keyStore";
    public static final String SSL_KEYSTOREPASSWORD_KEY = "javax.net.ssl.keyStorePassword";
    public static final String SSL_KEYSTORETYPE_KEY = "javax.net.ssl.keyStoreType";
    public static final String SSL_TRUSTSTORE_KEY = "javax.net.ssl.trustStore";
    public static final String SSL_TRUSTPASSWORD_KEY = "javax.net.ssl.trustStorePassword";
    public static final String SSL_TRUSTSTORETYPE_KEY = "javax.net.ssl.trustStoreType";
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmOptions.class);
    public static final Collection<String> IMMUTABLE_SYSTEM_PROPERTIES = Arrays.asList("file.encoding", "user.language", "user.country", "user.variant", "com.sun.management.jmxremote", "java.io.tmpdir", "java.security.properties", "jdk.io.File.enableADS", "javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStoreType", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreType", "org.gradle.cache.reserved.mb");
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> mutableSystemProperties = new TreeMap<String, Object>();
    private final FileCollectionFactory fileCollectionFactory;
    private ConfigurableFileCollection bootstrapClasspath;
    private String minHeapSize;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private final JvmDebugSpec debugSpec;
    protected final Map<String, Object> immutableSystemProperties = new TreeMap<String, Object>();

    public JvmOptions(FileCollectionFactory fileCollectionFactory) {
        this(fileCollectionFactory, new JvmDebugSpec.DefaultJvmDebugSpec());
    }

    public JvmOptions(FileCollectionFactory fileCollectionFactory, JvmDebugSpec debugSpec) {
        this.debugSpec = debugSpec;
        this.fileCollectionFactory = fileCollectionFactory;
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, Charset.defaultCharset().name());
        this.immutableSystemProperties.put(USER_LANGUAGE_KEY, DEFAULT_LOCALE.getLanguage());
        this.immutableSystemProperties.put(USER_COUNTRY_KEY, DEFAULT_LOCALE.getCountry());
        this.immutableSystemProperties.put(USER_VARIANT_KEY, DEFAULT_LOCALE.getVariant());
    }

    public List<String> getAllJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.formatSystemProperties(this.getMutableSystemProperties(), args);
        args.addAll(this.getAllImmutableJvmArgs());
        return Collections.unmodifiableList(args);
    }

    protected void formatSystemProperties(Map<String, ?> properties, List<String> args) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue().toString());
                continue;
            }
            args.add("-D" + entry.getKey());
        }
    }

    public List<String> getAllImmutableJvmArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getJvmArgs());
        args.addAll(this.getManagedJvmArgs());
        return args;
    }

    protected List<String> getManagedJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.minHeapSize != null) {
            args.add(XMS_PREFIX + this.minHeapSize);
        }
        if (this.maxHeapSize != null) {
            args.add(XMX_PREFIX + this.maxHeapSize);
        }
        if (this.bootstrapClasspath != null && !this.bootstrapClasspath.isEmpty()) {
            args.add(BOOTCLASSPATH_PREFIX + this.bootstrapClasspath.getAsPath());
        }
        this.formatSystemProperties(this.immutableSystemProperties, args);
        if (this.assertionsEnabled) {
            args.add("-ea");
        }
        if (this.debugSpec.isEnabled()) {
            args.add(this.getDebugArgument());
        }
        return args;
    }

    private String getDebugArgument() {
        return JvmOptions.getDebugArgument(this.debugSpec);
    }

    public static String getDebugArgument(JvmDebugSpec options) {
        boolean server = options.isServer();
        boolean suspend = options.isSuspend();
        int port = options.getPort();
        String host = options.getHost() == null ? "" : options.getHost() + ":";
        String address = host + port;
        return JvmOptions.getDebugArgument(server, suspend, address);
    }

    public static String getDebugArgument(boolean server, boolean suspend, String address) {
        return "-agentlib:jdwp=transport=dt_socket,server=" + (server ? (char)'y' : 'n') + ",suspend=" + (suspend ? (char)'y' : 'n') + ",address=" + address;
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.mutableSystemProperties.clear();
        this.minHeapSize = null;
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.debugSpec.setEnabled(false);
        this.jvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        return this.extraJvmArgs.stream().map(Object::toString).collect(Collectors.toList());
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.jvmArgs(arguments);
    }

    public void setExtraJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.addExtraJvmArgs(arguments);
    }

    public List<Object> getExtraJvmArgs() {
        return this.extraJvmArgs;
    }

    public void checkDebugConfiguration(Iterable<?> arguments) {
        List<String> debugArgs = JvmOptions.collectDebugArgs(arguments);
        if (!debugArgs.isEmpty() && this.debugSpec.isEnabled()) {
            LOGGER.warn("Debug configuration ignored in favor of the supplied JVM arguments: " + debugArgs);
            this.debugSpec.setEnabled(false);
        }
    }

    private static List<String> collectDebugArgs(Iterable<?> arguments) {
        ArrayList<String> debugArgs = new ArrayList<String>();
        for (Object extraJvmArg : arguments) {
            String extraJvmArgString = extraJvmArg.toString();
            if (!JvmOptions.isDebugArg(extraJvmArgString)) continue;
            debugArgs.add(extraJvmArgString);
        }
        return debugArgs;
    }

    private static boolean isDebugArg(String extraJvmArgString) {
        return extraJvmArgString.equals("-Xdebug") || extraJvmArgString.startsWith("-Xrunjdwp") || extraJvmArgString.startsWith("-agentlib:jdwp");
    }

    public void jvmArgs(Iterable<?> arguments) {
        this.addExtraJvmArgs(arguments);
        this.checkDebugConfiguration(this.extraJvmArgs);
    }

    public void jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
    }

    private void addExtraJvmArgs(Iterable<?> arguments) {
        for (Object argument : arguments) {
            String argStr = argument.toString();
            if (argStr.equals("-ea") || argStr.equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (argStr.equals("-da") || argStr.equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            if (argStr.startsWith(XMS_PREFIX)) {
                this.minHeapSize = argStr.substring(XMS_PREFIX.length());
                continue;
            }
            if (argStr.startsWith(XMX_PREFIX)) {
                this.maxHeapSize = argStr.substring(XMX_PREFIX.length());
                continue;
            }
            if (argStr.startsWith(BOOTCLASSPATH_PREFIX)) {
                String[] bootClasspath = StringUtils.split((String)argStr.substring(BOOTCLASSPATH_PREFIX.length()), (char)File.pathSeparatorChar);
                this.setBootstrapClasspath(bootClasspath);
                continue;
            }
            if (argStr.startsWith("-D")) {
                String keyValue = argStr.substring(2);
                int equalsIndex = keyValue.indexOf("=");
                if (equalsIndex == -1) {
                    this.systemProperty(keyValue, "");
                    continue;
                }
                this.systemProperty(keyValue.substring(0, equalsIndex), keyValue.substring(equalsIndex + 1));
                continue;
            }
            this.extraJvmArgs.add(argStr);
        }
    }

    public Map<String, Object> getMutableSystemProperties() {
        return this.mutableSystemProperties;
    }

    public Map<String, Object> getImmutableSystemProperties() {
        return this.immutableSystemProperties;
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.mutableSystemProperties.clear();
        this.systemProperties(properties);
    }

    public void systemProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.systemProperty(entry.getKey(), entry.getValue());
        }
    }

    public void systemProperty(String name, Object value) {
        if (IMMUTABLE_SYSTEM_PROPERTIES.contains(name)) {
            this.immutableSystemProperties.put(name, value);
        } else {
            this.mutableSystemProperties.put(name, value);
        }
    }

    public FileCollection getBootstrapClasspath() {
        return this.internalGetBootstrapClasspath();
    }

    private ConfigurableFileCollection internalGetBootstrapClasspath() {
        if (this.bootstrapClasspath == null) {
            this.bootstrapClasspath = this.fileCollectionFactory.configurableFiles("bootstrap classpath");
        }
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.internalGetBootstrapClasspath().setFrom((Iterable)classpath);
    }

    public void setBootstrapClasspath(Object ... classpath) {
        this.internalGetBootstrapClasspath().setFrom(classpath);
    }

    public void bootstrapClasspath(Object ... classpath) {
        this.internalGetBootstrapClasspath().from(classpath);
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String heapSize) {
        this.minHeapSize = heapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String heapSize) {
        this.maxHeapSize = heapSize;
    }

    public String getDefaultCharacterEncoding() {
        return this.immutableSystemProperties.get(FILE_ENCODING_KEY).toString();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, GUtil.isTrue((Object)defaultCharacterEncoding) ? defaultCharacterEncoding : Charset.defaultCharset().name());
    }

    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    public void setEnableAssertions(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public boolean getDebug() {
        return this.debugSpec.isEnabled();
    }

    public void setDebug(boolean enabled) {
        this.debugSpec.setEnabled(enabled);
    }

    public JvmDebugSpec getDebugSpec() {
        return this.debugSpec;
    }

    public void copyTo(JavaForkOptions target) {
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.mutableSystemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        target.bootstrapClasspath(new Object[]{this.getBootstrapClasspath().getFiles()});
        target.setEnableAssertions(this.assertionsEnabled);
        this.copyDebugOptionsTo(new JvmDebugSpec.JavaDebugOptionsBackedSpec(target.getDebugOptions()));
        target.systemProperties(this.immutableSystemProperties);
    }

    public JvmOptions createCopy(FileCollectionFactory fileCollectionFactory) {
        JvmOptions target = new JvmOptions(fileCollectionFactory);
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.mutableSystemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        if (this.bootstrapClasspath != null) {
            target.setBootstrapClasspath(this.getBootstrapClasspath().getFiles());
        }
        target.setEnableAssertions(this.assertionsEnabled);
        this.copyDebugOptionsTo(target.getDebugSpec());
        target.systemProperties(this.immutableSystemProperties);
        return target;
    }

    private void copyDebugOptionsTo(JvmDebugSpec otherOptions) {
        JvmOptions.copyDebugOptions(this.debugSpec, otherOptions);
    }

    private static void copyDebugOptions(JvmDebugSpec from, JvmDebugSpec to) {
        to.setEnabled(from.isEnabled());
        to.setHost(from.getHost());
        to.setPort(from.getPort());
        to.setServer(from.isServer());
        to.setSuspend(from.isSuspend());
    }

    public static List<String> fromString(String input) {
        return ArgumentsSplitter.split((String)input);
    }
}

